/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfport.impl;

import com.adobe.internal.agm.AGMColor;
import com.adobe.internal.agm.AGMColorSpace;
import com.adobe.internal.agm.AGMGState;
import com.adobe.internal.agm.AGMLineCapStyle;
import com.adobe.internal.agm.AGMLineDashPattern;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFParseException;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.InstructionFactory;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentWriter;

public class PDFPortGState {
    void setGState(ContentWriter portContentWriter, AGMGState agmGState) throws PDFIOException, PDFParseException {
        double[] colorants;
        AGMColorSpace colorSpace;
        AGMColor agmColor;
        if (agmGState.hasFillColor()) {
            agmColor = agmGState.getFillColor();
            colorSpace = agmColor.getColorSpace();
            colorants = agmColor.getColorants();
            if (colorSpace == AGMColorSpace.DeviceGray) {
                Instruction g = InstructionFactory.newDeviceGrayFill(colorants[0]);
                portContentWriter.write(g);
            } else if (colorSpace == AGMColorSpace.DeviceRGB) {
                Instruction rg = InstructionFactory.newDeviceRGBFill(colorants[0], colorants[1], colorants[2]);
                portContentWriter.write(rg);
            } else if (colorSpace == AGMColorSpace.DeviceCMYK) {
                Instruction k = InstructionFactory.newDeviceCMYKFill(colorants[0], colorants[1], colorants[2], colorants[3]);
                portContentWriter.write(k);
            } else {
                throw new PDFParseException("Invalid Fill Color Space: " + (Object)((Object)colorSpace));
            }
        }
        if (agmGState.hasStrokeColor()) {
            agmColor = agmGState.getStrokeColor();
            colorSpace = agmColor.getColorSpace();
            colorants = agmColor.getColorants();
            if (colorSpace == AGMColorSpace.DeviceGray) {
                Instruction G = InstructionFactory.newDeviceGrayStroke(colorants[0]);
                portContentWriter.write(G);
            } else if (colorSpace == AGMColorSpace.DeviceRGB) {
                Instruction RG = InstructionFactory.newDeviceRGBStroke(colorants[0], colorants[1], colorants[2]);
                portContentWriter.write(RG);
            } else if (colorSpace == AGMColorSpace.DeviceCMYK) {
                Instruction K = InstructionFactory.newDeviceCMYKStroke(colorants[0], colorants[1], colorants[2], colorants[3]);
                portContentWriter.write(K);
            } else {
                throw new PDFParseException("Invalid Stroke Color Space: " + (Object)((Object)colorSpace));
            }
        }
        if (agmGState.hasLineWidth()) {
            double lineWidth = agmGState.getLineWidth();
            Instruction w = InstructionFactory.newLineWidth(lineWidth);
            portContentWriter.write(w);
        }
        if (agmGState.hasLineCapStyle()) {
            AGMLineCapStyle lineCapStyle = agmGState.getLineCapStyle();
            Instruction J = InstructionFactory.newLineCapStyle(lineCapStyle.getValue());
            portContentWriter.write(J);
        }
        if (agmGState.hasLineDashPattern()) {
            AGMLineDashPattern lineDashPattern = agmGState.getLineDashPattern();
            Instruction d = InstructionFactory.newLineDashPattern(lineDashPattern.getPattern(), lineDashPattern.getPhase());
            portContentWriter.write(d);
        }
    }
}

