/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa2.xmp;

import com.adobe.internal.pdftoolkit.pdf.utils.PDFUtil;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2XMPSchema;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.PDFA2XMPErrorCollector;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2XMPErrorElementUsedNotDefined;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2XMPErrorInvalidExtensionSchema;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2XMPErrorSchemaUsageNotValid;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.MetadataUsageTreeNode;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPBasicTypeValidator;
import com.adobe.internal.pdftoolkit.xml.XMLElement;
import com.adobe.internal.xmp.XMPException;
import com.adobe.internal.xmp.XMPMeta;
import com.adobe.internal.xmp.options.PropertyOptions;
import com.adobe.internal.xmp.properties.XMPProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

public class XMPSchemaUsageValidator
extends XMLFilterImpl {
    private STATE currentState;
    private MetadataUsageTreeNode metadataUsageTreeNode;
    private Map<String, PDFA2XMPSchema> referenceSchemas;
    private XMPMeta xmpMeta;
    private HashMap<XMLElement, PropertyOptions> invalidUsage;
    public static Map<String, Set<String>> qualifierMap;
    private boolean onlyFixableIssuesFound = true;
    private static final int optionFilter = 7936;
    private Map<String, String> prefixNSMapping = new HashMap<String, String>();
    private PDFA2XMPErrorCollector errorCodes;
    private static final String RDF_DESCRIPTION = "rdf:Description";
    private static final String RDF_ABOUT = "rdf:about";
    private static final String XML_LANG = "xml:lang";
    public static final String RDF_ALT = "rdf:alt";
    public static final String RDF_BAG = "rdf:bag";
    public static final String RDF_SEQ = "rdf:seq";
    public static final String RDF_LI = "rdf:li";
    private StringBuilder fieldValueCollector = null;
    private Attributes rdfAtts;
    private boolean parsingExtensionSchemaDecl = false;
    private static final String PDFAEXTENSION_URI = "http://www.aiim.org/pdfa/ns/extension/";
    private int xmlDepth = -1;
    private Stack<Integer> elementsToSkipDepths = new Stack();

    public static Map<String, Set<String>> getQualifierMap() {
        return qualifierMap;
    }

    public static void setQualifierMap(Map<String, Set<String>> qualifierMap) {
        XMPSchemaUsageValidator.qualifierMap = qualifierMap;
    }

    public XMPSchemaUsageValidator(Map<String, PDFA2XMPSchema> referenceExtensionSchemas, XMPMeta xmpMeta, HashMap<XMLElement, PropertyOptions> invalidUsage, PDFA2XMPErrorCollector errorCodes) {
        this.referenceSchemas = referenceExtensionSchemas;
        this.xmpMeta = xmpMeta;
        this.invalidUsage = invalidUsage;
        this.errorCodes = errorCodes;
        if (PDFUtil.logDebugMessages()) {
            PDFUtil.logDebug("XMPSchemaUsageValidator construction. . referenceExtensionSchemas: " + System.identityHashCode(this.referenceSchemas) + ". this: " + System.identityHashCode(this));
        }
    }

    public PDFA2XMPErrorCollector getErrorCodes() {
        return this.errorCodes;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.fieldValueCollector != null) {
            this.fieldValueCollector.append(ch, start, length);
        }
        super.characters(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        --this.xmlDepth;
        if (uri.equals(PDFAEXTENSION_URI)) {
            this.parsingExtensionSchemaDecl = false;
            super.endElement(uri, localName, name);
            return;
        }
        if (this.parsingExtensionSchemaDecl) {
            super.endElement(uri, localName, name);
            return;
        }
        if (!this.elementsToSkipDepths.isEmpty() && this.elementsToSkipDepths.peek() == this.xmlDepth + 1) {
            this.elementsToSkipDepths.pop();
            super.endElement(uri, localName, name);
            return;
        }
        if (name.equals(RDF_DESCRIPTION)) {
            if (this.currentState == STATE.PROPERTY_PROCESSING) {
                if (this.metadataUsageTreeNode.getNodes() == null && this.rdfAtts != null) {
                    for (int i = 0; i < this.rdfAtts.getLength(); ++i) {
                        String nsURI = this.rdfAtts.getURI(i);
                        String prefix = this.prefixNSMapping.get(nsURI);
                        if (prefix == null || prefix.equals("rdf")) continue;
                        MetadataUsageTreeNode node = this.metadataUsageTreeNode.startElement(nsURI, this.rdfAtts.getLocalName(i), prefix);
                        node.setValue(this.rdfAtts.getValue(i));
                        break;
                    }
                    this.rdfAtts = null;
                }
                MetadataUsageTreeNode node = this.metadataUsageTreeNode;
                this.metadataUsageTreeNode = this.metadataUsageTreeNode.endElement();
                if (this.metadataUsageTreeNode == null) {
                    this.currentState = STATE.XML_ELEMENT_PROCESSING;
                    this.validatePropertyTree(node);
                } else {
                    this.currentState = STATE.PROPERTY_PROCESSING;
                }
            }
        } else if (this.isRDFArray(name)) {
            if (this.currentState == STATE.PROPERTY_PROCESSING) {
                this.metadataUsageTreeNode.endArray();
            }
        } else if (name.equals(RDF_LI)) {
            if (this.currentState == STATE.PROPERTY_PROCESSING) {
                if (this.metadataUsageTreeNode.getNodes() == null && this.fieldValueCollector != null) {
                    this.metadataUsageTreeNode.setValue(this.fieldValueCollector.toString().trim());
                    this.fieldValueCollector = null;
                }
                this.metadataUsageTreeNode = this.metadataUsageTreeNode.endLI();
            }
        } else if (this.currentState == STATE.PROPERTY_PROCESSING) {
            if (this.fieldValueCollector != null) {
                this.metadataUsageTreeNode.setValue(this.fieldValueCollector.toString().trim());
                this.fieldValueCollector = null;
            }
            this.metadataUsageTreeNode = this.metadataUsageTreeNode.endElement();
        }
        super.endElement(uri, localName, name);
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        ++this.xmlDepth;
        if (this.parsingExtensionSchemaDecl) {
            super.startElement(uri, localName, name, atts);
            return;
        }
        if (uri.equals(PDFAEXTENSION_URI)) {
            this.parsingExtensionSchemaDecl = true;
            super.startElement(uri, localName, name, atts);
            return;
        }
        if (name.equals(RDF_DESCRIPTION)) {
            if (this.currentState == STATE.PROPERTY_PROCESSING) {
                this.elementsToSkipDepths.push(this.xmlDepth);
            } else if (atts.getIndex(RDF_ABOUT) != -1) {
                this.rdfAtts = atts;
                this.currentState = STATE.PROPERTY_PROCESSING;
                this.metadataUsageTreeNode = new MetadataUsageTreeNode(null);
                this.metadataUsageTreeNode.setName(name);
            }
        } else if (this.isRDFArray(name)) {
            if (this.currentState == STATE.PROPERTY_PROCESSING) {
                this.metadataUsageTreeNode.startArray(name);
            }
        } else if (name.equals(RDF_LI)) {
            if (this.currentState == STATE.PROPERTY_PROCESSING) {
                if (this.fieldValueCollector == null) {
                    this.fieldValueCollector = new StringBuilder();
                }
                this.metadataUsageTreeNode = this.metadataUsageTreeNode.startLI();
                for (int i = 0; i < atts.getLength(); ++i) {
                    int index;
                    int n = index = atts.getQName(i) != null ? atts.getQName(i).indexOf(58) : 0;
                    if (atts.getLocalName(i).equalsIgnoreCase("parseType") && atts.getQName(i).indexOf("rdf:parseType") != -1 || atts.getIndex(XML_LANG) != -1) continue;
                    MetadataUsageTreeNode childnode = this.metadataUsageTreeNode.startElement(atts.getURI(i), atts.getLocalName(i), atts.getQName(i).substring(0, index));
                    if (atts.getValue(i) == null) continue;
                    childnode.setValue(atts.getValue(i));
                }
                int index = atts.getIndex(XML_LANG);
                if (index != -1) {
                    this.metadataUsageTreeNode.setLanguageQualifier(atts.getValue(index));
                }
            }
        } else if (this.currentState == STATE.PROPERTY_PROCESSING) {
            this.metadataUsageTreeNode = this.metadataUsageTreeNode.startElement(uri, localName, this.prefixNSMapping.get(uri));
            this.fieldValueCollector = new StringBuilder();
        }
        super.startElement(uri, localName, name, atts);
    }

    private boolean isRDFArray(String name) {
        return name != null && (name.equalsIgnoreCase(RDF_ALT) || name.equalsIgnoreCase(RDF_SEQ) || name.equalsIgnoreCase(RDF_BAG));
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.prefixNSMapping.put(uri, prefix);
        super.startPrefixMapping(prefix, uri);
    }

    private void validatePropertyTree(MetadataUsageTreeNode propertyTree) {
        if (PDFUtil.logDebugMessages()) {
            PDFUtil.logDebug("validatePropertyTree., this: " + this + ", thisHash: " + System.identityHashCode(this.referenceSchemas) + ", this.referenceSchemas Hash: " + System.identityHashCode(this.referenceSchemas));
        }
        if (propertyTree.getParentNode() == null) {
            if (PDFUtil.logDebugMessages()) {
                PDFUtil.logDebug("validatePropertyTree. getParentNode is null");
            }
            if (!propertyTree.getName().equals(RDF_DESCRIPTION)) {
                this.onlyFixableIssuesFound = false;
                if (PDFUtil.logDebugMessages()) {
                    PDFUtil.logDebug("validatePropertyTree. ! propertyTree.getName().equals(RDF_DESCRIPTION)");
                }
                this.errorCodes.addErrorCode(propertyTree.getNameSpaceURI(), new PDFA2XMPErrorSchemaUsageNotValid(0, 0));
                return;
            }
            if (PDFUtil.logDebugMessages()) {
                PDFUtil.logDebug("validatePropertyTree. Validate root node");
            }
            if (!propertyTree.isNodeArray()) {
                if (PDFUtil.logDebugMessages()) {
                    PDFUtil.logDebug("validatePropertyTree. post the check for propertyTree.isNodeArray()");
                }
                if (propertyTree.getNodes() == null) {
                    if (PDFUtil.logDebugMessages()) {
                        PDFUtil.logDebug("validatePropertyTree. propertyTree.getNodes() == null");
                    }
                    return;
                }
                if (PDFUtil.logDebugMessages()) {
                    PDFUtil.logDebug("validatePropertyTree. going for propertyTree nodes loop");
                }
                int lc = 0;
                for (MetadataUsageTreeNode node : propertyTree.getNodes()) {
                    ++lc;
                    String uri = node.getNameSpaceURI();
                    PDFA2XMPSchema xmpSchema = this.referenceSchemas.get(uri);
                    if (xmpSchema == null) {
                        this.addToInvalidUsageMap(uri, node.getName());
                        this.errorCodes.addErrorCode(uri, new PDFA2XMPErrorElementUsedNotDefined(0, 0));
                        if (!PDFUtil.logDebugMessages()) continue;
                        PDFUtil.logDebug("Found xmpSchema == null. uri: " + uri + ", node.getName(): " + node.getName());
                        continue;
                    }
                    String name = node.getName();
                    PDFA2XMPSchema.PDFA2XMPProperty prop = xmpSchema.getProperty(name);
                    if (prop == null) {
                        this.addToInvalidUsageMap(uri, node.getName());
                        this.errorCodes.addErrorCode(uri, new PDFA2XMPErrorElementUsedNotDefined(0, 0));
                        if (!PDFUtil.logDebugMessages()) continue;
                        PDFUtil.logDebug("Found prop == null. uri: " + uri + ", node.getName(): " + node.getName());
                        continue;
                    }
                    String valueType = prop.getType();
                    if (valueType == null || valueType.equals("")) {
                        this.errorCodes.addErrorCodeConditional(uri, new PDFA2XMPErrorElementUsedNotDefined(0, 0), new PDFA2XMPErrorInvalidExtensionSchema(0, 0));
                        if (!PDFUtil.logDebugMessages()) continue;
                        PDFUtil.logDebug("Found valueType == null or empty string. uri: " + uri + ", node.getName(): " + node.getName() + ", valueType: " + valueType + "...");
                        continue;
                    }
                    String arrayType = null;
                    if (valueType.toLowerCase().startsWith("alt ") || valueType.toLowerCase().startsWith("bag ") || valueType.toLowerCase().startsWith("seq ")) {
                        arrayType = valueType.substring(0, 3);
                        valueType = valueType.substring(4);
                    }
                    if (!(arrayType == null || arrayType.equalsIgnoreCase(node.getArrayType().toString()) || "http://ns.adobe.com/photoshop/1.0/".equals(uri) && "SupplementalCategories".equals(prop.getName()))) {
                        this.addToInvalidUsageMap(uri, node.getName());
                        this.errorCodes.addErrorCodeConditional(uri, new PDFA2XMPErrorSchemaUsageNotValid(0, 0), new PDFA2XMPErrorInvalidExtensionSchema(0, 0));
                        continue;
                    }
                    if (XMPBasicTypeValidator.isPropertyUsageValid(valueType, node, this.referenceSchemas, false, this.errorCodes, prop, xmpSchema)) continue;
                    if (!"http://ns.adobe.com/photoshop/1.0/".equals(uri) || !"SupplementalCategories".equals(prop.getName())) {
                        this.addToInvalidUsageMap(uri, node.getName());
                        this.errorCodes.addErrorCodeConditional(uri, new PDFA2XMPErrorSchemaUsageNotValid(0, 0), new PDFA2XMPErrorInvalidExtensionSchema(0, 0));
                        continue;
                    }
                    valueType = "Text";
                    if (XMPBasicTypeValidator.isPropertyUsageValid(valueType, node, this.referenceSchemas, false, this.errorCodes, prop, xmpSchema)) continue;
                    this.addToInvalidUsageMap(uri, node.getName());
                    this.errorCodes.addErrorCodeConditional(uri, new PDFA2XMPErrorSchemaUsageNotValid(0, 0), new PDFA2XMPErrorInvalidExtensionSchema(0, 0));
                }
                if (PDFUtil.logDebugMessages()) {
                    PDFUtil.logDebug("validatePropertyTree. Done with propertyTree nodes loop. lc: " + lc);
                }
                return;
            }
            if (PDFUtil.logDebugMessages()) {
                PDFUtil.logDebug("validatePropertyTree. propertyTree.isNodeArray() check; the else case");
            }
            this.onlyFixableIssuesFound = false;
            this.errorCodes.addErrorCodeConditional(propertyTree.getNameSpaceURI(), new PDFA2XMPErrorSchemaUsageNotValid(0, 0), new PDFA2XMPErrorInvalidExtensionSchema(0, 0));
            return;
        }
        if (PDFUtil.logDebugMessages()) {
            PDFUtil.logDebug("validatePropertyTree. the else case. propertyTree.getParentNode() == null");
        }
        this.onlyFixableIssuesFound = false;
        this.errorCodes.addErrorCode(propertyTree.getNameSpaceURI(), new PDFA2XMPErrorSchemaUsageNotValid(0, 0));
    }

    private void addToInvalidUsageMap(String uri, String localName) {
        XMLElement element = new XMLElement(uri, localName);
        XMPProperty prop = null;
        try {
            prop = this.xmpMeta.getProperty(element.getNamespace(), element.getElementName());
            if (prop != null) {
                int type = prop.getOptions().getOptions() & 0x1F00;
                this.invalidUsage.put(element, new PropertyOptions(type));
            } else if (PDFUtil.logDebugMessages()) {
                PDFUtil.logDebug("addToInvalidUsageMap: got null property. element.getNamespace(): " + element.getNamespace() + ", element.getElementName()" + element.getElementName());
            }
        }
        catch (XMPException e) {
            if (e.getErrorCode() != 101) {
                throw new RuntimeException("Exception occured in XMP toolkit", e);
            }
            PDFUtil.logWarning("addToInvalidUsageMap: eating the exception. yummy. errCode: " + e.getErrorCode() + ", e: " + e.toString());
        }
    }

    public boolean isOnlyFixableIssuesFound() {
        return this.onlyFixableIssuesFound;
    }

    private static enum STATE {
        XML_ELEMENT_PROCESSING,
        PROPERTY_PROCESSING;

    }
}

