/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa2.processor;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.content.XObjectsCycleDetector;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpace;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceFactory;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFRenderingIntent;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFGroupAttributes;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectImage;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectPostScript;
import com.adobe.internal.pdftoolkit.pdf.interchange.metadata.PDFMetadata;
import com.adobe.internal.pdftoolkit.pdf.utils.ContentUtil;
import com.adobe.internal.pdftoolkit.services.pdfa.common.PDFXobjectImageColorSpaceAdapter;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConformanceLevel;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConversionOptions;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ValidationOptions;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.PDFA2ErrorSet;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.PDFA2XMPErrorCollector;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractXObjectErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2XObjectErrorAFEntryInXobjectNoValid;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2XObjectErrorAlternateImagesNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2XObjectErrorInterpolationNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2XObjectErrorInvalidRenderingIntent;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2XObjectErrorOPINotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2XObjectErrorPDFGeneralFailure;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2XObjectErrorPSNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2XObjectErrorPostScriptXObjectNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2XObjectErrorReferenceXObjectNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2XObjectErrorSubtype2KeyWithPSValueNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2XObjectErrorSubtypeEntryMissing;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.ColorSpaceProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.ContentProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.DocumentProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.GState;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.Jpeg2000ImageProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.MetadataProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.SharedConstraints;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.TrackingConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.TrackingValidationHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.TransparencyState;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

class XObjectProcessor {
    XObjectProcessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean process(PDFXObjectMap xObjectMap, LinkedHashMap<ASName, ArrayList<GState>> referencedXObjectNames, DocumentProcessor docProcessor, PDFResources parentResources, PDFA2ConformanceLevel conformance, PDFA2ConversionOptions conversionOptions, TrackingConversionHandler conversionHandler, PDFA2ValidationOptions validationOptions, TrackingValidationHandler validationHandler, TransparencyState transparencyInfo) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        if (xObjectMap == null || xObjectMap.isEmpty()) {
            return true;
        }
        XObjectsCycleDetector cycleDetector = XObjectsCycleDetector.getInstance(xObjectMap.getPDFDocument());
        if (referencedXObjectNames == null || referencedXObjectNames.isEmpty()) {
            return true;
        }
        Iterator<Map.Entry<ASName, ArrayList<GState>>> entriesItr = referencedXObjectNames.entrySet().iterator();
        Map.Entry<ASName, ArrayList<GState>> entry = null;
        ASName xObjectName = null;
        ArrayList<GState> gStates = null;
        while (entriesItr.hasNext()) {
            entry = entriesItr.next();
            xObjectName = entry.getKey();
            gStates = entry.getValue();
            PDFXObject xObject = xObjectMap.get(xObjectName);
            if (cycleDetector.cycleDetected(xObject)) {
                throw new PDFInvalidDocumentException("Cyclic dependency found while processing xobjects.");
            }
            cycleDetector.push(xObject);
            try {
                if (XObjectProcessor.process(xObjectName, xObject, docProcessor, parentResources, conformance, conversionOptions, conversionHandler, validationOptions, validationHandler, gStates, transparencyInfo)) continue;
                boolean bl = false;
                return bl;
            }
            finally {
                cycleDetector.pop();
            }
        }
        return true;
    }

    static boolean process(ASName name, PDFXObject xObject, DocumentProcessor docProcessor, PDFResources parentResources, PDFA2ConformanceLevel conformance, PDFA2ConversionOptions conversionOptions, TrackingConversionHandler conversionHandler, PDFA2ValidationOptions validationOptions, TrackingValidationHandler validationHandler, ArrayList<GState> gStates, TransparencyState transparencyInfo) throws PDFIOException, PDFSecurityException {
        if (xObject == null) {
            return true;
        }
        if (!validationHandler.beginXObjectScan(name, xObject)) {
            return false;
        }
        PDFA2ErrorSet<PDFA2AbstractXObjectErrorCode> errorCodes = new PDFA2ErrorSet<PDFA2AbstractXObjectErrorCode>();
        try {
            if (!xObject.dictionaryContains(ASName.k_Subtype)) {
                errorCodes.addErrorCode(new PDFA2XObjectErrorSubtypeEntryMissing(xObject.getCosObject().getObjNum(), xObject.getCosObject().getObjGen()));
            }
            if (xObject instanceof PDFXObjectForm) {
                PDFXObjectForm form;
                PDFMetadata metadata;
                if (conformance == PDFA2ConformanceLevel.Level_3b && !docProcessor.checkAndAddToAssociatedFileSet(xObject.getAssociatedFiles())) {
                    errorCodes.addErrorCode(new PDFA2XObjectErrorAFEntryInXobjectNoValid(xObject.getCosObject().getObjNum(), xObject.getCosObject().getObjGen()));
                }
                if ((metadata = xObject.getMetadata()) != null && metadata.getType() == ASName.k_Metadata && metadata.getSubtype() == ASName.k_XML) {
                    PDFA2XMPErrorCollector errorCodesXMP = new PDFA2XMPErrorCollector();
                    if (!MetadataProcessor.processXMP(docProcessor, xObject.getPDFDocument(), xObject, null, null, null, validationHandler, validationOptions, errorCodesXMP)) {
                        return false;
                    }
                    if (errorCodesXMP.hasErrors() && !validationHandler.type1FormXMPError(errorCodesXMP)) {
                        return false;
                    }
                }
                if ((form = (PDFXObjectForm)xObject).isReferenceXObject()) {
                    errorCodes.addErrorCode(new PDFA2XObjectErrorReferenceXObjectNotAllowed(form.getCosObject().getObjNum(), form.getCosObject().getObjGen()));
                } else {
                    Content content;
                    ASName subType2;
                    if (form.isGroupXObject()) {
                        PDFColorSpace cs;
                        CosObject csValue;
                        PDFGroupAttributes group = form.getGroup();
                        if (group.getSubType() == ASName.k_Transparency) {
                            transparencyInfo.setDetected(true);
                        }
                        if (((csValue = group.getDictionaryCosObjectValue(ASName.k_CS)) instanceof CosArray || csValue instanceof CosName && (csValue.nameValue() == ASName.k_DeviceRGB || csValue.nameValue() == ASName.k_DeviceCMYK || csValue.nameValue() == ASName.k_DeviceGray)) && !ColorSpaceProcessor.process(null, (cs = PDFColorSpaceFactory.getInstance(csValue)).getName(), cs, docProcessor, validationHandler, parentResources, conversionOptions, conversionHandler, gStates)) {
                            return false;
                        }
                    }
                    if (form.dictionaryContains(ASName.k_OPI)) {
                        if (conversionHandler != null && conversionOptions.getRemoveXObjectOPI()) {
                            form.removeValue(ASName.k_OPI);
                            if (!conversionHandler.opiRemovedFromXObject(form)) {
                                return false;
                            }
                        } else {
                            errorCodes.addErrorCode(new PDFA2XObjectErrorOPINotAllowed(form.getCosObject().getObjNum(), form.getCosObject().getObjGen()));
                        }
                    }
                    if (form.getCosDictionary().containsKey(ASName.k_Subtype2) && (subType2 = form.getDictionaryNameValue(ASName.k_Subtype2)).equals(ASName.k_PS)) {
                        if (conversionHandler != null && conversionOptions.getRemoveFormXObjectPSData()) {
                            form.removeValue(ASName.k_Subtype2);
                            if (!conversionHandler.psRemovedFromXObject(form, ASName.k_Subtype2)) {
                                return false;
                            }
                        } else {
                            errorCodes.addErrorCode(new PDFA2XObjectErrorSubtype2KeyWithPSValueNotAllowed(form.getCosObject().getObjNum(), form.getCosObject().getObjGen()));
                        }
                    }
                    if (form.getCosDictionary().containsKey(ASName.k_PS)) {
                        if (conversionHandler != null && conversionOptions.getRemoveFormXObjectPSData()) {
                            form.removeValue(ASName.k_PS);
                            if (!conversionHandler.psRemovedFromXObject(form, ASName.k_PS)) {
                                return false;
                            }
                        } else {
                            errorCodes.addErrorCode(new PDFA2XObjectErrorPSNotAllowed(form.getCosObject().getObjNum(), form.getCosObject().getObjGen()));
                        }
                    }
                    if ((content = ContentUtil.getContent(conversionHandler != null, form, parentResources)) != null) {
                        PDFResources resources;
                        if (gStates == null || gStates.isEmpty()) {
                            if (!ContentProcessor.process(content, form, null, docProcessor, conformance, conversionOptions, conversionHandler, validationOptions, validationHandler, null, transparencyInfo)) {
                                return false;
                            }
                        } else {
                            for (int i = 0; i < gStates.size(); ++i) {
                                if (ContentProcessor.process(content, form, null, docProcessor, conformance, conversionOptions, conversionHandler, validationOptions, validationHandler, gStates.get(i), transparencyInfo)) continue;
                                return false;
                            }
                        }
                        if (conversionHandler != null && content.resourcesDetached() && !(resources = content.getResources()).isEmpty()) {
                            form.setResources(content.getResources());
                        }
                    }
                }
            } else if (xObject instanceof PDFXObjectImage) {
                boolean defaultGraySet;
                boolean defaultCMYKSet;
                boolean defaultRGBSet;
                CosObject imageSmaskCosObject;
                ASName oldIntent;
                if (!docProcessor.checkAndAddToAssociatedFileSet(xObject.getAssociatedFiles())) {
                    errorCodes.addErrorCode(new PDFA2XObjectErrorAFEntryInXobjectNoValid(xObject.getCosObject().getObjNum(), xObject.getCosObject().getObjGen()));
                }
                PDFMetadata metadata = xObject.getMetadata();
                PDFA2XMPErrorCollector errorCodesXMP = new PDFA2XMPErrorCollector();
                if (metadata != null && !MetadataProcessor.processXMP(docProcessor, xObject.getPDFDocument(), xObject, null, null, null, validationHandler, validationOptions, errorCodesXMP)) {
                    return false;
                }
                if (errorCodesXMP.hasErrors() && !validationHandler.imageXMPError(errorCodesXMP)) {
                    return false;
                }
                PDFXObjectImage image = (PDFXObjectImage)xObject;
                if (image.dictionaryContains(ASName.k_Alternates)) {
                    if (conversionHandler != null && conversionOptions.getRemoveImageAlternates()) {
                        image.removeValue(ASName.k_Alternates);
                        if (!conversionHandler.alternatesRemovedFromImage(image)) {
                            return false;
                        }
                    } else {
                        errorCodes.addErrorCode(new PDFA2XObjectErrorAlternateImagesNotAllowed(image.getCosObject().getObjNum(), image.getCosObject().getObjGen()));
                    }
                }
                if (image.dictionaryContains(ASName.k_OPI)) {
                    if (conversionHandler != null && conversionOptions.getRemoveXObjectOPI()) {
                        image.removeValue(ASName.k_OPI);
                        if (!conversionHandler.opiRemovedFromXObject(image)) {
                            return false;
                        }
                    } else {
                        errorCodes.addErrorCode(new PDFA2XObjectErrorOPINotAllowed(image.getCosObject().getObjNum(), image.getCosObject().getObjGen()));
                    }
                }
                if (image.dictionaryContains(ASName.k_Interpolate) && image.getDictionaryBooleanValue(ASName.k_Interpolate)) {
                    if (conversionHandler != null && conversionOptions.getRemoveIllegalInterpolation()) {
                        image.removeValue(ASName.k_Interpolate);
                        if (!conversionHandler.illegalInterpolationRemoved()) {
                            return false;
                        }
                    } else {
                        errorCodes.addErrorCode(new PDFA2XObjectErrorInterpolationNotAllowed(image.getCosObject().getObjNum(), image.getCosObject().getObjGen()));
                    }
                }
                if ((oldIntent = image.getIntent()) != null && !SharedConstraints.allowedRenderingIntents.contains(oldIntent)) {
                    if (conversionHandler != null && conversionOptions.getOverrideRenderingIntent() != null) {
                        PDFRenderingIntent newIntent = conversionOptions.getOverrideRenderingIntent();
                        image.setIntent(newIntent.getValue());
                        if (!conversionHandler.renderingIntentOverridden(oldIntent, newIntent.getValue())) {
                            return false;
                        }
                    } else {
                        errorCodes.addErrorCode(new PDFA2XObjectErrorInvalidRenderingIntent(oldIntent.asString(), image.getCosObject().getObjNum(), image.getCosObject().getObjGen()));
                    }
                }
                if ((imageSmaskCosObject = image.getDictionaryCosObjectValue(ASName.k_SMask)) instanceof CosStream || image.getMaskInData() > 0) {
                    transparencyInfo.setDetected(true);
                }
                PDFColorSpace cs = null;
                CosObject colorSpaceCosObject = image.getDictionaryCosObjectValue(ASName.k_ColorSpace);
                if ((colorSpaceCosObject instanceof CosArray || colorSpaceCosObject instanceof CosName && (colorSpaceCosObject.nameValue() == ASName.k_DeviceRGB || colorSpaceCosObject.nameValue() == ASName.k_DeviceCMYK || colorSpaceCosObject.nameValue() == ASName.k_DeviceGray)) && !ColorSpaceProcessor.process(new PDFXobjectImageColorSpaceAdapter(image), (cs = PDFColorSpaceFactory.getInstance(colorSpaceCosObject)).getName(), cs, docProcessor, validationHandler, parentResources, conversionOptions, conversionHandler, gStates)) {
                    return false;
                }
                PDFColorSpaceMap colorSpaceMap = parentResources.getColorSpaceMap();
                boolean bl = colorSpaceMap != null ? colorSpaceMap.get(ASName.k_DefaultRGB) != null : (defaultRGBSet = false);
                boolean bl2 = colorSpaceMap != null ? colorSpaceMap.get(ASName.k_DefaultCMYK) != null : (defaultCMYKSet = false);
                boolean bl3 = colorSpaceMap != null ? colorSpaceMap.get(ASName.k_DefaultGray) != null : (defaultGraySet = false);
                if (image.getInputFilters().contains(ASName.k_JPXDecode.asString())) {
                    PDFA2ErrorSet<PDFA2AbstractXObjectErrorCode> jpeg2000ErrorSet = new PDFA2ErrorSet<PDFA2AbstractXObjectErrorCode>();
                    if (!new Jpeg2000ImageProcessor().processJpeg2000Stream(image.getCosStream().getStreamEncoded(), docProcessor, defaultGraySet, defaultRGBSet, defaultCMYKSet, cs, jpeg2000ErrorSet, validationOptions, validationHandler, conversionOptions, conversionHandler, image, parentResources, gStates)) {
                        return false;
                    }
                    if (jpeg2000ErrorSet.hasErrors()) {
                        errorCodes.mergeErrorSet(jpeg2000ErrorSet);
                    }
                }
            } else if (xObject instanceof PDFXObjectPostScript) {
                errorCodes.addErrorCode(new PDFA2XObjectErrorPostScriptXObjectNotAllowed(xObject.getCosObject().getObjNum(), xObject.getCosObject().getObjGen()));
            }
        }
        catch (PDFInvalidDocumentException e) {
            errorCodes.addErrorCode(new PDFA2XObjectErrorPDFGeneralFailure(0, 0));
        }
        if (errorCodes.hasErrors() && !validationHandler.xObjectError(errorCodes)) {
            return false;
        }
        return validationHandler.endXObjectScan();
    }
}

