/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa2.processor;

import com.adobe.internal.io.InputStreamByteReader;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2XMPSchema;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.PDFA2XMPErrorCollector;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2XMPErrorInvalidExtensionSchema;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2XMPErrorMalformedMetadataXML;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPBasicTypeValidator;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPSchemaUsageValidator;
import com.adobe.internal.pdftoolkit.services.xmp.XMPMetaFactoryMonitor;
import com.adobe.internal.pdftoolkit.services.xmp.XMPService;
import com.adobe.internal.pdftoolkit.xml.XMLElement;
import com.adobe.internal.pdftoolkit.xml.XMLUtils;
import com.adobe.internal.xmp.XMPException;
import com.adobe.internal.xmp.XMPMeta;
import com.adobe.internal.xmp.options.ParseOptions;
import com.adobe.internal.xmp.options.PropertyOptions;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class XMPTypeValidator {
    private HashMap<XMLElement, PropertyOptions> invalidUsage = new HashMap();
    private Map<String, PDFA2XMPSchema> referenceSchemas;
    private Map<String, PDFA2XMPSchema> embeddedSchemas;
    private PDFA2XMPErrorCollector errorCodes;
    private boolean schemaUsageIssueFixable;

    XMPTypeValidator(Map<String, PDFA2XMPSchema> referenceSchemas, Map<String, PDFA2XMPSchema> embeddedSchemas, PDFA2XMPErrorCollector errorCodes) {
        this.referenceSchemas = referenceSchemas;
        this.embeddedSchemas = embeddedSchemas;
        this.errorCodes = errorCodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PDFA2XMPErrorCollector parse(PDFDocument document, InputStream in, ParseOptions options, CosDictionary xmlSource) throws XMPException {
        if (options == null) {
            options = XMPService.XMPCORE_PARSE_OPTIONS;
        }
        InputByteStream inputByteStreamXMP = null;
        InputByteStream inputByteStreamExt = null;
        try {
            InputStreamByteReader byteReader = new InputStreamByteReader(in);
            inputByteStreamXMP = document.getStreamManager().getInputByteStream(byteReader);
            inputByteStreamExt = inputByteStreamXMP.slice();
            XMPMeta xmp = XMPMetaFactoryMonitor.parse(inputByteStreamXMP.toInputStream(), options, document);
            this.validateSchemas(xmp, inputByteStreamExt.toInputStream());
            xmp.normalize(options);
        }
        catch (IOException e) {
            this.errorCodes.addErrorCode(new PDFA2XMPErrorMalformedMetadataXML(xmlSource.getObjNum(), xmlSource.getObjGen()));
        }
        finally {
            try {
                if (inputByteStreamExt != null) {
                    inputByteStreamExt.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (inputByteStreamXMP != null) {
                    inputByteStreamXMP.close();
                }
            }
            catch (IOException iOException) {}
        }
        return this.errorCodes;
    }

    private void validateSchemas(XMPMeta xmp, InputStream in) {
        Set<String> schemaNSSet = this.referenceSchemas.keySet();
        Iterator<String> iter = schemaNSSet.iterator();
        PDFA2XMPErrorCollector xmpec = new PDFA2XMPErrorCollector();
        while (iter.hasNext()) {
            String ns = iter.next();
            if (!this.embeddedSchemas.containsKey(ns)) continue;
            PDFA2XMPSchema schema = this.referenceSchemas.get(ns);
            this.validateExtensionSchema(schema, xmpec);
            if (!xmpec.hasErrors()) continue;
            this.errorCodes.mergeErrorCodes(xmpec);
            break;
        }
        this.validateSchemaUsage(in, xmp);
    }

    private void validateExtensionSchema(PDFA2XMPSchema xmpSchema, PDFA2XMPErrorCollector xmpec) {
        Map<String, PDFA2XMPSchema.PDFA2XMPProperty> propertyMap = xmpSchema.getProperties();
        Set<Map.Entry<String, PDFA2XMPSchema.PDFA2XMPProperty>> entrySet = propertyMap.entrySet();
        for (Map.Entry<String, PDFA2XMPSchema.PDFA2XMPProperty> entry : entrySet) {
            PDFA2XMPSchema.PDFA2XMPProperty propValue = entry.getValue();
            String base = XMPBasicTypeValidator.getBaseValueType(propValue.getType());
            PDFA2XMPSchema.PDFA2XMPType type = xmpSchema.getType(base);
            if (type == null) {
                if (XMPBasicTypeValidator.isValueTypeBasicXMPProperty(base)) continue;
                xmpec.addErrorCode(xmpSchema.getURI(), new PDFA2XMPErrorInvalidExtensionSchema(0, 0));
                return;
            }
            Map<String, PDFA2XMPSchema.PDFA2XMPField> fieldsMap = type.getFields();
            for (Map.Entry<String, PDFA2XMPSchema.PDFA2XMPField> fieldEntry : fieldsMap.entrySet()) {
                PDFA2XMPSchema.PDFA2XMPField field = fieldEntry.getValue();
                String baseFieldValueType = XMPBasicTypeValidator.getBaseValueType(field.getvalueType());
                Map<String, PDFA2XMPSchema.PDFA2XMPType> typesMap = xmpSchema.getTypes();
                if (typesMap.containsKey(baseFieldValueType) || XMPBasicTypeValidator.isValueTypeBasicXMPProperty(baseFieldValueType)) continue;
                xmpec.addErrorCode(xmpSchema.getURI(), new PDFA2XMPErrorInvalidExtensionSchema(0, 0));
                return;
            }
        }
    }

    private void validateSchemaUsage(InputStream in, XMPMeta xmp) {
        try {
            XMLReader reader = XMLUtils.getXMLReader();
            XMPSchemaUsageValidator validator = new XMPSchemaUsageValidator(this.referenceSchemas, xmp, this.invalidUsage, this.errorCodes);
            validator.setParent(reader);
            validator.parse(new InputSource(in));
            this.schemaUsageIssueFixable = validator.isOnlyFixableIssuesFound();
        }
        catch (SAXException e) {
            this.errorCodes.addErrorCode(new PDFA2XMPErrorMalformedMetadataXML(0, 0));
        }
        catch (IOException e) {
            this.errorCodes.addErrorCode(new PDFA2XMPErrorMalformedMetadataXML(0, 0));
        }
    }

    public boolean isValid() {
        return this.invalidUsage.isEmpty();
    }

    public boolean isSchemaUsageIssueFixable() {
        return this.schemaUsageIssueFixable;
    }

    public Map<XMLElement, PropertyOptions> getInvalidUsage() {
        return Collections.unmodifiableMap(this.invalidUsage);
    }
}

