/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa2.processor;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidContentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASArray;
import com.adobe.internal.pdftoolkit.core.types.ASDictionary;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASNull;
import com.adobe.internal.pdftoolkit.core.types.ASObject;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFExtGStateMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFFontUtils;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPatternMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.shading.PDFShadingMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectMap;
import com.adobe.internal.pdftoolkit.pdf.inlineimage.InlineImage;
import com.adobe.internal.pdftoolkit.pdf.interactive.markedcontent.PDFMCPropertyMap;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConformanceLevel;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConversionOptions;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ValidationOptions;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractContentStreamErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2ContentStreamErrorInlineImageUsesCryptFilter;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2ContentStreamErrorInlineImageUsesLZWDecodeFilter;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2ContentStreamErrorInlineImageUsesNonStandardFilter;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.DocumentProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.FileStructureProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.GState;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.ReferencedResources;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.TrackingConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.TrackingValidationHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.TransparencyState;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ContentProcessor {
    private static final HashSet<ASName> markingOperators = new HashSet(14);
    private static final HashSet<ASName> strokingOperators;
    private static final HashSet<ASName> fillingOperators;
    private static final int MAX_NESTED_LEVELS_ALLOWED = 28;
    private static final HashSet<ASName> textShowingOperators;

    /*
     * Exception decompiling
     */
    public static boolean process(Content content, PDFCosDictionary parent, ASName charProcName, DocumentProcessor docProcessor, PDFA2ConformanceLevel conformance, PDFA2ConversionOptions conversionOptions, TrackingConversionHandler conversionHandler, PDFA2ValidationOptions validationOptions, TrackingValidationHandler validationHandler, GState gState, TransparencyState transparencyInfo) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 394[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static PDFA2AbstractContentStreamErrorCode validateInlineImageFilter(ASName filter) {
        switch (FileStructureProcessor.SupportedFilters.getInstance(filter)) {
            case ValidStandardFilter: 
            case ValidStandardInlineImageFilter: {
                return null;
            }
            case LZW: 
            case LZWDecode: {
                return new PDFA2ContentStreamErrorInlineImageUsesLZWDecodeFilter(0, 0);
            }
            case Crypt: {
                return new PDFA2ContentStreamErrorInlineImageUsesCryptFilter(0, 0);
            }
            case UnknownFilter: {
                return new PDFA2ContentStreamErrorInlineImageUsesNonStandardFilter(filter.asString(), 0, 0);
            }
        }
        return null;
    }

    private static void replaceInlineImageFilter(InlineImage inlineImage, ASDictionary imageDict, int filterIndex, PDFA2ConversionOptions conversionOptions) throws PDFInvalidContentException, PDFIOException {
        ASName newFilter = conversionOptions.getInlineImageReplacementFilter();
        ASDictionary newDecodeParams = conversionOptions.getInlineImageReplacementFilterDecodeParams();
        if (newFilter == null) {
            newDecodeParams = null;
        }
        ASObject currentFilters = (ASObject)inlineImage.getStreamFilters();
        ASObject currentDecodeParams = (ASObject)inlineImage.getStreamFiltersDecodeParams();
        if (currentFilters instanceof ASName || currentFilters instanceof ASArray && ((ASArray)currentFilters).size() == 1) {
            if (newFilter != null) {
                ASName[] newFilterArray = new ASName[]{newFilter};
                ASDictionary[] newDecodeParamsArray = new ASDictionary[]{newDecodeParams};
                inlineImage.setStreamFilters(newFilterArray, newDecodeParamsArray);
                if (imageDict.containsKey(ASName.k_Filter)) {
                    imageDict.put(ASName.k_Filter, newFilter);
                }
                if (imageDict.containsKey(ASName.k_F)) {
                    imageDict.put(ASName.k_F, newFilter);
                }
                if (imageDict.containsKey(ASName.k_DecodeParms)) {
                    imageDict.remove(ASName.k_DecodeParms);
                }
                if (newDecodeParams != null) {
                    imageDict.put(ASName.k_DP, newDecodeParams);
                }
            } else {
                inlineImage.setStreamFilters((ASName)null, (ASDictionary)null);
                if (imageDict.containsKey(ASName.k_Filter)) {
                    imageDict.remove(ASName.k_Filter);
                }
                if (imageDict.containsKey(ASName.k_F)) {
                    imageDict.remove(ASName.k_F);
                }
                if (imageDict.containsKey(ASName.k_DecodeParms)) {
                    imageDict.remove(ASName.k_DecodeParms);
                }
                if (imageDict.containsKey(ASName.k_DP)) {
                    imageDict.remove(ASName.k_DP);
                }
            }
        } else if (currentFilters instanceof ASArray) {
            ASArray newFiltersArray = new ASArray();
            newFiltersArray.addAll((ASArray)currentFilters);
            ASArray newDecodeParamsArray = null;
            if (currentDecodeParams != null) {
                newDecodeParamsArray = new ASArray();
                newDecodeParamsArray.addAll((ASArray)currentDecodeParams);
            } else if (newDecodeParams != null) {
                newDecodeParamsArray = new ASArray();
                for (int i = 0; i < newFiltersArray.size(); ++i) {
                    newDecodeParamsArray.add(new ASNull());
                }
            }
            if (newFilter != null) {
                newFiltersArray.set(filterIndex, newFilter);
                if (newDecodeParamsArray != null) {
                    newDecodeParamsArray.set(filterIndex, newDecodeParams);
                }
            } else {
                newFiltersArray.remove(filterIndex);
                if (newDecodeParamsArray != null) {
                    newDecodeParamsArray.remove(filterIndex);
                }
            }
            inlineImage.setStreamFilters(newFiltersArray, newDecodeParamsArray);
            if (imageDict.containsKey(ASName.k_Filter)) {
                imageDict.put(ASName.k_Filter, (ASObject)inlineImage.getStreamFilters());
            } else if (imageDict.containsKey(ASName.k_F)) {
                imageDict.put(ASName.k_F, (ASObject)inlineImage.getStreamFilters());
            }
            if (imageDict.containsKey(ASName.k_DecodeParms)) {
                imageDict.remove(ASName.k_DecodeParms);
            }
            if (newDecodeParamsArray != null) {
                imageDict.put(ASName.k_DP, newDecodeParamsArray);
            }
        }
    }

    private static void removeUnusedResources(PDFResources resources, ReferencedResources referencedResources) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFXObjectMap xObjectMap;
        PDFPatternMap patternMap;
        PDFShadingMap shadingMap;
        PDFMCPropertyMap propertyMap;
        PDFExtGStateMap extGStateMap;
        if (resources == null) {
            return;
        }
        PDFColorSpaceMap csMap = resources.getColorSpaceMap();
        if (csMap != null) {
            Set<ASName> explicitlyReferencedNames = referencedResources.getColorSpaces() != null ? referencedResources.getColorSpaces().keySet() : null;
            HashSet<ASName> includingImplicitNames = new HashSet<ASName>();
            if (explicitlyReferencedNames != null) {
                includingImplicitNames.addAll(explicitlyReferencedNames);
            }
            includingImplicitNames.add(ASName.k_DefaultRGB);
            includingImplicitNames.add(ASName.k_DefaultCMYK);
            includingImplicitNames.add(ASName.k_DefaultGray);
            ContentProcessor.scrubUnreferencedResources(csMap.keySet(), includingImplicitNames);
            if (csMap.size() == 0) {
                resources.removeColorSpaceMap();
            }
        }
        if ((extGStateMap = resources.getExtGStateMap()) != null) {
            ContentProcessor.scrubUnreferencedResources(extGStateMap.keySet(), referencedResources.getExtGStateNames());
            if (extGStateMap.size() == 0) {
                resources.removeExtGStateMap();
            }
        }
        if ((propertyMap = resources.getMCPropertyMap()) != null) {
            ContentProcessor.scrubUnreferencedResources(propertyMap.keySet(), referencedResources.getPropertyNames());
            if (propertyMap.size() == 0) {
                resources.removeMCPropertyMap();
            }
        }
        if ((shadingMap = resources.getShadingMap()) != null) {
            ContentProcessor.scrubUnreferencedResources(shadingMap.keySet(), referencedResources.getShadingNames());
            if (shadingMap.size() == 0) {
                resources.removeShadingMap();
            }
        }
        if ((patternMap = resources.getPatternMap()) != null && referencedResources.getPatterns() != null) {
            ContentProcessor.scrubUnreferencedResources(patternMap.keySet(), referencedResources.getPatterns().keySet());
            if (patternMap.size() == 0) {
                resources.removePatternMap();
            }
        }
        if ((xObjectMap = resources.getXObjectMap()) != null && referencedResources.getXObjects() != null) {
            ContentProcessor.scrubUnreferencedResources(xObjectMap.keySet(), referencedResources.getXObjects().keySet());
            if (xObjectMap.size() == 0) {
                resources.removeXObjectMap();
            }
        }
    }

    private static void scrubUnreferencedResources(Set<ASName> namesInResourceSubDict, Set<ASName> namesReferenced) {
        block4: {
            if (namesInResourceSubDict == null) break block4;
            Iterator<ASName> iter = namesInResourceSubDict.iterator();
            if (namesReferenced == null || namesReferenced.isEmpty()) {
                while (iter.hasNext()) {
                    iter.next();
                    iter.remove();
                }
            } else {
                while (iter.hasNext()) {
                    if (namesReferenced.contains(iter.next())) continue;
                    iter.remove();
                }
            }
        }
    }

    private static ASString processNotDefGlyphInShowString(PDFFont font, ASString string, PDFA2ConversionHandler conversionHandler, int rMode) {
        if (conversionHandler == null && rMode != 3) {
            return string;
        }
        try {
            byte[] initialBytes = string.getBytes();
            byte[] bytes = new byte[initialBytes.length];
            List charCodes = font.getCharCodes(initialBytes, false);
            Iterator ccIter = charCodes.iterator();
            int index = 0;
            while (ccIter.hasNext()) {
                List charCodeInfo = (List)ccIter.next();
                byte[] charCodeBytes = (byte[])charCodeInfo.get(0);
                int charCode = 0;
                for (int i = 0; i < charCodeBytes.length; ++i) {
                    if (i > 0) {
                        charCode <<= 8;
                    }
                    charCode |= charCodeBytes[i] & 0xFF;
                }
                if (conversionHandler == null) {
                    if (!PDFFontUtils.isGlyphNotDef(font, charCode)) continue;
                    return null;
                }
                if (!PDFFontUtils.isGlyphNotDef(font, charCode)) {
                    System.arraycopy(charCodeBytes, 0, bytes, index, charCodeBytes.length);
                    index += charCodeBytes.length;
                    continue;
                }
                if (conversionHandler.notdefGlyphRemoved(font)) continue;
                return null;
            }
            if (conversionHandler == null) {
                return string;
            }
            byte[] finalBytes = new byte[index];
            System.arraycopy(bytes, 0, finalBytes, 0, index);
            return new ASString(finalBytes);
        }
        catch (Exception e) {
            return string;
        }
    }

    static {
        markingOperators.add(ASName.k_S);
        markingOperators.add(ASName.k_s);
        markingOperators.add(ASName.k_F);
        markingOperators.add(ASName.k_f);
        markingOperators.add(ASName.k_fStar);
        markingOperators.add(ASName.k_B);
        markingOperators.add(ASName.k_b);
        markingOperators.add(ASName.k_BStar);
        markingOperators.add(ASName.k_bStar);
        markingOperators.add(ASName.k_TJ);
        markingOperators.add(ASName.k_Tj);
        markingOperators.add(ASName.k_SingleQuote);
        markingOperators.add(ASName.k_DoubleQuote);
        markingOperators.add(ASName.k_sh);
        strokingOperators = new HashSet(6);
        strokingOperators.add(ASName.k_S);
        strokingOperators.add(ASName.k_s);
        strokingOperators.add(ASName.k_B);
        strokingOperators.add(ASName.k_b);
        strokingOperators.add(ASName.k_BStar);
        strokingOperators.add(ASName.k_bStar);
        fillingOperators = new HashSet(8);
        fillingOperators.add(ASName.k_F);
        fillingOperators.add(ASName.k_f);
        fillingOperators.add(ASName.k_fStar);
        fillingOperators.add(ASName.k_B);
        fillingOperators.add(ASName.k_b);
        fillingOperators.add(ASName.k_BStar);
        fillingOperators.add(ASName.k_bStar);
        fillingOperators.add(ASName.k_sh);
        textShowingOperators = new HashSet(4);
        textShowingOperators.add(ASName.k_TJ);
        textShowingOperators.add(ASName.k_Tj);
        textShowingOperators.add(ASName.k_SingleQuote);
        textShowingOperators.add(ASName.k_DoubleQuote);
    }
}

