/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa2.font;

import com.adobe.fontengine.FontEngineException;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCosFontDescriptor;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFEncodingDifferences;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontDescriptor;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontSimple;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFSimpleFontEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.AdobeGlyphList;
import com.adobe.internal.pdftoolkit.services.pdfa.common.FontProcessorUtils;
import com.adobe.internal.pdftoolkit.services.pdfa.common.TrueTypeCmapSelector;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConformanceLevel;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.PDFA2ErrorSet;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractFontErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorFontDataCorrupt;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorFontNotEmbedded;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorMismatchedWidthsInfo;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorMissingOrIncompleteWidthsArray;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorNonSymbolicTTProgramCmapTableHasNoEntry;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorNonSymbolicTrueTypeEncodingDifferencesNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorNonSymbolicTrueTypeEncodingNotMacRomanWinAnsi;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorSymbolicTTProgramCmapTableDoesNotHaveOneEntryAndMS3_0_encoding;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorSymbolicTrueTypeEncodingNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorTextNotMappedToUnicode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorTypeAbsentInFont;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorTypeAbsentInFontDescriptor;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorTypeIncorrectInFont;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorTypeIncorrectInFontDescriptor;
import com.adobe.internal.pdftoolkit.services.pdfa2.font.FontContext;
import com.adobe.internal.pdftoolkit.services.pdfa2.font.FontProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.font.UnembeddedFontInfo;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class TrueTypeFontProcessor {
    TrueTypeFontProcessor() {
    }

    static PDFA2ErrorSet<PDFA2AbstractFontErrorCode> embedTrueTypeFont(PDFFontSimple font, UnembeddedFontInfo ufInfo, PDFA2ConversionHandler conversionHandler, FontContext fontContext, PDFA2ConformanceLevel conformanceLevel) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, FontEngineException, PDFInvalidParameterException {
        boolean success;
        if (ufInfo == null) {
            return new PDFA2ErrorSet<PDFA2AbstractFontErrorCode>();
        }
        PDFA2ErrorSet<PDFA2AbstractFontErrorCode> errorCodes = ufInfo.getError();
        if (font == null) {
            return errorCodes;
        }
        if (errorCodes.errorCodeSet(PDFA2FontErrorNonSymbolicTrueTypeEncodingDifferencesNotAllowed.class) || errorCodes.errorCodeSet(PDFA2FontErrorNonSymbolicTrueTypeEncodingNotMacRomanWinAnsi.class)) {
            return errorCodes;
        }
        if (errorCodes.errorCodeSet(PDFA2FontErrorSymbolicTrueTypeEncodingNotAllowed.class)) {
            errorCodes.unSetErrorCode(PDFA2FontErrorSymbolicTrueTypeEncodingNotAllowed.class);
        }
        if (!(success = FontProcessorUtils.embedTrueTypeFont(font, ufInfo, false))) {
            return errorCodes;
        }
        if (errorCodes.errorCodeSet(PDFA2FontErrorSymbolicTTProgramCmapTableDoesNotHaveOneEntryAndMS3_0_encoding.class)) {
            errorCodes.unSetErrorCode(PDFA2FontErrorSymbolicTTProgramCmapTableDoesNotHaveOneEntryAndMS3_0_encoding.class);
            if (!conversionHandler.trueTypeFontReEmbedded(font)) {
                return null;
            }
        }
        if (errorCodes.errorCodeSet(PDFA2FontErrorFontNotEmbedded.class)) {
            errorCodes.unSetErrorCode(PDFA2FontErrorFontNotEmbedded.class);
            if (!conversionHandler.fontEmbedded(font)) {
                return null;
            }
        }
        if (errorCodes.errorCodeSet(PDFA2FontErrorTextNotMappedToUnicode.class)) {
            errorCodes.unSetErrorCode(PDFA2FontErrorTextNotMappedToUnicode.class);
            FontProcessorUtils.processToUnicodeRequirement(conversionHandler, ufInfo.getCharCodes(), errorCodes, font, conformanceLevel);
        }
        FontProcessorUtils.embedWidthsArray(font, ufInfo, fontContext, null);
        if (errorCodes.errorCodeSet(PDFA2FontErrorMismatchedWidthsInfo.class) || errorCodes.errorCodeSet(PDFA2FontErrorMissingOrIncompleteWidthsArray.class) || !font.getCosDictionary().containsKey(ASName.k_Width)) {
            errorCodes.unSetErrorCode(PDFA2FontErrorMismatchedWidthsInfo.class);
            errorCodes.unSetErrorCode(PDFA2FontErrorMissingOrIncompleteWidthsArray.class);
            if (!conversionHandler.widthsMetricsUpdated(font)) {
                return null;
            }
        }
        return errorCodes;
    }

    static PDFA2ErrorSet<PDFA2AbstractFontErrorCode> processTrueTypeFontErrors(PDFFont font, PDFA2ConversionHandler conversionHandler, HashSet<Integer> referencedCharCodes, PDFA2ConformanceLevel conformanceLevel) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFontSimple ttFont;
        PDFA2ErrorSet<PDFA2AbstractFontErrorCode> errorCodes;
        block18: {
            errorCodes = new PDFA2ErrorSet<PDFA2AbstractFontErrorCode>();
            if (font == null) {
                return errorCodes;
            }
            if (!font.getSubtype().equals(ASName.k_TrueType)) {
                return errorCodes;
            }
            int objectNumber = font.getCosObject().getObjNum();
            int genNumber = font.getCosObject().getObjGen();
            CosObject fontTypeCosObj = font.getCosDictionary().get(ASName.k_Type);
            String fontType = fontTypeCosObj instanceof CosName ? fontTypeCosObj.nameValue().asString() : null;
            FontProcessor.setTypeErrorCodes(font.getCosDictionary(), ASName.k_Font, conversionHandler, errorCodes, new PDFA2FontErrorTypeIncorrectInFont(fontType, objectNumber, genNumber), new PDFA2FontErrorTypeAbsentInFont(objectNumber, genNumber));
            ttFont = (PDFFontSimple)font;
            PDFFontDescriptor fontDesc = ttFont.getFontDescriptor();
            if (fontDesc == null) {
                return errorCodes;
            }
            PDFCosFontDescriptor desc = fontDesc.getPDFCosDescriptor();
            if (desc != null) {
                fontTypeCosObj = desc.getCosDictionary().get(ASName.k_Type);
                fontType = fontTypeCosObj instanceof CosName ? fontTypeCosObj.nameValue().asString() : null;
                FontProcessor.setTypeErrorCodes(desc.getCosDictionary(), ASName.k_FontDescriptor, conversionHandler, errorCodes, new PDFA2FontErrorTypeIncorrectInFontDescriptor(fontType, desc.getCosDictionary().getObjNum(), desc.getCosDictionary().getObjGen()), new PDFA2FontErrorTypeAbsentInFontDescriptor(desc.getCosDictionary().getObjNum(), desc.getCosDictionary().getObjGen()));
            }
            if ((fontDesc.getFlags() & 0x20) == 32) {
                PDFSimpleFontEncoding encoding = ttFont.getEncoding();
                if (encoding != null && !encoding.isMacRomanEncoding() && !encoding.isWinAnsiEncoding()) {
                    errorCodes.addErrorCode(new PDFA2FontErrorNonSymbolicTrueTypeEncodingNotMacRomanWinAnsi(encoding.getCosObject().getObjNum(), encoding.getCosObject().getObjGen()));
                }
                try {
                    PDFEncodingDifferences diff;
                    TrueTypeCmapSelector selector = FontProcessorUtils.getTrueTypeCmapSelector(font);
                    if (selector != null && selector.getCmapCount() < 1) {
                        errorCodes.addErrorCode(new PDFA2FontErrorNonSymbolicTTProgramCmapTableHasNoEntry(objectNumber, genNumber));
                    }
                    if ((diff = encoding.getDifferences()) == null) break block18;
                    boolean allGlyphsInAGL = true;
                    Set<Map.Entry<Integer, ASName>> entrySet = diff.entrySet();
                    for (Map.Entry<Integer, ASName> entry : entrySet) {
                        ASName name = entry.getValue();
                        if (name != null && AdobeGlyphList.hasGlyphName(name)) continue;
                        allGlyphsInAGL = false;
                        break;
                    }
                    if (allGlyphsInAGL) {
                        if (selector != null && !selector.threeOneExists()) {
                            errorCodes.addErrorCode(new PDFA2FontErrorNonSymbolicTrueTypeEncodingDifferencesNotAllowed(objectNumber, genNumber));
                        }
                        break block18;
                    }
                    errorCodes.addErrorCode(new PDFA2FontErrorNonSymbolicTrueTypeEncodingDifferencesNotAllowed(objectNumber, genNumber));
                }
                catch (FontEngineException e) {
                    errorCodes.addErrorCode(new PDFA2FontErrorFontDataCorrupt(objectNumber, genNumber));
                }
            } else if ((fontDesc.getFlags() & 4) == 4) {
                PDFSimpleFontEncoding encoding = ttFont.getEncoding();
                if (encoding != null) {
                    errorCodes.addErrorCode(new PDFA2FontErrorSymbolicTrueTypeEncodingNotAllowed(encoding.getCosObject().getObjNum(), encoding.getCosObject().getObjGen()));
                }
                try {
                    TrueTypeCmapSelector selector = FontProcessorUtils.getTrueTypeCmapSelector(font);
                    if (selector != null && selector.getCmapCount() != 1 && !selector.threeZeroExists()) {
                        errorCodes.addErrorCode(new PDFA2FontErrorSymbolicTTProgramCmapTableDoesNotHaveOneEntryAndMS3_0_encoding(objectNumber, genNumber));
                    }
                }
                catch (FontEngineException e) {
                    errorCodes.addErrorCode(new PDFA2FontErrorFontDataCorrupt(objectNumber, genNumber));
                }
            }
        }
        FontProcessorUtils.processToUnicodeRequirement(conversionHandler, referencedCharCodes, errorCodes, ttFont, conformanceLevel);
        return errorCodes;
    }
}

