/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa.xmp;

import com.adobe.internal.pdftoolkit.services.pdfa.xmp.MetadataUsageTreeNode;
import com.adobe.internal.pdftoolkit.services.pdfa.xmp.RDFArrayTypes;
import com.adobe.internal.pdftoolkit.services.pdfa.xmp.XMPSimpleType;
import java.util.List;

class XMPSeqInteger
extends XMPSimpleType {
    private static XMPSeqInteger _xmpSeqInteger = new XMPSeqInteger();
    private static final String EXIF_SCHEMA_NS = "http://ns.adobe.com/tiff/1.0/";

    private XMPSeqInteger() {
    }

    public static XMPSeqInteger getInstance() {
        return _xmpSeqInteger;
    }

    @Override
    public boolean isValid(MetadataUsageTreeNode m, boolean closedChoice) {
        if (!this.isValid(m)) {
            return false;
        }
        MetadataUsageTreeNode parent = m.getParentNode();
        if (parent.getNameSpaceURI() != null && parent.getNameSpaceURI().equalsIgnoreCase(EXIF_SCHEMA_NS) && parent.getName() != null && parent.getName().equals("YCbCrSubSampling")) {
            if (parent.getArrayType() != RDFArrayTypes.SEQ) {
                return false;
            }
            List<MetadataUsageTreeNode> children = parent.getNodes();
            if (children.size() != 2) {
                return false;
            }
            Integer val1 = null;
            Integer val2 = null;
            try {
                val1 = Integer.valueOf(children.get(0).getValue());
            }
            catch (NumberFormatException e) {
                return false;
            }
            try {
                val2 = Integer.valueOf(children.get(1).getValue());
            }
            catch (NumberFormatException e) {
                return false;
            }
            return val1 == 1 && val2 == 2 || val1 == 2 && val2 == 1 || val1 == 2 && val2 == 2;
        }
        return false;
    }
}

