/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa.processor;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFRuntimeException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFExtGStateMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPatternMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectMap;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConformanceLevel;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConversionOptions;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSetColorSpace;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSetExtGState;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSetFont;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSetPattern;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSetXObject;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAValidationHandler;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAValidationOptions;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAColorSpaceErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAExtGStateErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAFontErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAPatternErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAXObjectErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.font.FontProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.ColorSpaceProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.DocumentProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.ExtGStateProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.PatternProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.ReferencedResources;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.XObjectProcessor;

class ResourceProcessor {
    ResourceProcessor() {
    }

    static boolean process(PDFResources resources, ReferencedResources referencedResources, DocumentProcessor docProcessor, PDFAConformanceLevel conformance, PDFAConversionOptions conversionOptions, PDFAConversionHandler conversionHandler, PDFAValidationOptions validationOptions, PDFAValidationHandler validationHandler) throws PDFIOException, PDFSecurityException {
        block24: {
            block23: {
                block22: {
                    block21: {
                        block20: {
                            if (resources == null) {
                                return true;
                            }
                            try {
                                PDFColorSpaceMap colorSpaceMap = resources.getColorSpaceMap();
                                if (!ColorSpaceProcessor.process(colorSpaceMap, referencedResources.getColorSpaceNames(), docProcessor, conformance, conversionOptions, conversionHandler, validationOptions, validationHandler)) {
                                    return false;
                                }
                            }
                            catch (PDFInvalidDocumentException e) {
                                if (validationHandler.colorSpaceError(new PDFAErrorSetColorSpace(PDFAColorSpaceErrorCode.pdfGeneralFailure))) break block20;
                                return false;
                            }
                        }
                        try {
                            PDFExtGStateMap extGStateMap = resources.getExtGStateMap();
                            if (!ExtGStateProcessor.process(extGStateMap, referencedResources.getExtGStateNames(), conversionOptions, conversionHandler, validationOptions, validationHandler)) {
                                return false;
                            }
                        }
                        catch (PDFInvalidDocumentException e) {
                            if (validationHandler.extGStateError(null, new PDFAErrorSetExtGState(PDFAExtGStateErrorCode.pdfGeneralFailure))) break block21;
                            return false;
                        }
                    }
                    try {
                        PDFFontMap fontMap = resources.getFontMap();
                        try {
                            if (!FontProcessor.process(fontMap, referencedResources.getFontMap(), docProcessor, conformance, conversionOptions, conversionHandler, validationOptions, validationHandler)) {
                                return false;
                            }
                        }
                        catch (PDFInvalidParameterException e) {
                            throw new PDFInvalidDocumentException(e);
                        }
                    }
                    catch (PDFInvalidDocumentException e) {
                        if (!validationHandler.fontError(new PDFAErrorSetFont(PDFAFontErrorCode.pdfGeneralFailure))) {
                            return false;
                        }
                    }
                    catch (PDFRuntimeException e) {
                        if (validationHandler.fontError(new PDFAErrorSetFont(PDFAFontErrorCode.pdfGeneralFailure))) break block22;
                        return false;
                    }
                }
                try {
                    PDFXObjectMap xObjectMap = resources.getXObjectMap();
                    if (!XObjectProcessor.process(xObjectMap, referencedResources.getXObjectNames(), docProcessor, resources, conformance, conversionOptions, conversionHandler, validationOptions, validationHandler)) {
                        return false;
                    }
                }
                catch (PDFInvalidDocumentException e) {
                    if (validationHandler.xObjectError(new PDFAErrorSetXObject(PDFAXObjectErrorCode.pdfGeneralFailure))) break block23;
                    return false;
                }
            }
            try {
                PDFPatternMap patternMap = resources.getPatternMap();
                if (!PatternProcessor.process(patternMap, referencedResources.getTilingPatternNames(), docProcessor, conformance, conversionOptions, conversionHandler, validationOptions, validationHandler)) {
                    return false;
                }
            }
            catch (PDFInvalidDocumentException e) {
                if (validationHandler.patternError(new PDFAErrorSetPattern(PDFAPatternErrorCode.pdfGeneralFailure))) break block24;
                return false;
            }
        }
        return true;
    }

    static boolean hasTransparency(PDFResources resources) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFXObjectMap xObjectMap = resources.getXObjectMap();
        if (xObjectMap != null && !xObjectMap.isEmpty() && XObjectProcessor.hasTransparency(xObjectMap)) {
            return true;
        }
        PDFExtGStateMap extGStateMap = resources.getExtGStateMap();
        return extGStateMap != null && !extGStateMap.isEmpty() && ExtGStateProcessor.hasTransparency(extGStateMap);
    }
}

