/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa.processor;

import com.adobe.internal.pdftoolkit.core.types.ASName;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

class ReferencedResources {
    private HashSet colorSpaceNames;
    private HashSet extGStateNames;
    private HashMap fontMap;
    private HashSet xObjectNames;
    private HashSet tilingPatternNames;
    private HashSet shadingNames;
    private HashSet propertyNames;

    ReferencedResources() {
    }

    private void lazyInitColorSpaceNames() {
        if (this.colorSpaceNames == null) {
            this.colorSpaceNames = new LinkedHashSet();
        }
    }

    private void lazyInitExtGStateNames() {
        if (this.extGStateNames == null) {
            this.extGStateNames = new LinkedHashSet();
        }
    }

    private void lazyInitFontMap() {
        if (this.fontMap == null) {
            this.fontMap = new LinkedHashMap();
        }
    }

    private void lazyInitXObjectNames() {
        if (this.xObjectNames == null) {
            this.xObjectNames = new LinkedHashSet();
        }
    }

    private void lazyInitTilingPatternNames() {
        if (this.tilingPatternNames == null) {
            this.tilingPatternNames = new LinkedHashSet();
        }
    }

    private void lazyInitShadingNames() {
        if (this.shadingNames == null) {
            this.shadingNames = new LinkedHashSet();
        }
    }

    private void lazyInitPropertyNames() {
        if (this.propertyNames == null) {
            this.propertyNames = new LinkedHashSet();
        }
    }

    boolean hasColorSpaces() {
        return this.colorSpaceNames != null && !this.colorSpaceNames.isEmpty();
    }

    Set getColorSpaceNames() {
        return this.colorSpaceNames;
    }

    void addColorSpaceName(ASName name) {
        this.lazyInitColorSpaceNames();
        if (!this.colorSpaceNames.contains(name)) {
            this.colorSpaceNames.add(name);
        }
    }

    boolean hasExtGStates() {
        return this.extGStateNames != null && !this.extGStateNames.isEmpty();
    }

    Set getExtGStateNames() {
        return this.extGStateNames;
    }

    void addExtGState(ASName name) {
        this.lazyInitExtGStateNames();
        if (!this.extGStateNames.contains(name)) {
            this.extGStateNames.add(name);
        }
    }

    boolean hasFonts() {
        return this.fontMap != null && !this.fontMap.isEmpty();
    }

    HashMap getFontMap() {
        return this.fontMap;
    }

    Set getFontNames() {
        if (this.fontMap == null) {
            return null;
        }
        return this.fontMap.keySet();
    }

    void addFont(ASName name, Object fontInfo) {
        this.lazyInitFontMap();
        if (!this.fontMap.containsKey(name)) {
            if (fontInfo == null) {
                this.fontMap.put(name, fontInfo);
            } else {
                LinkedList<Object> l = new LinkedList<Object>();
                l.add(fontInfo);
                this.fontMap.put(name, l);
            }
        } else {
            Object oldFontInfo = this.fontMap.get(name);
            if (oldFontInfo == null) {
                LinkedList<Object> l = new LinkedList<Object>();
                l.add(fontInfo);
                this.fontMap.put(name, l);
            } else {
                List l = (List)oldFontInfo;
                l.add(fontInfo);
            }
        }
    }

    boolean hasXObjects() {
        return this.xObjectNames != null && !this.xObjectNames.isEmpty();
    }

    Set getXObjectNames() {
        return this.xObjectNames;
    }

    void addXObject(ASName name) {
        this.lazyInitXObjectNames();
        if (!this.xObjectNames.contains(name)) {
            this.xObjectNames.add(name);
        }
    }

    boolean hasTilingPatterns() {
        return this.tilingPatternNames != null && !this.tilingPatternNames.isEmpty();
    }

    Set getTilingPatternNames() {
        return this.tilingPatternNames;
    }

    void addTilingPattern(ASName name) {
        this.lazyInitTilingPatternNames();
        if (!this.tilingPatternNames.contains(name)) {
            this.tilingPatternNames.add(name);
        }
    }

    boolean hasShadings() {
        return this.shadingNames != null && !this.shadingNames.isEmpty();
    }

    Set getShadingNames() {
        return this.shadingNames;
    }

    void addShading(ASName name) {
        this.lazyInitShadingNames();
        if (!this.shadingNames.contains(name)) {
            this.shadingNames.add(name);
        }
    }

    boolean hasProperties() {
        return this.propertyNames != null && !this.propertyNames.isEmpty();
    }

    Set getPropertyNames() {
        return this.propertyNames;
    }

    void addProperty(ASName name) {
        this.lazyInitPropertyNames();
        if (!this.propertyNames.contains(name)) {
            this.propertyNames.add(name);
        }
    }
}

