/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa.font;

import com.adobe.fontengine.FontEngineException;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontImpl;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.Cmap;
import com.adobe.fontengine.font.opentype.OpenTypeFont;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCosFontDescriptor;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontDescriptor;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontSimple;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFSimpleFontEncoding;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSetFont;
import com.adobe.internal.pdftoolkit.services.pdfa.common.FontProcessorUtils;
import com.adobe.internal.pdftoolkit.services.pdfa.common.TrueTypeCmapSelector;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAFontErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.font.FontContext;
import com.adobe.internal.pdftoolkit.services.pdfa.font.FontProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.font.UnembeddedFontInfo;

class TrueTypeFontProcessor {
    TrueTypeFontProcessor() {
    }

    static PDFAErrorSetFont embedTrueTypeFont(PDFFontSimple font, UnembeddedFontInfo ufInfo, PDFAConversionHandler conversionHandler, FontContext fontContext) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, FontEngineException, PDFInvalidParameterException {
        boolean success;
        if (ufInfo == null) {
            return new PDFAErrorSetFont();
        }
        PDFAErrorSetFont errorCodes = ufInfo.getError();
        if (font == null) {
            return errorCodes;
        }
        if (FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.nonSymbolicTrueTypeEncodingDifferencesNotAllowed) || FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.nonSymbolicTrueTypeEncodingNotMacRomanWinAnsi)) {
            return errorCodes;
        }
        if (FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.symbolicTrueTypeEncodingNotAllowed)) {
            FontProcessor.unSetErrorFlag(errorCodes, PDFAFontErrorCode.symbolicTrueTypeEncodingNotAllowed);
        }
        if (!(success = FontProcessorUtils.embedTrueTypeFont(font, ufInfo, true))) {
            return errorCodes;
        }
        if (FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.symbolicTTProgramCmapTableDoesNotHaveOneEntry)) {
            FontProcessor.unSetErrorFlag(errorCodes, PDFAFontErrorCode.symbolicTTProgramCmapTableDoesNotHaveOneEntry);
            if (!conversionHandler.trueTypeFontReEmbedded(font)) {
                return null;
            }
        }
        if (FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.fontNotEmbedded)) {
            FontProcessor.unSetErrorFlag(errorCodes, PDFAFontErrorCode.fontNotEmbedded);
            if (!conversionHandler.fontEmbedded(font)) {
                return null;
            }
        }
        if (FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.openTypeFontEmbeddingNotAllowed)) {
            FontProcessor.unSetErrorFlag(errorCodes, PDFAFontErrorCode.openTypeFontEmbeddingNotAllowed);
            if (!conversionHandler.openTypeFontReEmbedded(font)) {
                return null;
            }
        }
        FontProcessorUtils.embedWidthsArray(font, ufInfo, fontContext, null);
        if (FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.mismatchedWidthsInfo) || FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.missingOrIncompleteWidthsArray) || !font.getCosDictionary().containsKey(ASName.k_Width)) {
            FontProcessor.unSetErrorFlag(errorCodes, PDFAFontErrorCode.mismatchedWidthsInfo);
            FontProcessor.unSetErrorFlag(errorCodes, PDFAFontErrorCode.missingOrIncompleteWidthsArray);
            if (!conversionHandler.widthsMetricsUpdated(font)) {
                return null;
            }
        }
        return errorCodes;
    }

    static PDFAErrorSetFont processTrueTypeFontErrors(PDFFont font, PDFAConversionHandler conversionHandler) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAErrorSetFont errorCodes = new PDFAErrorSetFont();
        if (font == null) {
            return errorCodes;
        }
        if (!font.getSubtype().equals(ASName.k_TrueType)) {
            return errorCodes;
        }
        PDFFontSimple ttFont = (PDFFontSimple)font;
        FontProcessor.setTypeErrorCodes(ttFont.getCosDictionary(), ASName.k_Font, conversionHandler, errorCodes, PDFAFontErrorCode.typeIncorrectInFont, PDFAFontErrorCode.typeAbsentInFont);
        PDFFontDescriptor fontDesc = ttFont.getFontDescriptor();
        if (fontDesc == null) {
            return errorCodes;
        }
        PDFCosFontDescriptor desc = fontDesc.getPDFCosDescriptor();
        if (desc != null) {
            FontProcessor.setTypeErrorCodes(desc.getCosDictionary(), ASName.k_FontDescriptor, conversionHandler, errorCodes, PDFAFontErrorCode.typeIncorrectInFontDescriptor, PDFAFontErrorCode.typeAbsentInFontDescriptor);
        }
        if ((fontDesc.getFlags() & 0x20) == 32) {
            PDFSimpleFontEncoding encoding = ttFont.getEncoding();
            if (encoding != null) {
                if (encoding.getDifferences() != null) {
                    errorCodes.addErrorCode(PDFAFontErrorCode.nonSymbolicTrueTypeEncodingDifferencesNotAllowed);
                } else if (!encoding.isMacRomanEncoding() && !encoding.isWinAnsiEncoding()) {
                    errorCodes.addErrorCode(PDFAFontErrorCode.nonSymbolicTrueTypeEncodingNotMacRomanWinAnsi);
                }
            }
        } else if ((fontDesc.getFlags() & 4) == 4) {
            PDFSimpleFontEncoding encoding = ttFont.getEncoding();
            if (encoding != null) {
                errorCodes.addErrorCode(PDFAFontErrorCode.symbolicTrueTypeEncodingNotAllowed);
            }
            try {
                int cmapCount = TrueTypeFontProcessor.getCmapCount(ttFont, new TrueTypeCmapSelector());
                if (cmapCount == -1) {
                    return errorCodes;
                }
                if (cmapCount != 1) {
                    errorCodes.addErrorCode(PDFAFontErrorCode.symbolicTTProgramCmapTableDoesNotHaveOneEntry);
                }
            }
            catch (FontEngineException e) {
                errorCodes.addErrorCode(PDFAFontErrorCode.fontDataCorrupt);
            }
        }
        return errorCodes;
    }

    static int getCmapCount(PDFFontSimple pdfFont, Cmap.CmapSelector cmapSelector) throws FontLoadingException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, InvalidFontException, UnsupportedFontException {
        Font afeFont = pdfFont.getAFEFont();
        if (afeFont != null) {
            FontData fontData = ((FontImpl)afeFont).getFontData();
            if (fontData == null) {
                return -1;
            }
            if (fontData instanceof OpenTypeFont && ((OpenTypeFont)fontData).getCFFFont() == null) {
                OpenTypeFont otFont = (OpenTypeFont)fontData;
                Cmap cmapTable = otFont.cmap;
                if (cmapTable != null) {
                    TrueTypeCmapSelector selector = new TrueTypeCmapSelector();
                    cmapTable.enumerateCmaps(selector);
                    return selector.getCmapCount();
                }
            }
        }
        return -1;
    }
}

