/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa;

import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSet;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAFileStructureErrorCode;
import java.util.ArrayList;

public class PDFAErrorSetFileStructure
extends PDFAErrorSet {
    public PDFAErrorSetFileStructure() {
        super(PDFAFileStructureErrorCode.class);
    }

    public PDFAErrorSetFileStructure(PDFAErrorSetFileStructure errorCodes) {
        this();
        this.mergeErrorSet(errorCodes);
    }

    public PDFAErrorSetFileStructure(PDFAErrorCode errorCode) {
        this();
        this.addErrorCode(errorCode);
    }

    public boolean fileHeaderPercentCharPositionNotAllowed() {
        return this.errorCodeSet(PDFAFileStructureErrorCode.fileHeaderPercentCharPosNotAllowed);
    }

    public boolean fileHeaderCommentNotPresent() {
        return this.errorCodeSet(PDFAFileStructureErrorCode.fileHeaderCommentNotPresent);
    }

    public boolean fileTrailerIDKwdNotPresent() {
        return this.errorCodeSet(PDFAFileStructureErrorCode.fileTrailerIDKwdNotPresent);
    }

    public boolean fileTrailerEncryptKwdPresent() {
        return this.errorCodeSet(PDFAFileStructureErrorCode.fileTrailerEncryptKwdPresent);
    }

    public boolean fileTrailerAdditionalDataPresent() {
        return this.errorCodeSet(PDFAFileStructureErrorCode.fileTrailerAdditionalDataPresent);
    }

    public boolean crossRefTableSpaceCharNotPresent() {
        return this.errorCodeSet(PDFAFileStructureErrorCode.crossRefTableSpaceCharNotPresent);
    }

    public boolean crossRefTableEOLMarkerNotPresent() {
        return this.errorCodeSet(PDFAFileStructureErrorCode.crossRefTableEOLMarkerNotPresent);
    }

    public boolean hexStrEvenNumCharsNotPresent() {
        return this.errorCodeSet(PDFAFileStructureErrorCode.hexStrEvenNumCharsNotPresent);
    }

    public boolean hexStrInvalidChrsPresent() {
        return this.errorCodeSet(PDFAFileStructureErrorCode.hexStrInvalidChrsPresent);
    }

    public boolean streamSuffixCharsNotAllowed() {
        return this.errorCodeSet(PDFAFileStructureErrorCode.streamSuffixCharsNotAllowed);
    }

    public boolean streamEOLMarkerNotPresent() {
        return this.errorCodeSet(PDFAFileStructureErrorCode.streamEOLMarkerNotPresent);
    }

    public boolean endstreamNotPrecededByEOL() {
        return this.errorCodeSet(PDFAFileStructureErrorCode.endstreamNotPrecededByEOL);
    }

    public boolean streamLengthIncorrect() {
        return this.errorCodeSet(PDFAFileStructureErrorCode.streamLengthIncorrect);
    }

    public boolean streamFKeyPresent() {
        return this.errorCodeSet(PDFAFileStructureErrorCode.streamFKeyPresent);
    }

    public boolean streamFFilterKeyPresent() {
        return this.errorCodeSet(PDFAFileStructureErrorCode.streamFFilterKeyPresent);
    }

    public boolean streamFDecodeParamsKeyPresent() {
        return this.errorCodeSet(PDFAFileStructureErrorCode.streamFDecodeParamsKeyPresent);
    }

    public boolean indirectObjNumWhitespaceCharsIncorrect() {
        return this.errorCodeSet(PDFAFileStructureErrorCode.indirectObjNumWhitespaceCharsIncorrect);
    }

    public boolean indirectObjEOLMarkerNotPresent() {
        return this.errorCodeSet(PDFAFileStructureErrorCode.indirectObjEOLMarkerNotPresent);
    }

    public boolean lzwDecodeFilterPresent() {
        return this.errorCodeSet(PDFAFileStructureErrorCode.lzwDecodeFilterPresent);
    }

    public boolean jpxDecodeFilterPresent() {
        return this.errorCodeSet(PDFAFileStructureErrorCode.jpxDecodeFilterPresent);
    }

    public boolean integerNumberFormatIncorrect() {
        return this.errorCodeSet(PDFAFileStructureErrorCode.integerNumberFormatIncorrect);
    }

    public boolean realNumberFormatIncorrect() {
        return this.errorCodeSet(PDFAFileStructureErrorCode.realNumberFormatIncorrect);
    }

    public boolean nameLengthIncorrect() {
        return this.errorCodeSet(PDFAFileStructureErrorCode.nameLengthIncorrect);
    }

    public boolean indirectObjectNumberIncorrect() {
        return this.errorCodeSet(PDFAFileStructureErrorCode.indirectObjectNumberIncorrect);
    }

    public boolean arrayLengthIncorrect() {
        return this.errorCodeSet(PDFAFileStructureErrorCode.arrayLengthIncorrect);
    }

    public boolean dictionarySizeIncorrect() {
        return this.errorCodeSet(PDFAFileStructureErrorCode.dictionarySizeIncorrect);
    }

    public boolean misMatchedKeyValuePairsInDict() {
        return this.errorCodeSet(PDFAFileStructureErrorCode.misMatchedKeyValuePairsInDict);
    }

    public boolean stringLengthIncorrect() {
        return this.errorCodeSet(PDFAFileStructureErrorCode.stringLengthIncorrect);
    }

    public boolean fileSpecDictContainsEF() {
        return this.errorCodeSet(PDFAFileStructureErrorCode.fileSpecDictContainsEF);
    }

    public boolean IDKwdNotPresentInMainTrailer() {
        return this.errorCodeSet(PDFAFileStructureErrorCode.IDKwdNotPresentInMainTrailer);
    }

    public boolean IDKwdNotPresentInZeroUpdateTrailer() {
        return this.errorCodeSet(PDFAFileStructureErrorCode.IDKwdNotPresentInZeroUpdateTrailer);
    }

    public boolean IDValuesNotEqual() {
        return this.errorCodeSet(PDFAFileStructureErrorCode.IDValuesNotEqual);
    }

    public boolean nonCompressedXRefNotPresent() {
        return this.errorCodeSet(PDFAFileStructureErrorCode.nonCompressedXRefNotPresent);
    }

    @Override
    public boolean pdfGeneralFailure() {
        return this.errorCodeSet(PDFAFileStructureErrorCode.pdfGeneralFailure);
    }

    public boolean crossRefTableDamagedNeedsRepair() {
        return this.errorCodeSet(PDFAFileStructureErrorCode.crossRefTableDamagedNeedsRepair);
    }

    public boolean incorrectOffsetofCrossRefTable() {
        return this.errorCodeSet(PDFAFileStructureErrorCode.incorrectOffsetofCrossRefTable);
    }

    public boolean indirectObjectNumberMismatchFromCrossRefTable() {
        return this.errorCodeSet(PDFAFileStructureErrorCode.indirectObjectNumberMismatchFromCrossRefTable);
    }

    public boolean indirectObjPrecededByMultipleEOLMarker() {
        return this.errorCodeSet(PDFAFileStructureErrorCode.indirectObjPrecededByMultipleEOLMarker);
    }

    @Override
    public String toString() {
        ArrayList<String> violations = new ArrayList<String>(30);
        if (this.pdfGeneralFailure()) {
            violations.add("pdf general failure");
        }
        if (this.fileHeaderPercentCharPositionNotAllowed()) {
            violations.add("File Header - % character is not present at byte offset 0");
        }
        if (this.fileHeaderCommentNotPresent()) {
            violations.add("File Header - Comment line does not follow the file header line");
        }
        if (this.fileTrailerIDKwdNotPresent()) {
            violations.add("File Trailer - Does not contain the ID keyword");
        }
        if (this.fileTrailerEncryptKwdPresent()) {
            violations.add("File Trailer - ENCRYPT keyword is present");
        }
        if (this.fileTrailerAdditionalDataPresent()) {
            violations.add("File Trailer - More data after the last end-of-file marker. ");
        }
        if (this.IDKwdNotPresentInMainTrailer()) {
            violations.add("Linearized file - Main trailer dict does not contain ID kwd");
        }
        if (this.IDKwdNotPresentInZeroUpdateTrailer()) {
            violations.add("Linearized file - Zero update trailer dict does not contain ID kwd");
        }
        if (this.IDValuesNotEqual()) {
            violations.add("Linearized file - ID values in both trailers not identical");
        }
        if (this.nonCompressedXRefNotPresent()) {
            violations.add("Compressed ObjectStreams -  Table/Hybrid XRef not present");
        }
        if (this.crossRefTableSpaceCharNotPresent()) {
            violations.add("Cross Ref - object number,range not separated by a single SPACE char");
        }
        if (this.crossRefTableEOLMarkerNotPresent()) {
            violations.add("Cross Ref - xref keyword , cross ref subsection header not separated by a SPACE char");
        }
        if (this.hexStrEvenNumCharsNotPresent()) {
            violations.add("Hex Strings - Even number of non-white-space valid characters not present");
        }
        if (this.hexStrInvalidChrsPresent()) {
            violations.add("Hex Strings - Characters not in the range 0 to 9, A to F, or a to f are present");
        }
        if (this.streamSuffixCharsNotAllowed()) {
            violations.add("Streams - The stream keyword is not followed by either by a CR and LF or by a single LF");
        }
        if (this.streamEOLMarkerNotPresent()) {
            violations.add("Streams - EOL marker is not present.");
        }
        if (this.endstreamNotPrecededByEOL()) {
            violations.add("Streams - The endstream keyword is not preceded by an EOL marker.");
        }
        if (this.streamLengthIncorrect()) {
            violations.add("Streams - Length incorrect");
        }
        if (this.streamFKeyPresent()) {
            violations.add("Streams - A stream object dictionary contains the F key");
        }
        if (this.streamFFilterKeyPresent()) {
            violations.add("Streams - A stream object dictionary contains the FFilter key");
        }
        if (this.streamFDecodeParamsKeyPresent()) {
            violations.add("Streams - A stream object dictionary contains the FDecodeParams key");
        }
        if (this.indirectObjNumWhitespaceCharsIncorrect()) {
            violations.add("Indirect Objects - obj, gen number not separated by a single white-space character");
        }
        if (this.indirectObjEOLMarkerNotPresent()) {
            violations.add("Indirect Objects - obj num and endobj keyword not preceded/followed by an EOL");
        }
        if (this.lzwDecodeFilterPresent()) {
            violations.add("Filters - The LZWDecode filter is present and is not permitted");
        }
        if (this.jpxDecodeFilterPresent()) {
            violations.add("Filters - The JPXDecode filter is present and is not permitted");
        }
        if (this.integerNumberFormatIncorrect()) {
            violations.add("Implementation Limits - integer number size out of bounds");
        }
        if (this.realNumberFormatIncorrect()) {
            violations.add("Implementation Limits - real number size out of bounds");
        }
        if (this.nameLengthIncorrect()) {
            violations.add("Implementation Limits - name length exceeds size 127");
        }
        if (this.indirectObjectNumberIncorrect()) {
            violations.add("Implementation Limits - number of indirect objects > 8,388,607");
        }
        if (this.arrayLengthIncorrect()) {
            violations.add("Implementation Limits - array length exceeds 8191");
        }
        if (this.dictionarySizeIncorrect()) {
            violations.add("Implementation Limits - dictionary size exceeds 4095");
        }
        if (this.misMatchedKeyValuePairsInDict()) {
            violations.add("Invalid Dict : Mismatch in number of key/values in Dictionary");
        }
        if (this.stringLengthIncorrect()) {
            violations.add("Implementation Limits - string byte length exceeds 65535");
        }
        if (this.fileSpecDictContainsEF()) {
            violations.add("EmbeddedFiles - File spec dictionary contains EF entry");
        }
        if (this.crossRefTableDamagedNeedsRepair()) {
            violations.add("Cross Ref table of Document is Damaged , Needs Repair");
        }
        if (this.incorrectOffsetofCrossRefTable()) {
            violations.add("Incorrect Offset Specified for Cross Ref table in startXref");
        }
        if (this.indirectObjectNumberMismatchFromCrossRefTable()) {
            violations.add("Object number mismatch between Cross Refernce Table and Definition");
        }
        if (this.indirectObjPrecededByMultipleEOLMarker()) {
            violations.add("Indirect Object Preceded By Multiple End of Line Markers");
        }
        return super.toString() + " " + violations;
    }
}

