/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa;

import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAErrorCode;
import java.util.EnumSet;

public abstract class PDFAErrorSet {
    private EnumSet errorCodes;

    protected PDFAErrorSet(Class errorCodeEnum) {
        this.errorCodes = EnumSet.noneOf(errorCodeEnum);
    }

    void setErrorFlags(EnumSet flags) {
        this.errorCodes = flags;
    }

    public void mergeErrorSet(PDFAErrorSet set) {
        if (set != null && set.getErrorCodes() != null) {
            this.errorCodes.addAll(set.getErrorCodes());
        }
    }

    public void addErrorCode(PDFAErrorCode errorCode) {
        this.errorCodes.add(errorCode);
    }

    public EnumSet getErrorCodes() {
        return this.errorCodes;
    }

    public void unSetErrorFlag(PDFAErrorCode errorCode) {
        this.errorCodes.remove(errorCode);
    }

    public boolean hasErrors() {
        return this.errorCodes.size() != 0;
    }

    public boolean errorFlagsSet(EnumSet codes) {
        return this.errorCodes.containsAll(codes);
    }

    public boolean errorCodeSet(PDFAErrorCode ec) {
        return this.errorCodes.contains(ec);
    }

    public abstract boolean pdfGeneralFailure();

    public String toString() {
        String className = this.getClass().getName();
        return className.substring(className.lastIndexOf(46) + 1);
    }
}

