/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.manipulations;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRotation;
import com.adobe.internal.pdftoolkit.services.manipulations.PMMOptionsBase;
import com.adobe.internal.pdftoolkit.services.manipulations.PMMOptionsFinal;

public final class PMMOptions
extends PMMOptionsBase {
    public static final PMMOptionsBase Bookmarks = new PMMOptionsFinal(1);
    public static final PMMOptionsBase AnnotationsForms = new PMMOptionsFinal(2);
    public static final PMMOptionsBase CopyAllOCGs = new PMMOptionsFinal(4);
    public static final PMMOptionsBase UseTargetOCConfig = new PMMOptionsFinal(8);
    public static final PMMOptionsBase Structure = new PMMOptionsFinal(16);
    public static final PMMOptionsBase PageLabels = new PMMOptionsFinal(32);
    public static final PMMOptionsBase MergeOCConfig = new PMMOptionsFinal(64);
    public static final PMMOptionsBase BalancePageTree = new PMMOptionsFinal(128);
    public static final PMMOptionsBase AllOptions = new PMMOptionsFinal(Bookmarks.getValue() | AnnotationsForms.getValue() | CopyAllOCGs.getValue() | UseTargetOCConfig.getValue() | Structure.getValue() | PageLabels.getValue());
    private double mOpacity = 1.0;
    private PDFRotation mRotation = PDFRotation.ROTATE_0;
    private double mScaling = 1.0;
    private ASCoordinate mTranslation = new ASCoordinate(0.0, 0.0);
    private ASRectangle clipBox = null;
    private boolean repairDocument;

    private PMMOptions(int option) {
        this.mOption = option;
    }

    public static PMMOptions newInstance(PMMOptionsBase option) {
        return new PMMOptions(option.getValue());
    }

    public static PMMOptions newInstanceAll() {
        return new PMMOptions(AllOptions.getValue());
    }

    public static PMMOptions newInstanceNone() {
        return new PMMOptions(0);
    }

    public void set(PMMOptionsBase option) {
        this.mOption = option.getValue();
    }

    public void enable(PMMOptionsBase option) {
        this.mOption |= option.getValue();
    }

    public void disable(PMMOptionsBase option) {
        this.mOption &= 0xFFFFFFFF ^ option.getValue();
    }

    public void enableAllOptions() {
        this.mOption = AllOptions.getValue();
    }

    public void disableAllOptions() {
        this.mOption = 0;
    }

    public void setOpacity(double opacityConst) {
        if (opacityConst > 1.0) {
            opacityConst = 1.0;
        } else if (opacityConst < 0.0) {
            opacityConst = 0.0;
        }
        this.mOpacity = opacityConst;
    }

    public double getOpacity() {
        return this.mOpacity;
    }

    public void setRotationAngle(int angle) throws PDFInvalidParameterException {
        this.mRotation = PDFRotation.getInstance(angle);
    }

    public PDFRotation getRotation() {
        return this.mRotation;
    }

    public boolean hasRotation() {
        boolean result = true;
        if (this.mRotation.getValue() == 0) {
            result = false;
        }
        return result;
    }

    public void setScalingFactor(double scaleFactor) {
        this.mScaling = scaleFactor;
    }

    public double getScalingFactor() {
        return this.mScaling;
    }

    public boolean hasScaling() {
        boolean result = true;
        if (this.mScaling == 1.0) {
            result = false;
        }
        return result;
    }

    public void setTranslationCoords(ASCoordinate translationCoords) {
        this.mTranslation = translationCoords;
    }

    public ASCoordinate getTranslationCoords() {
        return this.mTranslation;
    }

    public boolean hasTranslation() {
        boolean result = true;
        if (this.mTranslation.x() == 0.0 && this.mTranslation.y() == 0.0) {
            result = false;
        }
        return result;
    }

    public void setClipBox(PDFRectangle clipRect) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.clipBox = clipRect != null ? clipRect.getRectangle() : null;
    }

    public void setClipBox(double left, double bottom, double right, double top) {
        this.clipBox = new ASRectangle(left, bottom, right, top);
    }

    void setClipBox(ASRectangle rect) {
        this.clipBox = rect;
    }

    ASRectangle getClipBox() {
        return this.clipBox;
    }

    public boolean hasClipBox() {
        return this.clipBox != null;
    }

    public void setRepairDocument(boolean repairDocument) {
        this.repairDocument = repairDocument;
    }

    public boolean isRepairDocument() {
        return this.repairDocument;
    }
}

