/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.javascript.model;

import com.adobe.internal.pdftoolkit.services.javascript.UnsupportedJavaScriptFeatureException;
import com.adobe.internal.pdftoolkit.services.javascript.model.JSMeshValidator;
import com.adobe.internal.pdftoolkit.services.javascript.model.Param;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContinuationPending;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

public final class Property {
    private final String msName;
    private final Param meParamType;
    private final Class<?> mClass;
    private final Method mGetMethod;
    private final Method mSetMethod;
    private final boolean isSetterUnsupported;
    private final boolean isGetterUnsupported;
    private boolean isSecurityRestricted;

    public Property(Class<?> clazz, String sName, String sGetFunc, String sSetFunc, Param eParamType, boolean isGetterUnsupported, boolean isSetterUnsupported) {
        this.mClass = clazz;
        this.msName = sName;
        this.meParamType = eParamType;
        this.isGetterUnsupported = isGetterUnsupported;
        this.isSetterUnsupported = isSetterUnsupported;
        Method m = null;
        if (!isGetterUnsupported && sGetFunc != null) {
            try {
                m = this.mClass.getMethod(sGetFunc, new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                throw new RuntimeException("Could not find property " + sGetFunc, ex);
            }
        }
        this.mGetMethod = m;
        m = null;
        if (!isSetterUnsupported && sSetFunc != null) {
            try {
                Class[] args = null;
                args = eParamType == null ? new Class[]{} : new Class[]{Param.TYPE_TO_CLASS_MAP.get((Object)eParamType.getType())};
                m = this.mClass.getMethod(sSetFunc, args);
            }
            catch (NoSuchMethodException ex) {
                throw new RuntimeException("Could not find property " + sSetFunc, ex);
            }
        }
        this.mSetMethod = m;
    }

    public Property(Class<?> clazz, String sName, String sGetFunc, String sSetFunc, Param eParamType, boolean isGetterUnsupported, boolean isSetterUnsupported, boolean isSecurityRestricted) {
        this(clazz, sName, sGetFunc, sSetFunc, eParamType, isGetterUnsupported, isSetterUnsupported);
        this.isSecurityRestricted = isSecurityRestricted;
    }

    public Object invokeGetProp(Object scriptThis) {
        if (this.isGetterUnsupported) {
            throw new UnsupportedJavaScriptFeatureException(" Unsupported javascript evaluation feature" + this.msName + " for " + this.mClass.getName());
        }
        try {
            if (this.mGetMethod == null) {
                return Undefined.instance;
            }
            return this.mGetMethod.invoke(scriptThis, new Object[0]);
        }
        catch (IllegalAccessException e3) {
            throw Context.throwAsScriptRuntimeEx(new RuntimeException("Exception occured while invoking get property " + this.msName, e3));
        }
        catch (InvocationTargetException e2) {
            Throwable e = e2;
            while ((e = e.getTargetException()) instanceof InvocationTargetException) {
            }
            if (e instanceof ContinuationPending) {
                throw (ContinuationPending)e;
            }
            throw Context.throwAsScriptRuntimeEx(e);
        }
    }

    public void invokeSetProp(Object scriptThis, Object oSetValue, Scriptable scope) {
        if (this.isSetterUnsupported) {
            throw new UnsupportedJavaScriptFeatureException(" Unsupported javascript evaluation feature" + this.msName + " for " + this.mClass.getName());
        }
        try {
            Object[] finalParams = new Object[1];
            JSMeshValidator.validateFunctionParameters(new Param[]{this.meParamType}, this.msName, new Object[]{oSetValue}, finalParams, Context.getCurrentContext(), scope);
            this.mSetMethod.invoke(scriptThis, finalParams[0]);
        }
        catch (IllegalAccessException e3) {
            throw Context.throwAsScriptRuntimeEx(new RuntimeException("Exception occured while invoking set property " + this.msName, e3));
        }
        catch (InvocationTargetException e2) {
            Throwable e = e2;
            while ((e = e.getTargetException()) instanceof InvocationTargetException) {
            }
            if (e instanceof ContinuationPending) {
                throw (ContinuationPending)e;
            }
            throw Context.throwAsScriptRuntimeEx(e);
        }
    }

    public boolean hasGetter() {
        return this.mGetMethod != null;
    }

    public boolean hasSetter() {
        return this.mSetMethod != null;
    }

    public Param getParamType() {
        return this.meParamType;
    }

    public String getName() {
        return this.msName;
    }

    public boolean isSecurityRestricted() {
        return this.isSecurityRestricted;
    }
}

