/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.javascript.model;

import com.adobe.internal.pdftoolkit.services.javascript.model.Param;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

public class JSMeshValidator {
    public static final int JAVA_UNSUPPORTED_TYPE = 0;
    public static final int JAVA_STRING_TYPE = 1;
    public static final int JAVA_INT_TYPE = 2;
    public static final int JAVA_BOOLEAN_TYPE = 3;
    public static final int JAVA_DOUBLE_TYPE = 4;
    public static final int JAVA_SCRIPTABLE_TYPE = 5;
    public static final int JAVA_OBJECT_TYPE = 6;

    static void validateFunctionParameters(Param[] params, String functionName, Object[] arguments, Object[] finalParams, Context cx, Scriptable scope) {
        if (params == null || params.length == 0) {
            return;
        }
        int argLength = arguments == null ? 0 : arguments.length;
        for (int i = 0; i < params.length; ++i) {
            Param param = params[i];
            if (param == null) continue;
            int index = param.getIndex() - 1;
            String defaultValue = param.getDefaultValue();
            if (index >= argLength) {
                if (param.isOptional() != null && param.isOptional().booleanValue()) {
                    finalParams[index] = JSMeshValidator.setValue(defaultValue, param, Undefined.instance, cx, scope);
                    continue;
                }
                throw Context.throwAsScriptRuntimeEx(new RuntimeException("Compulsory parameter missing for function name " + functionName + " !"));
            }
            finalParams[index] = JSMeshValidator.setValue(defaultValue, param, arguments[index], cx, scope);
            if (finalParams[index] == null || finalParams[index] == Undefined.instance || finalParams[index].equals(param.getExclusionValue())) continue;
            String restrictedValue = param.getRestrictValue();
            if (restrictedValue != null && finalParams[index].equals(restrictedValue) && param.getBForceDefault().booleanValue()) {
                finalParams[index] = param.getDefaultValue();
            }
            Object argument = finalParams[index];
            if (param.getType() == Param.Type.String) {
                if (!(argument instanceof String)) {
                    finalParams[index] = argument = argument.toString();
                }
                JSMeshValidator.performStringBufferSizeCheck(functionName, argument, param.getMaxStringSize());
            }
            if (param.getType() != Param.Type.Double) continue;
            JSMeshValidator.performNumberCheck(functionName, argument, param.getNumberMaxValue(), param.getNumberMinValue());
        }
    }

    private static Object setValue(String defaultValue, Param param, Object argument, Context cx, Scriptable scope) {
        Class desiredType;
        if (defaultValue != null && argument == null) {
            argument = defaultValue;
        }
        return JSMeshValidator.convertArg(cx, scope, argument, JSMeshValidator.getTypeTag((desiredType = Param.TYPE_TO_CLASS_MAP.get((Object)param.getType())) == null ? Object.class : desiredType));
    }

    private static void performStringBufferSizeCheck(String key, Object input, Integer stringBufferSize) {
        if (input instanceof String) {
            int size = ((String)input).length();
            if (stringBufferSize != null && size >= stringBufferSize) {
                throw Context.throwAsScriptRuntimeEx(new RuntimeException("In method " + key + ", input value length " + size + " is greater than " + stringBufferSize));
            }
        } else {
            throw Context.throwAsScriptRuntimeEx(new RuntimeException("In method " + key + " expected parameter to be string"));
        }
    }

    private static void performNumberCheck(String key, Object input, Double numberMaxValue, Double numberMinValue) {
        if (!(input instanceof Number)) {
            throw new RuntimeException("In method " + key + " expected a numeric parameter");
        }
        Number number = (Number)input;
        if (numberMaxValue != null && number.doubleValue() >= numberMaxValue) {
            throw Context.throwAsScriptRuntimeEx(new RuntimeException("In method " + key + ", input value length " + input + " is greater than " + numberMaxValue));
        }
        if (numberMinValue != null && number.doubleValue() <= numberMinValue) {
            throw Context.throwAsScriptRuntimeEx(new RuntimeException("In method " + key + ", input value length " + input + " is very less than " + numberMinValue));
        }
    }

    public static int getTypeTag(Class<?> type) {
        if (type == ScriptRuntime.StringClass) {
            return 1;
        }
        if (type == ScriptRuntime.IntegerClass || type == Integer.TYPE) {
            return 2;
        }
        if (type == ScriptRuntime.BooleanClass || type == Boolean.TYPE) {
            return 3;
        }
        if (type == ScriptRuntime.DoubleClass || type == Double.TYPE || type == ScriptRuntime.NumberClass) {
            return 4;
        }
        if (ScriptRuntime.ScriptableClass.isAssignableFrom(type)) {
            return 5;
        }
        if (type == ScriptRuntime.ObjectClass) {
            return 6;
        }
        return 0;
    }

    public static Object convertArg(Context cx, Scriptable scope, Object arg, int typeTag) {
        switch (typeTag) {
            case 1: {
                if (arg instanceof String) {
                    return arg;
                }
                return ScriptRuntime.toString(arg);
            }
            case 2: {
                if (arg instanceof Integer) {
                    return arg;
                }
                return ScriptRuntime.toInt32(arg);
            }
            case 3: {
                if (arg instanceof Boolean) {
                    return arg;
                }
                return ScriptRuntime.toBoolean(arg) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 4: {
                if (arg instanceof Double) {
                    return arg;
                }
                return new Double(ScriptRuntime.toNumber(arg));
            }
            case 5: {
                return ScriptRuntime.toObjectOrNull(cx, arg, scope);
            }
            case 6: {
                return arg;
            }
        }
        throw new IllegalArgumentException();
    }
}

