/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class ServicesUtil {
    public static String toHexString(byte[] bytes) {
        StringBuilder strValue = new StringBuilder(bytes.length * 2);
        for (int bytesInd = 0; bytesInd < bytes.length; ++bytesInd) {
            strValue.append(ServicesUtil.toHexString(bytes[bytesInd]));
        }
        return strValue.toString();
    }

    public static String toHexString(byte value) {
        StringBuilder strValue = new StringBuilder(2);
        int intValue = value;
        if (intValue < 0) {
            intValue += 256;
        }
        if (intValue < 16) {
            strValue.append('0');
        }
        strValue.append(Integer.toHexString(intValue).toUpperCase());
        return strValue.toString();
    }

    public static byte[] fromHexString(String hexStr) {
        byte[] bytes = new byte[hexStr.length() / 2];
        int byteInd = 0;
        for (int strInd = 0; strInd < hexStr.length(); strInd += 2) {
            while (strInd < hexStr.length() && hexStr.charAt(strInd) < ' ') {
                ++strInd;
            }
            if (strInd >= hexStr.length()) break;
            bytes[byteInd++] = ServicesUtil.fromHexStr(hexStr.substring(strInd, strInd + 2));
        }
        if (byteInd < bytes.length) {
            byte[] newBytes = new byte[byteInd];
            System.arraycopy(bytes, 0, newBytes, 0, byteInd);
            return newBytes;
        }
        return bytes;
    }

    public static byte fromHexStr(String hexStr) {
        return (byte)Integer.parseInt(hexStr, 16);
    }

    public static void transformToXML(XMLReader pdfParser, InputStream inputXML, OutputStream xmlStream) throws PDFInvalidXMLException {
        Transformer xmlTransformer;
        TransformerFactory tFactory = TransformerFactory.newInstance();
        try {
            xmlTransformer = tFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        InputSource inputSource = inputXML == null ? new InputSource() : new InputSource(inputXML);
        SAXSource source = new SAXSource(pdfParser, inputSource);
        StreamResult result = new StreamResult(xmlStream);
        try {
            xmlTransformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new PDFInvalidXMLException(e);
        }
    }

    public static String makeNumbersString(double[] numbers, String numSeparator) {
        StringBuilder numberBuf = new StringBuilder();
        String separator = "";
        for (int numberInd = 0; numberInd < numbers.length; ++numberInd) {
            numberBuf.append(separator);
            numberBuf.append(numbers[numberInd]);
            separator = numSeparator;
        }
        return numberBuf.toString();
    }

    public static HashMap<String, String> finalizeSpanMap(HashMap<String, String> span, Boolean textDecorationValue, Boolean underline, Boolean superscript, Boolean subscript) {
        if (textDecorationValue != null && underline != null) {
            if (textDecorationValue.booleanValue() && underline.booleanValue()) {
                span.put("text-decoration", "underline line-through");
            } else if (!textDecorationValue.booleanValue() && !underline.booleanValue()) {
                span.remove("text-decoration");
            } else if (textDecorationValue.booleanValue()) {
                span.put("text-decoration", "line-through");
            } else if (underline.booleanValue()) {
                span.put("text-decoration", "underline");
            }
        } else if (textDecorationValue != null) {
            if (textDecorationValue.booleanValue()) {
                span.put("text-decoration", "line-through");
            } else {
                span.remove("text-decoration");
            }
        } else if (underline != null) {
            if (underline.booleanValue()) {
                span.put("text-decoration", "underline");
            } else {
                span.remove("text-decoration");
            }
        }
        if (superscript != null && subscript != null) {
            if (!superscript.booleanValue() && !subscript.booleanValue()) {
                span.remove("vertical-align");
            } else if (superscript.booleanValue()) {
                span.put("vertical-align", "+0.0pt");
            } else if (subscript.booleanValue()) {
                span.put("vertical-align", "-0.0pt");
            }
        } else if (superscript != null || subscript != null) {
            if (superscript != null && superscript.booleanValue()) {
                span.put("vertical-align", "+0.0pt");
            } else if (subscript != null && subscript.booleanValue()) {
                span.put("vertical-align", "-0.0pt");
            } else {
                span.remove("vertical-align");
            }
        }
        return span;
    }
}

