/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.forms.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontSimple;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationIterator;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAppearanceCharacteristics;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFBorderStyle;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFDefaultAppearance;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFField;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldButton;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldChoice;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldNode;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldText;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldType;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldUtils;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.services.forms.FieldOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class AcroformFieldUtils {
    AcroformFieldUtils() {
    }

    private static ASName getFontKey(PDFResources resources, PDFFont font) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFontMap fontMap = resources.procureFontMap();
        for (Map.Entry currEntry : fontMap.entrySet()) {
            if (!((PDFFont)currEntry.getValue()).equals(font)) continue;
            return (ASName)currEntry.getKey();
        }
        ASName newFontKey = fontMap.getNewName("F");
        fontMap.put(newFontKey, font);
        return newFontKey;
    }

    private static PDFDefaultAppearance createDefaultAppearance(PDFFont font, PDFResources resources, FieldOptions fieldOptions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName fontKey = PDFField.ASNAME_DEFAULT_FONT;
        if (font == null && !resources.procureFontMap().containsKey((Object)fontKey)) {
            font = PDFFontSimple.newInstance(resources.getPDFDocument(), ASName.k_Helvetica, ASName.k_Type1);
            resources.procureFontMap().put(PDFField.ASNAME_DEFAULT_FONT, font);
        }
        if (font != null) {
            fontKey = AcroformFieldUtils.getFontKey(resources, font);
        }
        return PDFDefaultAppearance.newInstance(resources.getPDFDocument(), fontKey, fieldOptions.getFontSize(), fieldOptions.getFontColor());
    }

    private static PDFAnnotationWidget addWidgetAnnotation(PDFPage page, PDFRectangle rect, PDFAppearanceCharacteristics appearanceCharacteristics, PDFDefaultAppearance defaultAppearance, PDFField parentField, PDFBorderStyle borderStyle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAnnotationWidget widgetAnnot = PDFAnnotationWidget.newInstance(page, rect);
        AcroformFieldUtils.setWidgetProperties(appearanceCharacteristics, defaultAppearance, borderStyle, widgetAnnot);
        parentField.addAnnotation(widgetAnnot);
        widgetAnnot.setParentField(parentField);
        return widgetAnnot;
    }

    private static void setWidgetProperties(PDFAppearanceCharacteristics appearanceCharacteristics, PDFDefaultAppearance defaultAppearance, PDFBorderStyle borderStyle, PDFAnnotationWidget widgetAnnot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        widgetAnnot.setAppearanceCharacteristics(appearanceCharacteristics);
        widgetAnnot.setBorderStyle(borderStyle);
        if (defaultAppearance != null) {
            widgetAnnot.setDictionaryStringOrStreamValue(ASName.k_DA, defaultAppearance.asString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static PDFField getFieldNode(String fieldName, FieldOptions fieldOptions, PDFFont font, PDFRectangle location, PDFPage page, PDFFieldType fieldType, PDFInteractiveForm iForm) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        AcroformFieldUtils.validateParameters(fieldName, location, page);
        PDFFieldNode parentFieldNode = PDFFieldUtils.procureIntermediateFieldNodes(fieldName, true, iForm);
        PDFFieldNode fieldNode = PDFFieldUtils.findChildFieldNode(fieldName, parentFieldNode, true);
        PDFDefaultAppearance da = AcroformFieldUtils.createDefaultAppearance(font, iForm.procureResources(), fieldOptions);
        PDFField mainField = null;
        if (fieldNode != null) {
            if (fieldNode.getFieldType() != fieldType) throw new PDFInvalidParameterException("An intermediate field node already uses the supplied qualified name");
            mainField = (PDFField)fieldNode;
            if (mainField.isAnnotation()) {
                PDFFieldButton buttonField;
                PDFFieldUtils.separateFieldAnnot(mainField);
                if (mainField instanceof PDFFieldButton && (buttonField = (PDFFieldButton)mainField).isRadioButton() && buttonField.getValueList() != null) {
                    buttonField.setNameValue(ASName.create("0"));
                    PDFAnnotationWidget widgetAnnot = (PDFAnnotationWidget)buttonField.getAnnotations().get(0);
                    widgetAnnot.setAppearanceState(true, "0");
                }
            }
            AcroformFieldUtils.addWidgetAnnotation(page, location, fieldOptions.getAppearanceCharacteristics(), da, (PDFField)fieldNode, fieldOptions.getBorderStyle());
        } else {
            mainField = AcroformFieldUtils.getInstance(fieldType, parentFieldNode, page, null, location);
            mainField.removeValue();
            String[] partialNames = fieldName.split("\\.");
            mainField.setPartialName(partialNames[partialNames.length - 1], true);
            AcroformFieldUtils.setWidgetProperties(fieldOptions.getAppearanceCharacteristics(), da, fieldOptions.getBorderStyle(), (PDFAnnotationWidget)mainField.getAnnotations().get(0));
        }
        mainField.setRequired(fieldOptions.isRequired());
        mainField.setReadOnly(fieldOptions.isReadOnly());
        return mainField;
    }

    private static PDFField getInstance(PDFFieldType fieldType, PDFFieldNode parentNode, PDFPage page, PDFDefaultAppearance da, PDFRectangle location) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFField field = null;
        switch (fieldType) {
            case Button: {
                field = PDFFieldButton.newInstance(parentNode, page, location, da, false);
                break;
            }
            case Choice: {
                field = PDFFieldChoice.newInstance(parentNode, page, location, da, false);
                break;
            }
            case Text: {
                field = PDFFieldText.newInstance(parentNode, page, location, da, false);
                break;
            }
            case Signature: {
                throw new PDFInvalidParameterException("Signature Field case not supported here");
            }
        }
        return field;
    }

    static PDFFieldNode getFieldNode(String fieldName, PDFInteractiveForm iForm) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        return PDFFieldUtils.getFieldNode(fieldName, iForm, true);
    }

    static void setCheckBoxValue(boolean selected, PDFFieldButton fieldNode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String state;
        String string = state = selected ? PDFFieldButton.DEFAULT_ON_STATE_NAME.asString() : PDFFieldButton.offState.asString();
        if (selected) {
            fieldNode.setNameValue(PDFFieldButton.DEFAULT_ON_STATE_NAME);
        } else {
            fieldNode.removeValue();
        }
        PDFAnnotationIterator iter = fieldNode.getAnnotationsIterator();
        while (iter.hasNext()) {
            ((PDFAnnotationWidget)iter.next()).setAppearanceState(selected, state);
        }
    }

    static void setListBoxValue(PDFFieldChoice fieldNode, int ... selectedOptionsIndex) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        List listBoxOptions = fieldNode.getOptionList();
        fieldNode.setIndexArray(selectedOptionsIndex);
        if (selectedOptionsIndex.length == 0) {
            fieldNode.removeValue();
        } else if (selectedOptionsIndex.length == 1) {
            fieldNode.setStringValue(listBoxOptions.get(selectedOptionsIndex[0]).toString());
        } else {
            ArrayList<String> selectedOptions = new ArrayList<String>();
            for (int i = 0; i < selectedOptionsIndex.length; ++i) {
                selectedOptions.add(listBoxOptions.get(selectedOptionsIndex[i]).toString());
            }
            fieldNode.setListValue(selectedOptions);
        }
    }

    private static void validateParameters(String fieldName, PDFRectangle location, PDFPage page) throws PDFInvalidParameterException {
        if (fieldName == null || fieldName.trim().length() == 0) {
            throw new PDFInvalidParameterException("Field name is a required parameter");
        }
        if (location == null) {
            throw new PDFInvalidParameterException("Location is a required parameter");
        }
        if (page == null) {
            throw new PDFInvalidParameterException("Page is a required parameter");
        }
    }
}

