/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.forms.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationIterator;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationList;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFField;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldButton;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldChoice;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldNode;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldSignature;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldText;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldType;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldUtils;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.services.forms.CheckBoxOptions;
import com.adobe.internal.pdftoolkit.services.forms.FieldType;
import com.adobe.internal.pdftoolkit.services.forms.FormFieldManager;
import com.adobe.internal.pdftoolkit.services.forms.ListBoxOptions;
import com.adobe.internal.pdftoolkit.services.forms.PushButtonOptions;
import com.adobe.internal.pdftoolkit.services.forms.RadioButtonOptions;
import com.adobe.internal.pdftoolkit.services.forms.TextFieldOptions;
import com.adobe.internal.pdftoolkit.services.forms.impl.AcroformFieldUtils;
import java.util.ArrayList;
import java.util.List;

public class AcroformFieldManagerImpl
implements FormFieldManager {
    private PDFInteractiveForm iForm;

    public AcroformFieldManagerImpl(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.iForm = pdfDoc.getInteractiveForm();
        if (this.iForm == null) {
            this.iForm = PDFInteractiveForm.newInstance(pdfDoc, null);
            pdfDoc.setInteractiveForm(this.iForm);
        }
    }

    @Override
    public void addTextField(String fieldName, String fieldValue, PDFRectangle location, PDFPage page, TextFieldOptions fieldOptions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (fieldOptions == null) {
            fieldOptions = new TextFieldOptions();
        }
        PDFFieldText fieldNode = (PDFFieldText)AcroformFieldUtils.getFieldNode(fieldName, fieldOptions, fieldOptions.getFont(), location, page, PDFFieldType.Text, this.iForm);
        fieldNode.setStringValue(fieldValue);
        fieldNode.setMultiline(fieldOptions.isMultiLine());
    }

    @Override
    public void addCheckBox(String checkBoxName, boolean selected, PDFRectangle location, PDFPage page, CheckBoxOptions fieldOptions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (fieldOptions == null) {
            fieldOptions = new CheckBoxOptions();
        }
        PDFFieldButton fieldNode = (PDFFieldButton)AcroformFieldUtils.getFieldNode(checkBoxName, fieldOptions, null, location, page, PDFFieldType.Button, this.iForm);
        fieldNode.setCheckBox();
        AcroformFieldUtils.setCheckBoxValue(selected, fieldNode);
    }

    @Override
    public void addListBox(String listBoxName, List<String> listBoxOptions, PDFRectangle location, PDFPage page, ListBoxOptions fieldOptions, int ... selectedOptionsIndex) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (fieldOptions == null) {
            fieldOptions = new ListBoxOptions();
        }
        if (!fieldOptions.isMultiSelect() && selectedOptionsIndex.length > 1) {
            throw new PDFInvalidParameterException("Multi-select is not allowed and selected indexs contain multiple values");
        }
        for (int i = 0; i < selectedOptionsIndex.length; ++i) {
            if (selectedOptionsIndex[i] >= 0 && selectedOptionsIndex[i] < listBoxOptions.size()) continue;
            throw new PDFInvalidParameterException("Out of range index value in selected options index array");
        }
        PDFFieldChoice fieldNode = (PDFFieldChoice)AcroformFieldUtils.getFieldNode(listBoxName, fieldOptions, fieldOptions.getFont(), location, page, PDFFieldType.Choice, this.iForm);
        fieldNode.setOptionList(listBoxOptions);
        fieldNode.setComboBox(fieldOptions.isComboBox());
        fieldNode.setMultipleSelectionAllowed(fieldOptions.isMultiSelect());
        fieldNode.setSort(fieldOptions.isSortItems());
        AcroformFieldUtils.setListBoxValue(fieldNode, selectedOptionsIndex);
    }

    @Override
    public void addPushButton(String buttonName, PDFRectangle location, PDFPage page, PushButtonOptions fieldOptions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (fieldOptions == null) {
            fieldOptions = new PushButtonOptions();
        }
        PDFFieldButton fieldNode = (PDFFieldButton)AcroformFieldUtils.getFieldNode(buttonName, fieldOptions, fieldOptions.getFont(), location, page, PDFFieldType.Button, this.iForm);
        fieldNode.setPushButon();
    }

    @Override
    public void addRadioButton(String radioButtonGroup, String radioButtonName, PDFRectangle location, PDFPage page, boolean selected, RadioButtonOptions fieldOptions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (fieldOptions == null) {
            fieldOptions = new RadioButtonOptions();
        }
        PDFFieldButton fieldNode = (PDFFieldButton)AcroformFieldUtils.getFieldNode(radioButtonGroup, fieldOptions, null, location, page, PDFFieldType.Button, this.iForm);
        fieldNode.setRadioButton();
        int radioButtonIndex = fieldNode.getAnnotations().size() - 1;
        PDFAnnotationWidget radioWidget = (PDFAnnotationWidget)fieldNode.getAnnotations().get(radioButtonIndex);
        ArrayList<String> optList = fieldNode.getOptionList();
        if (optList == null) {
            optList = new ArrayList<String>();
            for (int i = 0; i < radioButtonIndex; ++i) {
                optList.add(new Integer(i).toString());
            }
        }
        optList.add(radioButtonName != null ? radioButtonName : new Integer(radioButtonIndex).toString());
        fieldNode.setOptionList(optList);
        if (selected) {
            fieldNode.setNameValue(ASName.create(new Integer(radioButtonIndex).toString()));
            PDFAnnotationList annotList = fieldNode.getAnnotations();
            for (int i = 0; i < annotList.size(); ++i) {
                if (i == radioButtonIndex) continue;
                ((PDFAnnotationWidget)annotList.get(i)).setAppearanceState(false);
            }
        }
        radioWidget.setAppearanceState(selected, new Integer(radioButtonIndex).toString());
    }

    @Override
    public FieldType getFieldType(String fieldName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFFieldNode fieldNode = AcroformFieldUtils.getFieldNode(fieldName, this.iForm);
        if (fieldNode instanceof PDFField) {
            PDFField field = (PDFField)fieldNode;
            if (field instanceof PDFFieldText) {
                return FieldType.TEXT;
            }
            if (field instanceof PDFFieldButton) {
                PDFFieldButton button = (PDFFieldButton)field;
                if (button.isCheckBox()) {
                    return FieldType.CHECK_BOX;
                }
                if (button.isRadioButton()) {
                    return FieldType.RADIO_GROUP;
                }
                if (button.isPushButton()) {
                    return FieldType.PUSH_BUTTON;
                }
                throw new PDFInvalidDocumentException("Invalid Button Type Field");
            }
            if (field instanceof PDFFieldChoice) {
                PDFFieldChoice choice = (PDFFieldChoice)field;
                if (choice.isComboBox()) {
                    return FieldType.COMBO_BOX;
                }
                return FieldType.LIST_BOX;
            }
            if (field instanceof PDFFieldSignature) {
                return FieldType.SIGNATURE;
            }
        }
        return null;
    }

    @Override
    public boolean removeField(String fieldName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFFieldNode fieldNode = AcroformFieldUtils.getFieldNode(fieldName, this.iForm);
        if (fieldNode instanceof PDFField) {
            PDFFieldUtils.removeField((PDFField)fieldNode);
            return true;
        }
        return false;
    }

    @Override
    public String getTextFieldValue(String textFieldName) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFieldNode fieldNode = AcroformFieldUtils.getFieldNode(textFieldName, this.iForm);
        if (fieldNode instanceof PDFFieldText) {
            List valueList = fieldNode.getValueList();
            if (valueList != null && valueList.size() > 0) {
                return (String)valueList.get(0);
            }
            return null;
        }
        throw new PDFInvalidParameterException(textFieldName + "does not represent a text field");
    }

    @Override
    public boolean getCheckBoxValue(String checkBoxName) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFieldNode fieldNode = AcroformFieldUtils.getFieldNode(checkBoxName, this.iForm);
        if (fieldNode instanceof PDFFieldButton && ((PDFFieldButton)fieldNode).isCheckBox()) {
            List valueList = fieldNode.getValueList();
            if (valueList != null && valueList.size() > 0) {
                String value = valueList.get(0).toString();
                return !value.trim().equalsIgnoreCase("Off");
            }
            return false;
        }
        throw new PDFInvalidParameterException(checkBoxName + "does not represent a check box field");
    }

    @Override
    public int getSelectedRadioButtonIndex(String radioGroupName) throws NumberFormatException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFFieldNode fieldNode = AcroformFieldUtils.getFieldNode(radioGroupName, this.iForm);
        if (fieldNode instanceof PDFFieldButton && ((PDFFieldButton)fieldNode).isRadioButton()) {
            PDFAnnotationIterator annotIterator = ((PDFFieldButton)fieldNode).getAnnotationsIterator();
            int index = 0;
            while (annotIterator.hasNext()) {
                PDFAnnotationWidget annot = (PDFAnnotationWidget)annotIterator.next();
                ASName appearanceState = annot.getAppearanceState();
                if (appearanceState != PDFFieldButton.offState) {
                    return index;
                }
                ++index;
            }
            return -1;
        }
        throw new PDFInvalidParameterException(radioGroupName + "does not represent a radio button group");
    }

    @Override
    public List<String> getSelectedListBoxOptions(String listBoxName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFFieldNode fieldNode = AcroformFieldUtils.getFieldNode(listBoxName, this.iForm);
        if (fieldNode instanceof PDFFieldChoice) {
            return fieldNode.getValueList();
        }
        throw new PDFInvalidParameterException(listBoxName + "does not represent a list box");
    }

    @Override
    public boolean setRadioButtonGroupValue(String radioGroupName, int selectedButtonIndex) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFFieldNode fieldNode = AcroformFieldUtils.getFieldNode(radioGroupName, this.iForm);
        if (selectedButtonIndex < 0) {
            throw new PDFInvalidParameterException("Index of selected radio button outside the range");
        }
        fieldNode.setNameValue(ASName.create(new Integer(selectedButtonIndex).toString()));
        if (fieldNode instanceof PDFFieldButton) {
            PDFFieldButton buttonField = (PDFFieldButton)fieldNode;
            if (buttonField.isRadioButton()) {
                PDFAnnotationList annotList = buttonField.getAnnotations();
                for (int i = 0; i < annotList.size(); ++i) {
                    if (i != selectedButtonIndex) {
                        ((PDFAnnotationWidget)annotList.get(i)).setAppearanceState(false);
                        continue;
                    }
                    ((PDFAnnotationWidget)annotList.get(i)).setAppearanceState(true, new Integer(selectedButtonIndex).toString());
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean setTextFieldValue(String textFieldName, String value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFFieldNode fieldNode = AcroformFieldUtils.getFieldNode(textFieldName, this.iForm);
        if (fieldNode instanceof PDFFieldText) {
            fieldNode.setStringValue(value);
            return true;
        }
        return false;
    }

    @Override
    public boolean setCheckBoxValue(String checkBoxName, boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFFieldButton buttonField;
        PDFFieldNode fieldNode = AcroformFieldUtils.getFieldNode(checkBoxName, this.iForm);
        if (fieldNode instanceof PDFFieldButton && (buttonField = (PDFFieldButton)fieldNode).isCheckBox()) {
            AcroformFieldUtils.setCheckBoxValue(value, (PDFFieldButton)fieldNode);
            return true;
        }
        return false;
    }

    @Override
    public boolean setListBoxValue(String listBoxName, int ... selectedIndexs) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFFieldNode fieldNode = AcroformFieldUtils.getFieldNode(listBoxName, this.iForm);
        if (fieldNode instanceof PDFFieldChoice) {
            PDFFieldChoice choiceField = (PDFFieldChoice)fieldNode;
            if (selectedIndexs.length > 1 && !choiceField.isMultipleSelectionAllowed()) {
                throw new PDFInvalidParameterException("Mutiple values supplied for list box which allows single selection");
            }
            AcroformFieldUtils.setListBoxValue(choiceField, selectedIndexs);
            return true;
        }
        return false;
    }
}

