/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.fontresources.subsetting;

import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.CIDSystemInfo;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFEncodingDifferences;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontDescriptor;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontSimple;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType0;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFSimpleFontEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFToUnicodeCMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFType0FontEncoding;
import com.adobe.internal.pdftoolkit.services.fontresources.subsetting.CharCodeToCidMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class SubsetUtils {
    private static final byte[] suffixBytes = "endcmap\nCMapName currentdict /CMap defineresource pop\nend\nend\n".getBytes();

    static void cleanUpSimpleFontDict(PDFFont font, TreeMap<Integer, Integer> charCodesMap, Map<PDFEncodingDifferences, List<PDFFont>> fontEncodingToFontListMap) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFontSimple fontSimple = (PDFFontSimple)font;
        int minCharCode = charCodesMap.firstKey();
        int maxCharCode = charCodesMap.lastKey();
        ArrayList<Integer> widthsArray = new ArrayList<Integer>();
        for (int i = minCharCode; i <= maxCharCode; ++i) {
            if (charCodesMap.containsKey(i)) {
                widthsArray.add((int)fontSimple.getGlyphWidth(i));
                continue;
            }
            widthsArray.add(0);
        }
        fontSimple.setWidths(widthsArray);
        fontSimple.setDictionaryIntValue(ASName.k_FirstChar, minCharCode);
        fontSimple.setDictionaryIntValue(ASName.k_LastChar, maxCharCode);
        SubsetUtils.createUpdatedToUnicodeCMap(fontSimple, charCodesMap);
        PDFSimpleFontEncoding encoding = fontSimple.getEncoding();
        boolean createNewEncodingDictionary = false;
        List<PDFFont> fontInfo = null;
        if (encoding != null) {
            PDFEncodingDifferences differences = encoding.getDifferences();
            if (fontEncodingToFontListMap != null && (fontInfo = fontEncodingToFontListMap.get(differences)) != null && fontInfo.size() > 1) {
                createNewEncodingDictionary = true;
            }
            if (createNewEncodingDictionary) {
                PDFSimpleFontEncoding cloneEncoding = null;
                LinkedHashMap<Integer, String> differencesArray = new LinkedHashMap<Integer, String>();
                if (differences != null) {
                    Set<Map.Entry<Integer, ASName>> entrySet = differences.entrySet();
                    for (Map.Entry<Integer, ASName> currEntry : entrySet) {
                        differencesArray.put(currEntry.getKey(), currEntry.getValue().asString());
                    }
                }
                if (differencesArray != null && (cloneEncoding = PDFSimpleFontEncoding.newInstance(encoding.getPDFDocument(), encoding.getBaseEncoding(), differencesArray)) != null) {
                    PDFEncodingDifferences newDifferences = cloneEncoding.getDifferences();
                    SubsetUtils.updateDifferencesArrayinFontEncoding(newDifferences, charCodesMap);
                }
                if (cloneEncoding != null) {
                    fontSimple.setEncoding(cloneEncoding);
                }
                fontInfo.remove(font);
                fontEncodingToFontListMap.put(differences, fontInfo);
            } else {
                SubsetUtils.updateDifferencesArrayinFontEncoding(differences, charCodesMap);
            }
        }
        PDFFontDescriptor descriptor = fontSimple.getFontDescriptor();
        descriptor.setCharSet(null);
    }

    private static void updateDifferencesArrayinFontEncoding(PDFEncodingDifferences differences, TreeMap<Integer, Integer> charCodesMap) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (differences != null) {
            Set<Map.Entry<Integer, ASName>> entrySet = differences.entrySet();
            Iterator<Map.Entry<Integer, ASName>> iter = entrySet.iterator();
            while (iter.hasNext()) {
                Map.Entry<Integer, ASName> currEntry = iter.next();
                if (charCodesMap.containsKey(currEntry.getKey())) continue;
                iter.remove();
            }
            differences.updateDifferences();
        }
    }

    static void createUpdatedCMap(PDFFontType0 pdfFont, CharCodeToCidMapper charCodesToCidMap, TreeMap<Integer, Integer> charCodesToLengthMap) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFType0FontEncoding encoding = pdfFont.getEncoding();
        if (encoding == null || encoding.isPredefinedCMap()) {
            return;
        }
        String registry = "Adobe";
        String ordering = "UCS";
        String name = "Adobe-Identity-UCS";
        int supplement = 0;
        if (encoding != null) {
            CIDSystemInfo cidSysInfo = encoding.getCIDSystemInfo();
            if (cidSysInfo != null) {
                registry = cidSysInfo.getRegistry().asString();
                ordering = cidSysInfo.getOrdering().asString();
                supplement = cidSysInfo.getSupplement();
            }
            name = encoding.getCMapName().asString();
        }
        encoding.getCosStream().newDataDecoded(SubsetUtils.createUpdatedCMap(pdfFont.getPDFDocument(), charCodesToCidMap, charCodesToLengthMap, name, registry, ordering, supplement));
        encoding.getCosStream().remove(ASName.k_UseCMap);
    }

    public static InputByteStream createUpdatedCMap(PDFDocument pdfDoc, CharCodeToCidMapper charCodesToCidMap, TreeMap<Integer, Integer> charCodesToLengthMap, String encodingName, String registry, String ordering, int supplement) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            if (charCodesToCidMap == null) {
                charCodesToCidMap = new CharCodeToCidMapper(){

                    @Override
                    public int getCid(int charCode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
                        return charCode;
                    }
                };
            }
            OutputByteStream updatedToUnicodeStream = pdfDoc.getStreamManager().getOutputByteStreamClearTemp(ByteWriterFactory.Fixed.GROWABLE, 1024L);
            updatedToUnicodeStream.write(SubsetUtils.getPrefixBytes(registry, ordering, String.valueOf(supplement), encodingName));
            SubsetUtils.writeCodeSpaceRange(updatedToUnicodeStream, charCodesToLengthMap);
            SubsetUtils.writeCharCodesToCIDMappings(updatedToUnicodeStream, charCodesToLengthMap, charCodesToCidMap);
            updatedToUnicodeStream.write(suffixBytes);
            return updatedToUnicodeStream.closeAndConvert();
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    static void createUpdatedToUnicodeCMap(PDFFont pdfFont, TreeMap<Integer, Integer> charCodesMap) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        PDFToUnicodeCMap originalToUnicodeCMap = pdfFont.getToUnicodeCMap();
        if (originalToUnicodeCMap == null) {
            return;
        }
        try {
            OutputByteStream updatedToUnicodeStream = originalToUnicodeCMap.getPDFDocument().getStreamManager().getOutputByteStreamClearTemp(ByteWriterFactory.Fixed.GROWABLE, originalToUnicodeCMap.getLength());
            updatedToUnicodeStream.write(SubsetUtils.getPrefixBytes("Adobe", "UCS", "0", "Adobe-Identity-UCS"));
            SubsetUtils.writeCodeSpaceRange(updatedToUnicodeStream, charCodesMap);
            SubsetUtils.writeCharCodeToUnicodeMappings(updatedToUnicodeStream, charCodesMap, originalToUnicodeCMap);
            updatedToUnicodeStream.write(suffixBytes);
            originalToUnicodeCMap.getCosStream().newDataDecoded(updatedToUnicodeStream.closeAndConvert());
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    private static byte[] getPrefixBytes(String registry, String ordering, String supplement, String cmapName) {
        StringBuilder prefixString = new StringBuilder();
        prefixString.append("/CIDInit /ProcSet findresource begin\n\n12 dict begin\n\nbegincmap\n\n/CIDSystemInfo 3 dict dup begin\n/Registry (");
        prefixString.append(registry);
        prefixString.append(") def\n/Ordering (");
        prefixString.append(ordering);
        prefixString.append(") def\n/Supplement ");
        prefixString.append(supplement);
        prefixString.append(" def\n");
        prefixString.append("end def\n\n");
        if (cmapName != null && !cmapName.trim().equals("")) {
            prefixString.append("/CMapName /");
            prefixString.append(cmapName);
            prefixString.append(" def\n");
        }
        prefixString.append("/CMapVersion 1 def\n");
        prefixString.append("/CMapType 1 def\n");
        prefixString.append("/WMode 0 def\n");
        return prefixString.toString().getBytes();
    }

    private static void writeCodeSpaceRange(OutputByteStream outStream, TreeMap<Integer, Integer> charCodesMap) throws IOException {
        Collection<Integer> charCodeSizes = charCodesMap.values();
        int ranges = 0;
        StringBuilder sb = new StringBuilder();
        if (charCodeSizes.contains(1)) {
            sb.append("<00> <FF>\n");
            ++ranges;
        }
        if (charCodeSizes.contains(2)) {
            sb.append("<0000> <FFFF>\n");
            ++ranges;
        }
        sb.append("endcodespacerange\n");
        outStream.write((ranges + " begincodespacerange\n").getBytes());
        outStream.write(sb.toString().getBytes());
    }

    private static void writeCharCodesToCIDMappings(OutputByteStream updatedCmapStream, TreeMap<Integer, Integer> charCodesSet, CharCodeToCidMapper updatedCharCodeToCidMap) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, IOException {
        updatedCmapStream.write(Integer.toString(charCodesSet.size()).getBytes());
        updatedCmapStream.write(" begincidchar\n".getBytes());
        for (Map.Entry<Integer, Integer> currEntry : charCodesSet.entrySet()) {
            int currCharCode = currEntry.getKey();
            SubsetUtils.writeCharCodeToCIDMapping(updatedCmapStream, currCharCode, updatedCharCodeToCidMap.getCid(currCharCode), currEntry.getValue() * 2);
        }
        updatedCmapStream.write("endcidchar\n".getBytes());
    }

    private static void writeCharCodeToUnicodeMappings(OutputByteStream toUnicodeCmapStream, TreeMap<Integer, Integer> charCodesMap, PDFToUnicodeCMap originalToUnicodeMap) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, IOException {
        toUnicodeCmapStream.write(Integer.toString(charCodesMap.size()).getBytes());
        toUnicodeCmapStream.write(" beginbfchar\n".getBytes());
        for (Map.Entry<Integer, Integer> currEntry : charCodesMap.entrySet()) {
            int currCharCode = currEntry.getKey();
            SubsetUtils.writeCharCodeToUnicodeMapping(toUnicodeCmapStream, currCharCode, originalToUnicodeMap.toUnicode(currCharCode)[0], currEntry.getValue() * 2);
        }
        toUnicodeCmapStream.write("endbfchar\n".getBytes());
    }

    private static void writeCharCodeToCIDMapping(OutputByteStream cmap, long charCode, int cid, int charCodeSize) throws IOException {
        StringBuilder mapping = new StringBuilder();
        mapping.append("<");
        mapping.append(SubsetUtils.getPaddedHexString(Long.toHexString(charCode), charCodeSize));
        mapping.append("> ");
        mapping.append(Integer.toString(cid));
        mapping.append("\n");
        cmap.write(mapping.toString().getBytes());
    }

    private static void writeCharCodeToUnicodeMapping(OutputByteStream toUnicodeCmapStream, long charCode, long unicode, int charCodeSize) throws IOException {
        StringBuilder mapping = new StringBuilder();
        mapping.append("<");
        mapping.append(SubsetUtils.getPaddedHexString(Long.toHexString(charCode), charCodeSize));
        mapping.append("> <");
        mapping.append(SubsetUtils.getPaddedHexString(Long.toHexString(unicode), 4));
        mapping.append(">\n");
        toUnicodeCmapStream.write(mapping.toString().getBytes());
    }

    private static String getPaddedHexString(String hex, int totalLength) {
        int zeroesToBePadded = totalLength - hex.length();
        for (int i = 0; i < zeroesToBePadded; ++i) {
            hex = "0" + hex;
        }
        return hex;
    }
}

