/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.fontresources;

import com.adobe.fontengine.FontEngineException;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontImpl;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.PDFFontDescription;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.SubsetSimpleTrueType;
import com.adobe.fontengine.font.SubsetSimpleType1;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.cff.NameKeyedFont;
import com.adobe.fontengine.font.opentype.Cmap;
import com.adobe.fontengine.font.opentype.OpenTypeFont;
import com.adobe.fontengine.fontmanagement.Base14Font;
import com.adobe.fontengine.fontmanagement.FontLoader;
import com.adobe.internal.io.ByteBufferByteReader;
import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.io.stream.StreamManager;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnsupportedFeatureException;
import com.adobe.internal.pdftoolkit.core.fontset.impl.PDFFontSetImpl;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterFlate;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.CMapObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDFontWidths;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDSet;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDSystemInfo;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCosFontDescriptor;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFEncodingDifferences;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontDescriptor;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontFile;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontSimple;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType0;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFSimpleFontEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFToUnicodeCMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFType0FontEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.encodings.CharSetEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.encodings.MacExpertEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.encodings.MacRomanEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.encodings.SymbolEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.encodings.WinAnsiEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.AdobeGlyphList;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.CMapsUtil;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFFontUtils;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.StandardFontUtils;
import com.adobe.internal.pdftoolkit.services.fontresources.ByteGrowableArray;
import com.adobe.internal.pdftoolkit.services.fontresources.FontMatchingParameters;
import com.adobe.internal.pdftoolkit.services.fontresources.PDFFontListener;
import com.adobe.internal.pdftoolkit.services.fontresources.PDFSimpleFontValuesAccessorImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class FontResources {
    public static final String Helvetica = "Helvetica";
    public static final String MyriadPro = "MyriadPro-Regular";

    public static Locale getFontLocale(PDFFont pdfFont) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFCIDSystemInfo cidSystemInfo;
        PDFCIDFont cidFont;
        Locale locale = null;
        if (pdfFont instanceof PDFFontType0 && (cidFont = ((PDFFontType0)pdfFont).getDescendantFont()) != null && (cidSystemInfo = cidFont.getCIDSystemInfo()) != null) {
            String ordering = cidSystemInfo.getOrdering().asString();
            if ("Japan1".equals(ordering)) {
                locale = Locale.JAPANESE;
            } else if ("Korea1".equals(ordering)) {
                locale = Locale.KOREAN;
            } else if ("CNS1".equals(ordering)) {
                locale = Locale.TRADITIONAL_CHINESE;
            } else if ("GB1".equals(ordering)) {
                locale = Locale.SIMPLIFIED_CHINESE;
            }
        }
        if (locale == null) {
            PDFToUnicodeCMap unicodeCmap;
            PDFToUnicodeCMap pDFToUnicodeCMap = unicodeCmap = FontResources.isToUnicodeMapAsStream(pdfFont) ? pdfFont.getToUnicodeCMap() : null;
            if (unicodeCmap != null) {
                locale = unicodeCmap.getLocale();
            }
        }
        return locale;
    }

    private static boolean isToUnicodeMapAsStream(PDFFont font) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject unicodeMapObject = font.getDictionaryCosObjectValue(ASName.k_ToUnicode);
        return unicodeMapObject instanceof CosStream;
    }

    public static Font findFont(PDFDocument pdfDoc, PDFFontSetImpl fontSet, FontMatchingParameters fontMatchingParameters, boolean docLocaleFallbackAsDefault) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException {
        Font afeFont = null;
        String fontPostScriptName = fontMatchingParameters.getFontPostscriptName();
        afeFont = FontResources.getFontFromPostscriptName(fontSet, fontPostScriptName, fontMatchingParameters.isUseAliasStandardFontNames());
        if (afeFont == null) {
            Locale locale = fontMatchingParameters.getLocale();
            if (locale == null && docLocaleFallbackAsDefault) {
                locale = pdfDoc.getDocumentLocale();
            }
            if (locale != null) {
                afeFont = fontSet.getFallbackFont(locale);
            }
        }
        return afeFont;
    }

    private static Font getFontFromPostscriptName(PDFFontSetImpl fontSet, String fontPostScriptName, boolean useStandardFontNameAliases) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException {
        Font afeFont = null;
        if (fontPostScriptName != null) {
            String[] standardFontNames;
            String normalizedName = fontPostScriptName.replaceAll(" ", "");
            if (PDFFontUtils.isSubsetFontName(normalizedName)) {
                normalizedName = new StringBuilder(normalizedName).delete(0, 7).toString();
            }
            if ((standardFontNames = useStandardFontNameAliases ? StandardFontUtils.getStandardFontNames(ASName.create(normalizedName)) : new String[]{normalizedName}) != null) {
                for (int i = 0; i < standardFontNames.length && afeFont == null; ++i) {
                    afeFont = fontSet.getPSFont(standardFontNames[i], null, false);
                }
            } else {
                afeFont = fontSet.getPSFont(normalizedName, null, false);
            }
            if (afeFont == null) {
                afeFont = StandardFontUtils.getBase14Font(normalizedName, true);
            }
        }
        return afeFont;
    }

    public static Font findFont(String fontName, PDFDocument doc, PDFFontSetImpl fontSet, HashMap afeFontMap) throws PDFFontException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Font fontObj = null;
        ASName fontASName = ASName.create(fontName);
        if (doc.getInteractiveForm() == null || doc.getInteractiveForm().getResources() == null) {
            fontObj = StandardFontUtils.getBase14Font(fontName, true);
            return fontObj;
        }
        PDFFontMap fontMap = doc.getInteractiveForm().getResources().getFontMap();
        PDFFontDescriptor fontDescr = null;
        PDFFont pdfFont = null;
        if (fontMap != null) {
            pdfFont = fontMap.get(fontASName);
            fontDescr = PDFFontUtils.getPDFFontDescriptor(pdfFont);
        }
        if (fontDescr == null) {
            fontObj = StandardFontUtils.getBase14Font(fontName, true);
            return fontObj;
        }
        fontObj = FontResources.getEmbeddedFont(fontDescr, doc);
        if (fontObj == null) {
            FontMatchingParameters fontMatchingParamters = new FontMatchingParameters(pdfFont.getBaseFont().asString(true), null);
            fontMatchingParamters.setUseAliasStandardFontNames(false);
            fontObj = FontResources.findFont(doc, fontSet, fontMatchingParamters, false);
        }
        if (fontObj == null && pdfFont instanceof PDFFontSimple) {
            fontObj = FontResources.fontFauxing(doc, (PDFFontSimple)pdfFont, fontDescr);
            if (afeFontMap == null) {
                afeFontMap = new HashMap<Font, PDFFont>();
            }
            afeFontMap.put(fontObj, pdfFont);
        }
        return fontObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Font getEmbeddedFont(PDFFontDescriptor fontDescr, PDFDocument doc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFontListener fontListener;
        Font embeddedPDFFont;
        PDFCosFontDescriptor cosDesc = fontDescr.getPDFCosDescriptor();
        int objNum = 0;
        if (cosDesc != null) {
            objNum = cosDesc.getCosObject().getObjNum();
        }
        Font font = embeddedPDFFont = (fontListener = PDFFontListener.getFontListener(doc)) == null ? null : fontListener.getAFEFontForFontDescriptorFromCache(objNum);
        if (embeddedPDFFont != null) {
            return embeddedPDFFont;
        }
        if (fontDescr != null) {
            PDFFontFile pdfFontFile = PDFFontUtils.getFontFileFromFontDescriptor(fontDescr);
            if (pdfFontFile == null) {
                return null;
            }
            FontLoader fontLoader = new FontLoader();
            InputByteStream fontByteStream = null;
            InputStream fontStream = null;
            try {
                try {
                    fontByteStream = pdfFontFile.getStream();
                    long fontStreamLength = fontByteStream.length();
                    fontStream = fontByteStream.toInputStream();
                    embeddedPDFFont = fontLoader.load(fontStream, (int)fontStreamLength, true);
                }
                catch (FontEngineException e) {
                    Font font2 = null;
                    if (fontStream != null) {
                        try {
                            fontStream.close();
                        }
                        catch (IOException e2) {
                            throw new PDFIOException(e2);
                        }
                    }
                    if (fontByteStream != null) {
                        try {
                            fontByteStream.close();
                        }
                        catch (IOException e3) {
                            throw new PDFIOException("Error loading font from file.", e3);
                        }
                    }
                    return font2;
                }
                catch (IOException e) {
                    throw new PDFIOException("Error loading font from file.", e);
                }
            }
            finally {
                if (fontStream != null) {
                    try {
                        fontStream.close();
                    }
                    catch (IOException e) {
                        throw new PDFIOException(e);
                    }
                }
                if (fontByteStream != null) {
                    try {
                        fontByteStream.close();
                    }
                    catch (IOException e) {
                        throw new PDFIOException("Error loading font from file.", e);
                    }
                }
            }
        }
        if (objNum != 0 && fontListener != null) {
            fontListener.putAFEFontForFontDescriptorInCache(objNum, embeddedPDFFont);
        }
        return embeddedPDFFont;
    }

    private static Font fontFauxing(PDFDocument doc, PDFFontSimple pdfFont, PDFFontDescriptor fontDescr) throws PDFFontException {
        Font font = null;
        try {
            PDFSimpleFontValuesAccessorImpl fontAccessor = new PDFSimpleFontValuesAccessorImpl(doc, pdfFont, fontDescr);
            FontLoader loader = new FontLoader();
            font = loader.load(fontAccessor);
        }
        catch (InvalidFontException e) {
            throw new PDFFontException("Error in font fauxing.", e);
        }
        catch (UnsupportedFontException e) {
            throw new PDFUnsupportedFeatureException("Error in font fauxing.", e);
        }
        return font;
    }

    public static Object getSubsettedFontType1Stream(String[] glyphNames, Font afeFont, OutputStream subsetStream) throws InvalidFontException, UnsupportedFontException, IOException, FontLoadingException {
        SubsetSimpleType1 subset = new SubsetSimpleType1(glyphNames);
        PDFFontDescription afeFontDescr = afeFont.getPDFFontDescription();
        afeFontDescr.subsetAndStream(subset, subsetStream);
        return subset;
    }

    public static void getSubsettedCIDFontStream(Font afeFont, OutputStream subsetStream, Subset subset, boolean preserveROS) throws InvalidFontException, UnsupportedFontException, IOException, FontLoadingException {
        PDFFontDescription afeFontDescr = afeFont.getPDFFontDescription();
        afeFontDescr.subsetAndStream(subset, subsetStream, preserveROS);
    }

    public static Map<Integer, Integer> getSubsettedCIDFontStream(Set<Integer> gids, Font afeFont, OutputStream subsetStream, boolean preserveROS) throws PDFFontException, PDFIOException, PDFInvalidParameterException {
        HashMap<Integer, Integer> oldGidToNewGidMap = new HashMap<Integer, Integer>();
        try {
            Subset subset = afeFont.createSubset();
            for (int oldGid : gids) {
                int newGid = subset.getSubsetGid(oldGid);
                oldGidToNewGidMap.put(oldGid, newGid);
            }
            FontResources.getSubsettedCIDFontStream(afeFont, subsetStream, subset, preserveROS);
        }
        catch (FontLoadingException e) {
            throw new PDFFontException(e);
        }
        catch (InvalidFontException e) {
            throw new PDFFontException(e);
        }
        catch (UnsupportedFontException e) {
            throw new PDFFontException(e);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        return oldGidToNewGidMap;
    }

    public static Object getSubsettedFontTrueTypeStream(int[] codePoints, Font afeFont, OutputStream subsetStream, int platformID, int platformSpecificID, String[] postNames) throws InvalidFontException, UnsupportedFontException, FontLoadingException, IOException {
        PDFFontDescription afeFontDescr = afeFont.getPDFFontDescription();
        SubsetSimpleTrueType subset = new SubsetSimpleTrueType(platformID, platformSpecificID, codePoints, postNames);
        afeFontDescr.subsetAndStream(subset, subsetStream);
        return subset;
    }

    public static void getSubsettedFontTrueTypeStream(int[] codePoints, Font afeFont, OutputStream subsetStream, PDFFontUtils.OpenTypeCmapSubTableType openTypeCmapSubTableType) throws PDFFontException, PDFIOException, PDFInvalidParameterException {
        FontData afeFontData = null;
        try {
            afeFontData = ((FontImpl)afeFont).getFontData();
        }
        catch (UnsupportedFontException e) {
            throw new PDFFontException(e);
        }
        catch (InvalidFontException e) {
            throw new PDFFontException(e);
        }
        catch (FontLoadingException e) {
            throw new PDFFontException(e);
        }
        if (!(afeFontData instanceof OpenTypeFont)) {
            throw new PDFInvalidParameterException("OpenType font expected");
        }
        OpenTypeFont otFont = (OpenTypeFont)afeFontData;
        Cmap cmapTable = otFont.cmap;
        int platformID = -1;
        int platformSpecificID = -1;
        try {
            if (openTypeCmapSubTableType == PDFFontUtils.OpenTypeCmapSubTableType.ThreeZero && cmapTable.probe(3, 0) != -1) {
                platformID = 3;
                platformSpecificID = 0;
            } else if (openTypeCmapSubTableType == PDFFontUtils.OpenTypeCmapSubTableType.ThreeOne && cmapTable.probe(3, 1) != -1) {
                platformID = 3;
                platformSpecificID = 1;
            } else if (cmapTable.probe(1, 0) != -1) {
                platformID = 1;
                platformSpecificID = 0;
            } else {
                throw new PDFFontException("No Cmap table can be found");
            }
            FontResources.getSubsettedFontTrueTypeStream(codePoints, afeFont, subsetStream, platformID, platformSpecificID, null);
        }
        catch (InvalidFontException e) {
            throw new PDFFontException(e);
        }
        catch (UnsupportedFontException e) {
            throw new PDFFontException(e);
        }
        catch (FontLoadingException e) {
            throw new PDFFontException(e);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public static void embedFont(PDFFontType0 pdfFont, Font font, Subset fontSubset, TreeMap<Integer, byte[]> fontUnicodeMapping) throws PDFInvalidDocumentException, PDFIOException, PDFFontException, PDFSecurityException, PDFInvalidParameterException {
        try {
            PDFDocument pdfDocument = pdfFont.getPDFDocument();
            ASName basefontName = pdfFont.getBaseFont();
            PDFFontDescription fontDescription = font.getPDFFontDescription();
            PDFFontFile fontFile = FontResources.createPDFFontFile(pdfFont, font, fontSubset);
            PDFCIDSystemInfo pdfCIDSystemInfo = PDFCIDSystemInfo.newInstance(pdfDocument, new ASString("Adobe"), new ASString("Identity"), 1);
            PDFFontDescriptor fontDescriptor = PDFFontDescriptor.newInstance(pdfDocument, basefontName, fontDescription, 6);
            PDFCIDFont cidFont = PDFFontUtils.createPDFCIDFont(fontFile, pdfFont, fontDescription, 0, null, basefontName, fontDescriptor);
            cidFont.setCIDSystemInfo(pdfCIDSystemInfo);
            int subsetGlyphCount = fontSubset.getNumGlyphs();
            double[] dWidths = new double[subsetGlyphCount];
            for (int i = 0; i < fontSubset.getNumGlyphs(); ++i) {
                int fullGID = fontSubset.getFullGid(i);
                try {
                    dWidths[i] = fontDescription.getAdvance(fullGID);
                    continue;
                }
                catch (UnsupportedFontException e) {
                    throw new PDFUnsupportedFeatureException("Attempt to use unsupported font.", e);
                }
                catch (InvalidFontException e) {
                    throw new PDFFontException("Invalid Font in the Font Set.", e);
                }
            }
            PDFCIDFontWidths pdfCIDFontWidths = PDFCIDFontWidths.newInstance(pdfDocument, dWidths, 0);
            cidFont.setW(pdfCIDFontWidths);
            pdfFont.setDescendantFont(cidFont);
            int[] cids = new int[fontUnicodeMapping.size()];
            int index = 0;
            for (Map.Entry<Integer, byte[]> entry : fontUnicodeMapping.entrySet()) {
                PDFType0FontEncoding encoding = pdfFont.getEncoding();
                int cid = encoding.getCID(entry.getKey());
                cids[index++] = cid;
            }
            FontResources.embedCIDSet(pdfFont, fontSubset, cids);
            if (FontResources.isToUnicodeCmapRequired(pdfFont)) {
                FontResources.createToUnicodeCMap(pdfFont, fontUnicodeMapping);
            }
        }
        catch (FontEngineException e) {
            throw new PDFFontException("Invalid Font in the Font Set.", e);
        }
    }

    public static void createToUnicodeCMap(PDFFont font, TreeMap<Integer, byte[]> unicodeMap) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        if (unicodeMap == null) {
            return;
        }
        Iterator<Map.Entry<Integer, byte[]>> iter = unicodeMap.entrySet().iterator();
        Integer ccode = null;
        byte[] values = null;
        ArrayList<PDFToUnicodeCMap.CMapCodeMapping> mappingsList = new ArrayList<PDFToUnicodeCMap.CMapCodeMapping>();
        PDFToUnicodeCMap.CMapCodeMapping cmapping = null;
        while (iter.hasNext()) {
            Map.Entry<Integer, byte[]> entry = iter.next();
            ccode = entry.getKey();
            values = entry.getValue();
            ArrayList<byte[]> data = new ArrayList<byte[]>(1);
            data.add(values);
            cmapping = new PDFToUnicodeCMap.CMapCodeMapping(ccode, ccode, data);
            mappingsList.add(cmapping);
        }
        PDFToUnicodeCMap unicodeCMap = font.getToUnicodeCMap();
        if (unicodeCMap == null) {
            unicodeCMap = PDFToUnicodeCMap.newInstance(font.getPDFDocument());
        }
        unicodeCMap.mergeToUnicodeCMap(mappingsList);
        try {
            unicodeCMap.writeToStream();
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        font.setToUnicodeCMap(unicodeCMap);
    }

    public static boolean isToUnicodeCmapRequired(PDFFont font) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (font instanceof PDFFontSimple) {
            PDFFontSimple simpleFont = (PDFFontSimple)font;
            PDFSimpleFontEncoding encoding = simpleFont.getEncoding();
            if (encoding == null || encoding.isMacRomanEncoding() || encoding.isMacExpertEncoding() || encoding.isWinAnsiEncoding()) {
                return false;
            }
            PDFEncodingDifferences diff = encoding.getDifferences();
            if (diff != null) {
                CharSetEncoding macRomanEncoding = MacRomanEncoding.getEncoding();
                WinAnsiEncoding winAnsiEncoding = WinAnsiEncoding.getEncoding();
                SymbolEncoding symbolEncoding = SymbolEncoding.getEncoding();
                for (Map.Entry<Integer, ASName> entry : diff.entrySet()) {
                    String name = entry.getValue().asString();
                    if (macRomanEncoding.fromGlyphName(name) != 0 && winAnsiEncoding.fromGlyphName(name) != 0 && symbolEncoding.fromGlyphName(name) != 0 && MacExpertEncoding.contains(name)) continue;
                    return true;
                }
            }
            return false;
        }
        if (font instanceof PDFFontType0) {
            String ordering;
            PDFCIDSystemInfo charCollection;
            PDFFontType0 type0Font = (PDFFontType0)font;
            PDFType0FontEncoding cmap = type0Font.getEncoding();
            ASName cmapName = cmap.getCMapName();
            if (cmapName != ASName.k_Identity_H && cmapName != ASName.k_Identity_V && CMapsUtil.isPredefinedCmapPermitted(cmapName)) {
                return false;
            }
            PDFCIDFont desc = type0Font.getDescendantFont();
            if (desc != null && (charCollection = desc.getCIDSystemInfo()).getRegistry().asString().equals("Adobe") && ("GB1".equals(ordering = charCollection.getOrdering().asString()) || "CNS1".equals(ordering) || "Japan1".equals(ordering) || "Korea1".equals(ordering))) {
                return false;
            }
        }
        return true;
    }

    public static boolean isToUnicodeCmapRequiredForPDFA(PDFFont font, Set<Integer> charcodes) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String ordering;
        PDFCIDSystemInfo charCollection;
        PDFFontType0 type0Font;
        PDFCIDFont desc;
        if (font instanceof PDFFontSimple) {
            PDFFontDescriptor fontDesc;
            PDFFontSimple simpleFont = (PDFFontSimple)font;
            PDFSimpleFontEncoding encoding = simpleFont.getEncoding();
            if (encoding == null) {
                return false;
            }
            if (encoding.isMacRomanEncoding() || encoding.isMacExpertEncoding() || encoding.isWinAnsiEncoding()) {
                return false;
            }
            if (font.getSubtype() == ASName.k_TrueType && (fontDesc = simpleFont.getFontDescriptor()) != null && (fontDesc.getFlags() & 0x20) == 32) {
                return false;
            }
            if (font.getSubtype() == ASName.k_Type1 || font.getSubtype() == ASName.k_Type3) {
                SymbolEncoding symbolEncoding = SymbolEncoding.getEncoding();
                for (Integer charCode : charcodes) {
                    String gname;
                    try {
                        gname = simpleFont.charCode2glyphName(charCode);
                    }
                    catch (PDFFontException e) {
                        throw new PDFInvalidDocumentException("Exception occured while getting glyph name.", e);
                    }
                    if (AdobeGlyphList.hasGlyphName(gname) || symbolEncoding.fromGlyphName(gname) > 0) continue;
                    return true;
                }
                return false;
            }
        }
        return !(font instanceof PDFFontType0) || (desc = (type0Font = (PDFFontType0)font).getDescendantFont()) == null || !"Adobe".equals((charCollection = desc.getCIDSystemInfo()).getRegistry().asString()) || !"GB1".equals(ordering = charCollection.getOrdering().asString()) && !"CNS1".equals(ordering) && !"Japan1".equals(ordering) && !"Korea1".equals(ordering);
    }

    public static boolean isAFEFontEmbeddable(Font afeFont) throws PDFUnsupportedFeatureException, InvalidFontException, FontLoadingException, UnsupportedFontException {
        if (afeFont instanceof Base14Font) {
            return false;
        }
        return afeFont.canEmbedForPrintAndPreview();
    }

    public static boolean isNameKeyedFont(PDFFontDescription afeFont) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        return afeFont.getROS() == null;
    }

    public static int getFontIndexForGlyph(int glyphID, Font afeFont, List<PDFFont> pdfFontList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, InvalidFontException, UnsupportedFontException, FontLoadingException {
        if (pdfFontList.size() == 1) {
            return 0;
        }
        int i = 0;
        PDFFontDescription desc = afeFont.getPDFFontDescription();
        for (PDFFont pdfFont : pdfFontList) {
            PDFSimpleFontEncoding encoding = ((PDFFontSimple)pdfFont).getEncoding();
            if (encoding.fromGlyphName(desc.getGlyphName(glyphID)) != 0) {
                return i;
            }
            ++i;
        }
        return i;
    }

    public static boolean embedCharsetString(PDFFontSimple type1Font) throws FontLoadingException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, InvalidFontException, UnsupportedFontException {
        PDFFontDescription fontDesc;
        Font afeFont = type1Font.getAFEFont();
        if (afeFont != null && (fontDesc = afeFont.getPDFFontDescription()) != null) {
            PDFFontDescriptor pdfFontDesc;
            StringBuilder charSetBuilder = new StringBuilder();
            for (int gid = 0; gid < fontDesc.getNumGlyphs(); ++gid) {
                String glyphName = fontDesc.getGlyphName(gid);
                if (glyphName == null) continue;
                charSetBuilder.append('/').append(glyphName);
            }
            String charSetStr = charSetBuilder.toString();
            if (charSetStr.length() > 0 && (pdfFontDesc = type1Font.getFontDescriptor()) != null) {
                pdfFontDesc.setCharSet(charSetStr);
                return true;
            }
        }
        return false;
    }

    public static boolean embedCIDToGIDMap(PDFFontType0 type0Font, int[] cidArray, int[] gidArray) throws PDFIOException, PDFSecurityException, FontLoadingException, PDFInvalidDocumentException {
        ByteGrowableArray cidToGidMapArray = new ByteGrowableArray();
        CosDocument cosDoc = type0Font.getCosObject().getDocument();
        CosStream CIDToGIDMapObj = cosDoc.createCosStream();
        Font afeFont = type0Font.getAFEFont();
        if (afeFont == null) {
            return false;
        }
        for (int i = 0; i < cidArray.length; ++i) {
            int cid = cidArray[i];
            int gid = gidArray[i];
            if (cid < 0) continue;
            byte highOrderGIDByte = (byte)(gid >> 8);
            byte lowOrderGIDByte = (byte)(gid & 0xFF);
            cidToGidMapArray.set(highOrderGIDByte, cid * 2);
            cidToGidMapArray.set(lowOrderGIDByte, cid * 2 + 1);
        }
        try {
            byte[] cidToGidMapData = new byte[cidToGidMapArray.getLength()];
            System.arraycopy(cidToGidMapArray.getBuffer(), 0, cidToGidMapData, 0, cidToGidMapArray.getLength());
            ByteBufferByteReader reader = new ByteBufferByteReader(cidToGidMapData);
            StreamManager streamManager = type0Font.getStreamManager();
            InputByteStream cidStream = streamManager.getInputByteStream(reader);
            CIDToGIDMapObj.newDataDecoded(cidStream);
            CIDToGIDMapObj.put(ASName.create("Filter"), ASName.create("FlateDecode"));
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        CosDictionary cidFontObj = type0Font.getDescendantFont().getCosDictionary();
        cidFontObj.put(ASName.k_CIDToGIDMap, CIDToGIDMapObj);
        return true;
    }

    private static Set<Integer> generateCIDSet(PDFFontType0 type0Font, Subset fontSubset) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, FontEngineException {
        HashSet<Integer> cidSet = new HashSet<Integer>();
        FontData fontData = type0Font.getAFEFontData();
        CidSetCMapValueConsumer myCidSetCMapValueConsumer = new CidSetCMapValueConsumer(cidSet, fontData);
        PDFType0FontEncoding cMap = type0Font.getEncoding();
        CMapObject cmapPredef = null;
        if (cMap.getCMapName() == ASName.k_Identity_H || cMap.getCMapName() == ASName.k_Identity_V) {
            int i;
            int maxGlyph = Integer.MIN_VALUE;
            for (i = 0; i < fontSubset.getNumGlyphs(); ++i) {
                if (maxGlyph >= fontSubset.getFullGid(i)) continue;
                maxGlyph = fontSubset.getFullGid(i);
            }
            for (i = 0; i <= maxGlyph; ++i) {
                cidSet.add(i);
            }
        } else {
            cmapPredef = cMap.getPDFCMap().getCharCodeCMap();
            cmapPredef.enumerateValues(myCidSetCMapValueConsumer);
        }
        return cidSet;
    }

    public static boolean embedCIDSet(PDFFontType0 type0Font, Subset fontSubset, int[] cids) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, FontEngineException {
        PDFCIDFont cidFont = type0Font.getDescendantFont();
        ByteGrowableArray cidSetArray = new ByteGrowableArray();
        CosDocument cosDoc = type0Font.getCosObject().getDocument();
        CosStream CIDSetObj = cosDoc.createCosStream();
        if (cids != null && cids.length > 0) {
            int[] nArray = cids;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer cid = nArray[i];
                FontResources.setCidInfoInCidSetArray(cidSetArray, cid);
            }
        } else if (cidFont.getSubType() == ASName.k_CIDFontType0) {
            Font afeFont = type0Font.getAFEFont();
            if (afeFont == null) {
                return false;
            }
            PDFFontDescription afeFontDesc = afeFont.getPDFFontDescription();
            if (afeFontDesc == null) {
                return false;
            }
            int numGlyphs = afeFontDesc.getNumGlyphs();
            for (int i = 0; i < numGlyphs; ++i) {
                int identityCid = i;
                if (fontSubset != null && (identityCid = fontSubset.getExistingSubsetGid(i)) < 0) continue;
                int cid = afeFontDesc.getROS() == null ? identityCid : afeFontDesc.getGlyphCid(i);
                FontResources.setCidInfoInCidSetArray(cidSetArray, cid);
            }
        } else {
            Set<Integer> cidSet = FontResources.generateCIDSet(type0Font, fontSubset);
            for (int cid : cidSet) {
                FontResources.setCidInfoInCidSetArray(cidSetArray, cid);
            }
            FontResources.setCidInfoInCidSetArray(cidSetArray, 0);
        }
        try {
            byte[] cidSetBytes = new byte[cidSetArray.getLength()];
            System.arraycopy(cidSetArray.getBuffer(), 0, cidSetBytes, 0, cidSetArray.getLength());
            ByteBufferByteReader reader = new ByteBufferByteReader(cidSetBytes);
            StreamManager streamManager = type0Font.getStreamManager();
            InputByteStream cidStream = streamManager.getInputByteStream(reader);
            CIDSetObj.newDataDecoded(cidStream);
            CIDSetObj.put(ASName.create("Filter"), ASName.create("FlateDecode"));
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        PDFFontDescriptor fontDesc = type0Font.getDescendantFont().getFontDescriptor();
        if (fontDesc != null) {
            fontDesc.setCIDSet(PDFCIDSet.getInstance(CIDSetObj));
            return true;
        }
        return false;
    }

    private static void setCidInfoInCidSetArray(ByteGrowableArray cidSetArray, int cid) {
        int cidByteID = cid / 8;
        int cidBitShift = 7 - cid % 8;
        byte cidByteInfo = (byte)(1 << cidBitShift);
        byte currentByteInArray = cidSetArray.get(cidByteID);
        cidByteInfo = (byte)(cidByteInfo | currentByteInArray);
        cidSetArray.set(cidByteInfo, cidByteID);
    }

    private static PDFFontFile createPDFFontFile(PDFFontType0 pdfFont, Font font, Subset fontSubset) throws InvalidFontException, UnsupportedFontException, FontLoadingException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            PDFDocument pdfDocument = pdfFont.getPDFDocument();
            PDFFontDescription fontDescription = font.getPDFFontDescription();
            OutputByteStream outStream = pdfDocument.getStreamManager().getOutputByteStreamClearDocument(ByteWriterFactory.Fixed.GROWABLE, -1L);
            fontDescription.subsetAndStream(fontSubset, outStream.toOutputStream(), false);
            InputByteStream fontFileStream = outStream.closeAndConvert();
            outStream = null;
            PDFFontFile fontFile = PDFFontFile.newInstance(pdfDocument, fontFileStream);
            PDFFilterFlate filter = PDFFilterFlate.newInstance(fontFile.getPDFDocument(), null);
            fontFile.setFilter(filter);
            fontFileStream = null;
            return fontFile;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public static boolean isSubSetFont(PDFFont font) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName subType;
        if (font != null && ((subType = font.getSubtype()) == ASName.k_Type1 || subType == ASName.k_TrueType || font instanceof PDFFontType0)) {
            String baseFontName = font.getBaseFont().asString();
            return PDFFontUtils.isSubsetFontName(baseFontName);
        }
        return false;
    }

    public static boolean isFontCanBeSubsetted(PDFFont font) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName subType;
        if (font != null && ((subType = font.getSubtype()) == ASName.k_Type1 || subType == ASName.k_TrueType || font instanceof PDFFontType0)) {
            if ((subType == ASName.k_Type1 || font instanceof PDFFontType0) && font.getAFEFontData() instanceof NameKeyedFont) {
                return false;
            }
            String baseFontName = font.getBaseFont().asString();
            return PDFFontUtils.isSubsetFontName(baseFontName);
        }
        return false;
    }

    private static class CidSetCMapValueConsumer
    implements CMapObject.CMapValueConsumer {
        private Set<Integer> cidSet;
        private FontData afeFontData;

        CidSetCMapValueConsumer(Set<Integer> set, FontData fontData) {
            this.cidSet = set;
            this.afeFontData = fontData;
        }

        @Override
        public void value(long key, int aValue) throws FontEngineException {
            int gid = this.afeFontData.getGlyphForChar(aValue);
            if (gid >= 0) {
                this.cidSet.add((int)key);
            }
        }

        @Override
        public void value(long key, int[] aValue) throws FontEngineException {
        }
    }
}

