/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.fdf.impl;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFFileSpecification;

public final class FDFNamedPages
extends PDFCosDictionary {
    private FDFNamedPages(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static FDFNamedPages getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        FDFNamedPages pdfObject = (FDFNamedPages)PDFCosObject.getCachedInstance(cosObject, FDFNamedPages.class);
        if (pdfObject == null) {
            pdfObject = new FDFNamedPages(cosObject);
        }
        return pdfObject;
    }

    static FDFNamedPages newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        FDFNamedPages pdfObject = new FDFNamedPages(cosObject);
        return pdfObject;
    }

    ASString getName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryStringValue(ASName.k_Name);
    }

    void setName(ASString name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryASStringValue(ASName.k_Name, name);
    }

    PDFFileSpecification getFileSpecification() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFFileSpecification.getInstance(this.getDictionaryCosObjectValue(ASName.k_F));
    }

    void setFileSpecification(PDFFileSpecification fileSpec) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_F, fileSpec);
    }
}

