/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.fdf.impl;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import java.util.ArrayList;

public class FDFJavaScript
extends PDFCosDictionary {
    public static final ASName k_DOC = ASName.create("Doc");
    public static final ASName k_BEFORE = ASName.create("Before");
    public static final ASName k_AFTER = ASName.create("After");
    public static final ASName k_AFTERPERMS = ASName.create("AfterPermsReady");

    private FDFJavaScript(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static FDFJavaScript getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        FDFJavaScript pdfObject = (FDFJavaScript)PDFCosObject.getCachedInstance(cosObject, FDFJavaScript.class);
        if (pdfObject == null) {
            pdfObject = new FDFJavaScript(cosObject);
        }
        return pdfObject;
    }

    public static FDFJavaScript newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        return new FDFJavaScript(cosObject);
    }

    public String getBeforeScript() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String afterPermsReadyScript = this.getDictionaryTextStringOrStreamValue(k_BEFORE);
        return afterPermsReadyScript;
    }

    public String getAfterScript() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String afterPermsReadyScript = this.getDictionaryTextStringOrStreamValue(k_AFTER);
        return afterPermsReadyScript;
    }

    public String getAfterPermsReadyScript() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String afterPermsReadyScript = this.getDictionaryTextStringOrStreamValue(k_AFTERPERMS);
        return afterPermsReadyScript;
    }

    public boolean hasDoc() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return super.getCosDictionary().get(k_DOC) != null;
    }

    public ArrayList<Object> getDoc() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject options = super.getCosDictionary().get(k_DOC);
        if (options == null) {
            return null;
        }
        return this.addOptionsItem(new ArrayList<Object>(), options);
    }

    private ArrayList<Object> addOptionsItem(ArrayList<Object> optionList, CosObject cosItem) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (cosItem.getType() == 4) {
            PDFText text = PDFText.getInstance(cosItem);
            if (optionList == null) {
                optionList = new ArrayList();
            }
            optionList.add(text.stringValue());
        } else if (cosItem.getType() == 5) {
            CosArray cosArray = (CosArray)cosItem;
            ArrayList<Object> arrayVal = new ArrayList<Object>(2);
            for (int arrayInd = 0; arrayInd < cosArray.size(); ++arrayInd) {
                CosObject arrayItem = cosArray.get(arrayInd);
                this.addOptionsItem(arrayVal, arrayItem);
            }
            if (optionList == null) {
                optionList = arrayVal;
            } else {
                optionList.add(arrayVal);
            }
        }
        return optionList;
    }
}

