/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFDocMDPPermissions;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFFieldAction;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.services.digsig.SigFieldLock;
import com.adobe.internal.pdftoolkit.services.digsig.impl.SignatureFieldLockInterface;
import com.adobe.internal.pdftoolkit.services.xfa.XFADOM;
import com.adobe.internal.pdftoolkit.services.xfa.XFADOMService;
import com.adobe.internal.pdftoolkit.services.xfa.impl.XFAInternalUtils;
import com.adobe.internal.pdftoolkit.services.xfa.template.XFAManifest;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.XFA;
import com.adobe.xfa.form.FormField;
import com.adobe.xfa.template.TemplateModel;
import com.adobe.xfa.template.containers.Field;
import com.adobe.xfa.ut.ExFull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SignatureFieldLockXFA
implements SignatureFieldLockInterface {
    private Field xfaField;
    private XFAManifest manifestNode;
    private PDFDocument pdfDoc;

    public SignatureFieldLockXFA(PDFDocument pdfDoc, Field xfaField) throws PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (pdfDoc == null) {
            throw new PDFInvalidParameterException("PDF Document provided is null");
        }
        if (xfaField == null) {
            throw new PDFInvalidParameterException("XFA Field provided is null");
        }
        if (xfaField instanceof FormField) {
            this.xfaField = (Field)xfaField.getProto();
        }
        if (this.xfaField == null) {
            this.xfaField = xfaField;
        }
        this.pdfDoc = pdfDoc;
        Element manifestElement = XFAManifest.getManifestNode(xfaField);
        if (manifestElement != null) {
            this.manifestNode = new XFAManifest(manifestElement);
        }
    }

    @Override
    public List<String> getFields() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.manifestNode != null) {
            return this.manifestNode.getRefElements();
        }
        return null;
    }

    @Override
    public void setFields(List<String> fieldNames) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (this.manifestNode == null) {
            this.manifestNode = this.createNewManifest();
        }
        this.manifestNode.setRefElements(fieldNames);
        this.setXFAManifest(this.xfaField, this.manifestNode, false);
    }

    @Override
    public PDFFieldAction getFieldAction() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        XFAManifest.Action action;
        if (this.manifestNode != null && (action = this.manifestNode.getAction()) != null) {
            if (action == XFAManifest.Action.INCLUDE) {
                return PDFFieldAction.Include;
            }
            if (action == XFAManifest.Action.EXCLUDE) {
                return PDFFieldAction.Exclude;
            }
            if (action == XFAManifest.Action.ALL) {
                return PDFFieldAction.All;
            }
            throw new PDFInvalidDocumentException("Lock Action found is of invalid type");
        }
        return null;
    }

    @Override
    public void setFieldAction(PDFFieldAction action) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (this.manifestNode == null) {
            this.manifestNode = this.createNewManifest();
        }
        if (action == null) {
            this.manifestNode.setAction(null);
        } else {
            this.manifestNode.setAction(XFAManifest.Action.getInstance(action.toString()));
        }
        this.setXFAManifest(this.xfaField, this.manifestNode, false);
    }

    private XFAManifest createNewManifest() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new XFAManifest(XFAManifest.ACTION_INCLUDE, null);
    }

    @Override
    public void setFieldLock(SigFieldLock fieldLock) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (fieldLock != null) {
            if (fieldLock.getFieldAction() == null) {
                throw new PDFInvalidDocumentException("Action can't be null");
            }
            if (!(fieldLock.getFieldAction() != PDFFieldAction.Include && fieldLock.getFieldAction() != PDFFieldAction.Exclude || fieldLock.getFieldList() != null && fieldLock.getFieldList().size() != 0)) {
                throw new PDFInvalidParameterException("Field List can't be empty for Include / Exclude action");
            }
            if (fieldLock.getFieldAction() != this.getFieldAction()) {
                this.setFieldAction(fieldLock.getFieldAction());
            }
            if (fieldLock.getFieldAction() == PDFFieldAction.All) {
                fieldLock.setFieldList(null);
            }
            if (fieldLock.getFieldList() != null && fieldLock.getFieldList().size() > 0) {
                ArrayList<String> resolvedFields = new ArrayList<String>();
                resolvedFields.addAll(fieldLock.getFieldList());
                List<String> fields = null;
                if (resolvedFields != null) {
                    fields = this.getFields();
                    if (fields != null && !fields.isEmpty()) {
                        Collections.sort(fields);
                        Collections.sort(resolvedFields);
                        if (!fields.equals(resolvedFields)) {
                            this.setFields(resolvedFields);
                        }
                    } else {
                        this.setFields(resolvedFields);
                    }
                }
            } else if (this.getFields() != null) {
                this.setFields(null);
            }
        } else {
            if (this.getFieldAction() != null) {
                this.setFieldAction(null);
            }
            if (this.getFields() != null) {
                this.setFields(null);
            }
        }
    }

    @Override
    public SigFieldLock getFieldLock() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            PDFFieldAction fieldAction = this.getFieldAction();
            List<String> fieldList = this.getFields();
            if (fieldAction == PDFFieldAction.All) {
                return new SigFieldLock(fieldAction, null, null);
            }
            if (fieldAction != PDFFieldAction.All && (fieldList == null || fieldList.isEmpty())) {
                return null;
            }
            return new SigFieldLock(fieldAction, fieldList, null);
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException(e);
        }
    }

    @Override
    public PDFDocMDPPermissions getFieldPermissions() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return null;
    }

    @Override
    public void setFieldPermissions(PDFDocMDPPermissions perms) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
    }

    public void setXFAManifest(Field xfaField, XFAManifest xfaManifest, boolean checkXFAVersion) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (checkXFAVersion && !this.checkXFAVersion()) {
            throw new PDFInvalidParameterException("Cannot add an XFA manifest unless the document is not v25 or greater");
        }
        Element manifestElement = null;
        try {
            if (xfaField != null && xfaManifest != null) {
                PDFInteractiveForm mForm = this.pdfDoc.getInteractiveForm();
                Node nodeFound = null;
                Element sigField = null;
                XFADOM xfaDOM = XFADOMService.getXFADOMFromCache(this.pdfDoc);
                if (mForm != null && xfaDOM != null && xfaDOM.getTemplateModel() != null) {
                    nodeFound = xfaField.resolveNode("ui.signature");
                }
                if (nodeFound instanceof Element) {
                    sigField = (Element)nodeFound;
                }
                if (sigField == null) {
                    throw new PDFInvalidParameterException("There is no signature element in the field");
                }
                XFAInternalUtils.updateAttribute(sigField, XFA.TYPETAG, "type", "PDF1.6");
                manifestElement = sigField.getElement(XFA.MANIFESTTAG, true, 0, true, false);
                if (manifestElement != null) {
                    manifestElement.remove();
                }
                Element newManifest = manifestElement = sigField.getElement(XFA.MANIFESTTAG, false, 0, true, false);
                if (xfaManifest == null || xfaManifest.getAction() == null) {
                    XFAInternalUtils.updateAttribute(newManifest, XFA.ACTIONTAG, "action", null);
                } else {
                    XFAInternalUtils.updateAttribute(newManifest, XFA.ACTIONTAG, "action", xfaManifest.getAction().toString());
                }
                this.createManifestRefElements(xfaDOM.getTemplateModel(), xfaManifest.getRefElements(), newManifest, "ref");
            }
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException(e);
        }
    }

    private void createManifestRefElements(TemplateModel model, List valueList, Element childElement, String xfaTagName) {
        Iterator listIter;
        Element childSequenceElement = null;
        if (valueList != null && (listIter = valueList.iterator()) != null) {
            while (listIter.hasNext()) {
                childSequenceElement = model.createElement(childElement, childElement.getLastXMLChild(), null, xfaTagName);
                Object curElement = listIter.next();
                if (curElement == null) continue;
                model.createTextNode(childSequenceElement, null, curElement.toString());
            }
        }
    }

    public boolean checkXFAVersion() throws PDFInvalidDocumentException {
        XFADOM xfaDOM = XFADOMService.getXFADOMFromCache(this.pdfDoc);
        TemplateModel model = xfaDOM.getTemplateModel();
        if (model == null) {
            throw new PDFInvalidDocumentException("Invalid Document. Template is found null");
        }
        return model.getCurrentVersion() >= 25;
    }
}

