/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.impl;

import com.adobe.internal.pdftoolkit.core.credentials.Credentials;
import com.adobe.internal.pdftoolkit.core.credentials.impl.JCECredentials;
import com.adobe.internal.pdftoolkit.core.credentials.impl.RSACredentials;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSignatureException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignature;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignatureSubFilter;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFSaveOptions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFVersion;
import com.adobe.internal.pdftoolkit.services.digsig.SigCertificateSeedValue;
import com.adobe.internal.pdftoolkit.services.digsig.SigSeedValue;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureOptions;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureOptionsDocMDP;
import com.adobe.internal.pdftoolkit.services.digsig.UserInfo;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.RSACredentialUtils;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.SignatureHandlerPPKLite;
import com.adobe.internal.pdftoolkit.services.digsig.impl.DNUtils;
import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.OIDContainer;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.extensions.CertPolicies;
import com.rsa.certj.cert.extensions.KeyUsage;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

public final class SeedValueEnforcer {
    private static final List supportedDigests = Arrays.asList("SHA1", "SHA256", "SHA384", "SHA512", "RIPEMD160");
    private static final int NumKeyUsageBits = 9;
    private static final Double SV_VersionPDF1_5 = 1.0;
    private static final Double SV_VersionPDF1_6 = 2.0;
    private static final Double SV_VersionPDF1_7_Ext3 = 3.0;
    private static final int AdobeExtensionLevel_A9 = 3;

    public PDFSignatureSubFilter enforceSignatureHandlerSeed(SigSeedValue sigSeed, PDFSignatureSubFilter subFilter) throws PDFInvalidDocumentException, PDFSecurityException, PDFIOException, PDFInvalidParameterException {
        if (sigSeed != null) {
            Integer flag = sigSeed.getFlags();
            int flags = flag == null ? 0 : flag;
            this.enforceFilterSV(sigSeed.getFilter(), flags);
            List<ASName> subFiltersList = sigSeed.getSubFilters();
            subFilter = this.enforceSubFilterSV(subFiltersList != null ? subFiltersList.toArray(new ASName[0]) : null, flags, subFilter);
        }
        return subFilter;
    }

    private void enforceFilterSV(ASName filter, int flags) throws PDFInvalidParameterException {
        if (filter != null && (flags & 1) == 1 && filter != PDFSignature.k_Adobe_PPKLite) {
            throw new PDFInvalidParameterException("Filter (" + filter + ") specified by signature seed value is not available.");
        }
    }

    private ASName getFirstAllowedSupportedSubFilter(ASName[] allowedSubFilters) throws PDFInvalidParameterException {
        for (int i = 0; i < allowedSubFilters.length; ++i) {
            if (!SignatureHandlerPPKLite.isSubFilterSupported(allowedSubFilters[i])) continue;
            return allowedSubFilters[i];
        }
        throw new PDFInvalidParameterException("None of the subfilters specified by the signature seed value are available.");
    }

    private PDFSignatureSubFilter enforceSubFilterSV(ASName[] allowedSubFilters, int flags, PDFSignatureSubFilter signingSubFilter) throws PDFInvalidDocumentException, PDFInvalidParameterException {
        if (allowedSubFilters != null && (flags & 2) == 2) {
            if (signingSubFilter == null) {
                return PDFSignatureSubFilter.getInstance(this.getFirstAllowedSupportedSubFilter(allowedSubFilters));
            }
            boolean match = false;
            for (int i = 0; i < allowedSubFilters.length; ++i) {
                if (PDFSignatureSubFilter.getInstance(allowedSubFilters[i]) != signingSubFilter) continue;
                match = true;
                return signingSubFilter;
            }
            if (!match) {
                throw new PDFInvalidDocumentException("None of the subfilters specified by the signature seed value are available.");
            }
        } else if (allowedSubFilters == null && (flags & 2) == 2) {
            throw new PDFInvalidDocumentException("No seed subfilters specified by the signature seed value but the flag is set.");
        }
        return signingSubFilter;
    }

    public void enforceSignatureSeedValue(SigSeedValue sigSeed, Credentials credentials, SignatureOptions sigOptions, PDFSignatureSubFilter subFilter, PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFSecurityException, PDFIOException, PDFInvalidParameterException {
        if (sigSeed == null) {
            return;
        }
        Integer flag = sigSeed.getFlags();
        int flags = flag == null ? 0 : flag;
        UserInfo userInfo = sigOptions.getUserInfo();
        this.enforceVersionSV(flags, sigSeed, sigOptions, pdfDoc);
        this.enforceDigestMethodSV(sigSeed.getDigestMethod() != null ? sigSeed.getDigestMethod().toArray(new String[0]) : null, flags, credentials, sigOptions.getDigestMethod());
        this.enforceReasonsSV(sigSeed.getReasons() != null ? sigSeed.getReasons().toArray(new String[0]) : null, userInfo, flags);
        this.enforceLegalAttestationsSV(sigSeed.getLegalAttestations(), flags, sigOptions);
        this.enforceAddRevInfoSV(sigSeed.getRevInfo(), flags, sigOptions, subFilter);
        this.enforceTimeStampSV(sigSeed.getTimeStampURL(), sigSeed.getTimeStampFlag(), sigOptions);
        this.enforceCertificateSeedValue(sigSeed.getCertificateSeedValue(), credentials);
    }

    private void enforceReasonsSV(String[] reasons, UserInfo userInfo, int flags) throws PDFInvalidParameterException {
        if (reasons != null && (flags & 8) == 8) {
            if (reasons.length == 1 && reasons[0].equals(".")) {
                return;
            }
            if (userInfo == null) {
                throw new PDFInvalidParameterException("User info did not specify a reason for signing, and a reason for signing is required.");
            }
            boolean match = false;
            String clientReason = userInfo.getReason();
            for (int i = 0; i < reasons.length; ++i) {
                if (!reasons[i].equals(clientReason)) continue;
                match = true;
                break;
            }
            if (!match) {
                throw new PDFInvalidParameterException("Reason for signing in user info is not allowed by signature seed value reasons.");
            }
        }
    }

    private void enforceLegalAttestationsSV(String[] attestations, int flags, SignatureOptions sigOptions) throws PDFInvalidParameterException {
        if (attestations != null && (flags & 0x10) == 16) {
            if (!(sigOptions instanceof SignatureOptionsDocMDP)) {
                throw new PDFInvalidParameterException("Signature options did not specify an attestation string, and an attestation string is required.");
            }
            SignatureOptionsDocMDP docMDPOptions = (SignatureOptionsDocMDP)sigOptions;
            boolean match = false;
            String clientAttestation = docMDPOptions.getLegalAttestation();
            for (int i = 0; i < attestations.length; ++i) {
                if (!attestations[i].equals(clientAttestation)) continue;
                match = true;
                break;
            }
            if (!match) {
                throw new PDFInvalidParameterException("Attestation in signature options is not allowed by signature seed value attestations.");
            }
        }
    }

    private void enforceDigestMethodSV(String[] digestMethods, int flags, Credentials credentials, String digestMethod) throws PDFInvalidParameterException {
        String algorithm = null;
        if (digestMethods != null && digestMethods.length > 0 && (flags & 0x40) == 64) {
            if (credentials instanceof RSACredentials) {
                algorithm = ((RSACredentials)credentials).getJSAFEPrivateKey().getAlgorithm();
                this.checkDigestMethodValidity(digestMethods, digestMethod, algorithm);
            } else if (credentials instanceof JCECredentials) {
                this.checkDigestMethodValidity(digestMethods, digestMethod, ((JCECredentials)credentials).getPrivateKey().getAlgorithm());
            }
        }
    }

    private void checkDigestMethodValidity(String[] digestMethods, String digestMethod, String algorithm) throws PDFInvalidParameterException {
        if (algorithm.indexOf("RSA") != -1) {
            boolean match = false;
            for (int i = 0; i < digestMethods.length; ++i) {
                if (digestMethod.equalsIgnoreCase(digestMethods[i])) {
                    match = true;
                    if (supportedDigests.contains(digestMethod)) break;
                    throw new PDFInvalidParameterException("The digest method " + digestMethod + " is not specified in the supported digest method list");
                }
                match = false;
            }
            if (!match) {
                throw new PDFInvalidParameterException("The digest method " + digestMethod + " is not specified in the allowed digest method list");
            }
        }
    }

    private void enforceAddRevInfoSV(boolean addRevInfo, int flags, SignatureOptions sigOptions, PDFSignatureSubFilter subFilter) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException {
        if (addRevInfo && (flags & 0x20) == 32) {
            if (subFilter == PDFSignatureSubFilter.X509RSASha1) {
                throw new PDFInvalidParameterException("We cannot enforce revocation checking when the subfilter is adbe_x509_rsa_sha1");
            }
            if (!sigOptions.embedRevocationInfo()) {
                throw new PDFInvalidParameterException("Revocation info provider not registered but add rev info seed value is set. Signing cannot proceed.");
            }
        }
    }

    private void enforceTimeStampSV(String timestampURL, boolean timeStampRequired, SignatureOptions sigOptions) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException {
        if (timestampURL != null && timeStampRequired && !sigOptions.isApplyTimestamp()) {
            throw new PDFInvalidParameterException("Timestamp provider not registered but timestamp seed value is set. Signing cannot proceed.");
        }
    }

    private void enforceVersionSV(int flags, SigSeedValue sigSeed, SignatureOptions sigOptions, PDFDocument pdfDoc) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException, PDFInvalidParameterException {
        PDFVersion version = this.getSaveVersion(sigOptions, pdfDoc);
        int adobeExtensionLevel = version.getAdobeExtensionLevel();
        if ((flags & 4) == 4) {
            if (sigSeed.getVersion() == null) {
                if (version.equalTo(PDFVersion.v1_5)) {
                    sigSeed.setVersion(SV_VersionPDF1_5);
                }
                if (version.equalTo(PDFVersion.v1_6)) {
                    sigSeed.setVersion(SV_VersionPDF1_6);
                }
                if (version.equalTo(PDFVersion.v1_7)) {
                    if (adobeExtensionLevel == 3) {
                        sigSeed.setVersion(SV_VersionPDF1_7_Ext3);
                    } else {
                        sigSeed.setVersion(SV_VersionPDF1_6);
                    }
                }
            }
            int sigSeedVersion = sigSeed.getVersion().intValue();
            if (version.equalTo(PDFVersion.v1_5) && sigSeedVersion != 1) {
                throw new PDFInvalidParameterException("Version value in signature seed not set to 1 for PDF 1.5");
            }
            if (version.equalTo(PDFVersion.v1_6) && sigSeedVersion != 2) {
                throw new PDFInvalidParameterException("Version value in signature seed not set to 2 for PDF1.6");
            }
            if (version.equalTo(PDFVersion.v1_7)) {
                if (adobeExtensionLevel == 3 && sigSeedVersion != 3) {
                    throw new PDFInvalidParameterException("Version value in signature seed not set to 3 for PDF 1.7, Extension Level 3");
                }
                if (sigSeedVersion != 2) {
                    throw new PDFInvalidParameterException("Version value in signature seed not set to 2 for PDF 1.7");
                }
            }
        }
    }

    private PDFVersion getSaveVersion(SignatureOptions sigOptions, PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFSaveOptions saveOptions;
        PDFVersion version = pdfDoc.getOriginalVersion();
        if (version == null && sigOptions != null && sigOptions.hasSaveOptions() && (saveOptions = sigOptions.getSaveOptions()).containsVersion()) {
            version = saveOptions.getVersion();
        }
        return version;
    }

    private void enforceCertificateSeedValue(SigCertificateSeedValue certSeed, Credentials credentials) throws PDFInvalidDocumentException, PDFSecurityException, PDFIOException, PDFInvalidParameterException {
        if (certSeed != null) {
            int flags = certSeed.getFlags();
            if (credentials instanceof RSACredentials) {
                this.enforceSubjectSVForRSACerts(certSeed.getSubjects(), flags, credentials);
            } else if (credentials instanceof JCECredentials) {
                this.enforceSubjectSV(certSeed.getSubjects(), flags, (JCECredentials)credentials);
            }
            if (credentials instanceof RSACredentials) {
                this.enforceIssuerSVForRSACerts(certSeed.getIssuers(), flags, credentials, certSeed.getOIDS());
            } else if (credentials instanceof JCECredentials) {
                this.enforceIssuerSV(certSeed.getIssuers(), flags, credentials, certSeed.getOIDS());
            }
            this.enforceSubjectDNSV(certSeed, credentials, flags);
            this.enforceKeyUsageSV(certSeed, credentials, flags);
        }
    }

    private void enforceSubjectSV(byte[][] subjectCerts, int flags, JCECredentials credentials) throws PDFInvalidDocumentException, PDFInvalidParameterException {
        java.security.cert.X509Certificate clientCert = credentials.getCertificate();
        if (subjectCerts != null && subjectCerts.length > 0 && (flags & 1) == 1) {
            boolean match = false;
            for (int i = 0; i < subjectCerts.length; ++i) {
                ByteArrayInputStream inStream = new ByteArrayInputStream(subjectCerts[i]);
                try {
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    java.security.cert.X509Certificate allowedCert = (java.security.cert.X509Certificate)cf.generateCertificate(inStream);
                    if (!allowedCert.equals(clientCert)) continue;
                    match = true;
                    break;
                }
                catch (java.security.cert.CertificateException e) {
                    throw new PDFInvalidDocumentException("Could not parse subject certificate in certificate seed value object.", e);
                }
                finally {
                    try {
                        if (inStream != null) {
                            ((InputStream)inStream).close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            if (!match) {
                throw new PDFInvalidParameterException("Certificate seed value does not allow the specified subject certificate.");
            }
        }
    }

    private void enforceSubjectSVForRSACerts(byte[][] subjectCerts, int flags, Credentials credentials) throws PDFInvalidDocumentException, PDFInvalidParameterException {
        X509Certificate clientCert = null;
        if (!(credentials instanceof RSACredentials)) {
            throw new PDFInvalidParameterException("The credentials supplied do not have RSA certs");
        }
        clientCert = ((RSACredentials)credentials).getRSAX509Cert();
        if (subjectCerts != null && subjectCerts.length > 0 && (flags & 1) == 1) {
            boolean match = false;
            for (int i = 0; i < subjectCerts.length; ++i) {
                X509Certificate allowedCert;
                try {
                    allowedCert = new X509Certificate(subjectCerts[i], 0, 0);
                }
                catch (CertificateException e) {
                    throw new PDFInvalidDocumentException("Could not parse subject certificate in certificate seed value object.", e);
                }
                if (!allowedCert.equals((Object)clientCert)) continue;
                match = true;
                break;
            }
            if (!match) {
                throw new PDFInvalidParameterException("Certificate seed value does not allow the specified subject certificate.");
            }
        }
    }

    private void enforceIssuerSV(byte[][] issuerCerts, int flags, Credentials credentials, String[] requiredOIDS) throws PDFInvalidParameterException {
        if (issuerCerts != null && issuerCerts.length > 0 && (flags & 2) == 2 && requiredOIDS != null && requiredOIDS.length > 0 && (flags & 4) == 4) {
            try {
                this.enforceCertPolicies(RSACredentialUtils.getRSACertificate(credentials), requiredOIDS);
            }
            catch (PDFSignatureException e) {
                throw new PDFInvalidParameterException(e);
            }
        }
    }

    private void enforceIssuerSVForRSACerts(byte[][] issuerCerts, int flags, Credentials credentials, String[] requiredOIDS) throws PDFInvalidDocumentException, PDFInvalidParameterException {
        X509Certificate clientCert = null;
        if (!(credentials instanceof RSACredentials)) {
            throw new PDFInvalidParameterException("The credentials supplied do not have RSA certs");
        }
        clientCert = ((RSACredentials)credentials).getRSAX509Cert();
        if (issuerCerts != null && (flags & 2) == 2 && requiredOIDS != null && requiredOIDS.length > 0 && (flags & 4) == 4) {
            this.enforceCertPolicies(clientCert, requiredOIDS);
        }
    }

    private void enforceCertPolicies(X509Certificate cert, String[] requiredOIDS) throws PDFInvalidParameterException {
        try {
            CertPolicies policies = null;
            if (cert.getExtensions() == null || (policies = (CertPolicies)cert.getExtensions().getExtensionByType(32)) == null) {
                throw new PDFInvalidParameterException("Certificate seed value required policy OID is not present in signing certificate.");
            }
            ArrayList<Oid> oidList = new ArrayList<Oid>();
            for (int i = 0; i < policies.getPoliciesCount(); ++i) {
                byte[] oid = policies.getCertPolicyId(i);
                OIDContainer asn1Oid = new OIDContainer(0x1000000, true, 0, oid, 0, oid.length);
                ASN1Container[] asn1Def = new ASN1Container[]{asn1Oid};
                oidList.add(new Oid(ASN1.derEncode((ASN1Container[])asn1Def)));
            }
            Oid[] certOIDS = oidList.toArray(new Oid[oidList.size()]);
            for (int i = 0; i < requiredOIDS.length; ++i) {
                try {
                    if (new Oid(requiredOIDS[i]).containedIn(certOIDS)) continue;
                    throw new PDFInvalidParameterException("Certificate seed value required policy OID is not present in signing certificate.");
                }
                catch (GSSException e) {
                    throw new PDFInvalidParameterException("Exception when constructing and checking policy oids against seed value oids", e);
                }
            }
        }
        catch (CertificateException e) {
            throw new PDFInvalidParameterException("The certificate present in the credentials could not be processed to extract policy oids.", e);
        }
        catch (ASN_Exception e) {
            throw new PDFInvalidParameterException("The policy oids present in the signing certificate could not be parsed.", e);
        }
        catch (GSSException e) {
            throw new PDFInvalidParameterException("Exception when constructing policy oid", e);
        }
    }

    private void enforceKeyUsageSV(SigCertificateSeedValue certSeed, Credentials credentials, int flags) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        String[] keyUsageSVExtensions = certSeed.getKeyUsages();
        if (keyUsageSVExtensions != null && keyUsageSVExtensions.length > 0 && (flags & 0x20) == 32) {
            boolean[] signingCertKeyUsage = null;
            X509V3Extension certExtension = null;
            try {
                if (credentials instanceof RSACredentials) {
                    certExtension = ((RSACredentials)credentials).getRSAX509Cert().getExtensions().getExtensionByType(15);
                    signingCertKeyUsage = this.createBooleanArray(certExtension);
                } else if (credentials instanceof JCECredentials) {
                    java.security.cert.X509Certificate clientCert = ((JCECredentials)credentials).getCertificate();
                    signingCertKeyUsage = clientCert.getKeyUsage();
                }
            }
            catch (CertificateException e) {
                throw new PDFInvalidParameterException("Could not obtain the key usage extensions from the certificate", e);
            }
            boolean match = false;
            for (int i = 0; i < keyUsageSVExtensions.length; ++i) {
                String keyUsageValue = keyUsageSVExtensions[i];
                if (keyUsageValue != null && keyUsageValue.length() > 0 && signingCertKeyUsage != null) {
                    for (int idx = 0; idx < keyUsageValue.length(); ++idx) {
                        boolean checkBit = this.toBoolean(keyUsageValue, idx);
                        if (checkBit) {
                            if (checkBit != signingCertKeyUsage[idx]) {
                                match = false;
                                break;
                            }
                            if (idx == 0 && !signingCertKeyUsage[idx]) {
                                throw new PDFInvalidParameterException("The digital signature KeyUsage bit at position 0 is not set.");
                            }
                        }
                        match = true;
                    }
                } else {
                    match = false;
                }
                if (match) break;
            }
            if (!match) {
                throw new PDFInvalidParameterException("Seed value KeyUsage extensions are not present in the signing cert.");
            }
        }
    }

    private boolean[] createBooleanArray(X509V3Extension certExtension) {
        boolean[] keyUsage = new boolean[9];
        for (int idx = 0; idx < 9; ++idx) {
            keyUsage[idx] = this.getKeyUsageBit(certExtension, idx);
        }
        return keyUsage;
    }

    private boolean getKeyUsageBit(X509V3Extension certExtension, int index) {
        if (index == 0) {
            return ((KeyUsage)certExtension).verifyKeyUsage(Integer.MIN_VALUE);
        }
        if (index == 1) {
            return ((KeyUsage)certExtension).verifyKeyUsage(0x40000000);
        }
        if (index == 2) {
            return ((KeyUsage)certExtension).verifyKeyUsage(0x20000000);
        }
        if (index == 3) {
            return ((KeyUsage)certExtension).verifyKeyUsage(0x10000000);
        }
        if (index == 4) {
            return ((KeyUsage)certExtension).verifyKeyUsage(0x8000000);
        }
        if (index == 5) {
            return ((KeyUsage)certExtension).verifyKeyUsage(0x4000000);
        }
        if (index == 6) {
            return ((KeyUsage)certExtension).verifyKeyUsage(0x2000000);
        }
        if (index == 7) {
            return ((KeyUsage)certExtension).verifyKeyUsage(0x1000000);
        }
        if (index == 8) {
            return ((KeyUsage)certExtension).verifyKeyUsage(0x800000);
        }
        return false;
    }

    private boolean toBoolean(String keyUsageString, int index) {
        return keyUsageString.charAt(index) == '1';
    }

    private void enforceSubjectDNSV(SigCertificateSeedValue certSeed, Credentials credentials, int flags) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        List<Map> subjectDNList = certSeed.getSubjectDN();
        if (subjectDNList != null && !subjectDNList.isEmpty() && (flags & 8) == 8) {
            X500Name certSubjectDNName = null;
            if (credentials instanceof RSACredentials) {
                certSubjectDNName = ((RSACredentials)credentials).getRSAX509Cert().getSubjectName();
            } else if (credentials instanceof JCECredentials) {
                X500Principal certPrincipal = ((JCECredentials)credentials).getCertificate().getSubjectX500Principal();
                try {
                    certSubjectDNName = new X500Name(certPrincipal.getName("RFC2253"));
                }
                catch (NameException e) {
                    throw new PDFInvalidParameterException("Cannot construct an X500Name for the given certificate", e);
                }
            }
            try {
                this.checkCertSubjectDN(certSubjectDNName, subjectDNList);
            }
            catch (NameException e) {
                throw new PDFInvalidParameterException("Certificate DN - " + certSubjectDNName + " is incorrectly formatted", e);
            }
        }
    }

    private void checkCertSubjectDN(X500Name certSubjectDNName, List<Map> subjectDNList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, NameException {
        DNUtils dnUtils = new DNUtils(certSubjectDNName);
        Map<Integer, String> attrIDValueMap = dnUtils.createDNAttributeIDValueMap();
        Iterator<Map> subjectDNIter = subjectDNList.iterator();
        boolean match = false;
        StringBuilder exceptionList = null;
        if (subjectDNIter != null) {
            while (subjectDNIter.hasNext()) {
                Map subjectDN = subjectDNIter.next();
                Set pairs = subjectDN.entrySet();
                for (Map.Entry entry : pairs) {
                    String attributeNameSV = (String)entry.getKey();
                    String attributeSeedValue = (String)entry.getValue();
                    String escapedAttrSeedValue = DNUtils.getEscapedRDNValue(attributeSeedValue);
                    Integer attributeID = dnUtils.getAttributeID(attributeNameSV + "=" + escapedAttrSeedValue);
                    if (attrIDValueMap.containsKey(attributeID)) {
                        String attrSignCertValue = attrIDValueMap.get(attributeID);
                        if (!attrSignCertValue.equalsIgnoreCase(escapedAttrSeedValue)) {
                            match = false;
                            if (exceptionList == null) {
                                exceptionList = new StringBuilder(75);
                            }
                            exceptionList.append("SubjectDN attribute name or value for ").append(attributeNameSV).append(" is not present in signing certificate.\n");
                            break;
                        }
                        match = true;
                        continue;
                    }
                    exceptionList.append("SubjectDN attribute name or value ").append(attributeNameSV).append(" is not present in signing certificate.\n");
                    throw new PDFInvalidParameterException("Certificate Seed Value : - None of the subjectDN seedvalues match the signing certificate.\n" + exceptionList.toString());
                }
                if (!match) continue;
                break;
            }
            if (!match) {
                throw new PDFInvalidParameterException("Certificate seed value : required value for SubjectDN attribute  is not present in signing certificate.");
            }
        }
    }
}

