/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.impl;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosContainer;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.traverser.DispatchItem;
import com.adobe.internal.pdftoolkit.core.traverser.Dispatcher;
import com.adobe.internal.pdftoolkit.core.traverser.Traverser;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.services.digsig.impl.LegalAttestationWarning;
import com.adobe.internal.pdftoolkit.services.digsig.impl.LegalBaseDispatch;
import com.adobe.internal.pdftoolkit.services.digsig.impl.LegalBaseWarning;
import com.adobe.internal.pdftoolkit.services.optionalcontent.impl.OCMembership;
import com.adobe.internal.pdftoolkit.services.optionalcontent.impl.OCProperties;
import java.util.ArrayList;
import java.util.Map;

public final class LegalAttestationDispatch
extends LegalBaseDispatch
implements Dispatcher {
    public LegalAttestationDispatch(Map<LegalBaseWarning, Integer> legalWarnings) {
        super(legalWarnings);
        this.dispatchKeyMap.put(ASName.k_ExtGState, new DispatchExtGStatePDF16());
        this.dispatchKeyMap.put(ASName.k_InkList, new DispatchInkList());
        this.dispatchKeyMap.put(ASName.k_OCProperties, new DispatchOCProperties());
        this.dispatchKeyMap.put(ASName.k_Ref, new DispatchReferenceXObjectPDF16());
        this.dispatchKeyMap.put(ASName.k_F, new DispatchExternalStreamPDF16());
        this.dispatchValueMap.put(ASName.k_OCMD, new DispatchOCMD());
        this.dispatchValueMap.put(ASName.k_Font, new DispatchFont());
        DispatchAnnotation dispatchAnnotation = new DispatchAnnotation();
        this.dispatchValueMap.put(ASName.k_Circle, dispatchAnnotation);
        this.dispatchValueMap.put(ASName.k_PrinterMark, dispatchAnnotation);
        this.dispatchValueMap.put(ASName.k_FileAttachment, dispatchAnnotation);
        this.dispatchValueMap.put(ASName.k_FreeText, dispatchAnnotation);
        this.dispatchValueMap.put(ASName.k_Highlight, dispatchAnnotation);
        this.dispatchValueMap.put(ASName.k_Ink, dispatchAnnotation);
        this.dispatchValueMap.put(ASName.k_Line, dispatchAnnotation);
        this.dispatchValueMap.put(ASName.k_Popup, dispatchAnnotation);
        this.dispatchValueMap.put(ASName.k_Square, dispatchAnnotation);
        this.dispatchValueMap.put(ASName.k_Stamp, dispatchAnnotation);
        this.dispatchValueMap.put(ASName.k_StrikeOut, dispatchAnnotation);
        this.dispatchValueMap.put(ASName.k_Text, dispatchAnnotation);
        this.dispatchValueMap.put(ASName.k_TrapNet, dispatchAnnotation);
        this.dispatchValueMap.put(ASName.k_Underline, dispatchAnnotation);
        ArrayList<DispatchItem> movieActionOrAnnotDispatch = new ArrayList<DispatchItem>();
        movieActionOrAnnotDispatch.add(new LegalBaseDispatch.DispatchMovieAction(this));
        movieActionOrAnnotDispatch.add(dispatchAnnotation);
        this.dispatchValueMap.put(ASName.k_Movie, movieActionOrAnnotDispatch);
        ArrayList<DispatchItem> soundActionOrAnnotDispatch = new ArrayList<DispatchItem>();
        soundActionOrAnnotDispatch.add(new LegalBaseDispatch.DispatchSoundAction(this));
        soundActionOrAnnotDispatch.add(dispatchAnnotation);
        this.dispatchValueMap.put(ASName.k_Sound, soundActionOrAnnotDispatch);
        this.dispatchValueMap.put(ASName.k_Hide, new DispatchHideAction());
    }

    class DispatchHideAction
    extends LegalBaseDispatch.DispatchAction
    implements DispatchItem {
        DispatchHideAction() {
            super(LegalAttestationDispatch.this);
        }

        @Override
        public boolean visit(CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            CosContainer hideAction = ((Traverser.TraverserStackItem)curStack.get(curStack.size() - 1)).getContainer();
            if (hideAction != null) {
                LegalAttestationDispatch.this.incrementCounter(LegalBaseWarning.k_HideActions);
            }
            return true;
        }
    }

    class DispatchExternalStreamPDF16
    implements DispatchItem {
        DispatchExternalStreamPDF16() {
        }

        @Override
        public boolean verifyIdentity(ASName objKey, CosObject obj, ArrayList<?> curStack) {
            return ((Traverser.TraverserStackItem)curStack.get(curStack.size() - 1)).getContainer() instanceof CosStream && (!(obj instanceof CosDictionary) || !((CosDictionary)obj).containsKey(ASName.k_EF));
        }

        @Override
        public boolean visit(CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            LegalAttestationDispatch.this.incrementCounter(LegalBaseWarning.k_ExternalStreams);
            return true;
        }
    }

    class DispatchReferenceXObjectPDF16
    implements DispatchItem {
        DispatchReferenceXObjectPDF16() {
        }

        @Override
        public boolean verifyIdentity(ASName objKey, CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            CosContainer objContainer = null;
            ASName pdfSubType = null;
            if (!curStack.isEmpty()) {
                objContainer = ((Traverser.TraverserStackItem)curStack.get(curStack.size() - 1)).getContainer();
                pdfSubType = LegalAttestationDispatch.this.safeGetName((CosDictionary)objContainer, ASName.k_Subtype);
            }
            return pdfSubType == ASName.k_Form && ((CosDictionary)obj).containsKey(ASName.k_F) && !((CosDictionary)obj).getCosDictionary(ASName.k_F).containsKey(ASName.k_EF);
        }

        @Override
        public boolean visit(CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            LegalAttestationDispatch.this.incrementCounter(LegalAttestationWarning.k_ExternalRefXobjects);
            return true;
        }
    }

    class DispatchFont
    implements DispatchItem {
        DispatchFont() {
        }

        @Override
        public boolean verifyIdentity(ASName objKey, CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            return objKey == ASName.k_Type;
        }

        @Override
        public boolean visit(CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            ASName fontType;
            CosContainer fontObj = ((Traverser.TraverserStackItem)curStack.get(curStack.size() - 1)).getContainer();
            if (fontObj != null && ((fontType = LegalAttestationDispatch.this.safeGetName((CosDictionary)fontObj, ASName.k_Subtype)) == ASName.k_MMType1 || fontType == ASName.k_Type1 || fontType == ASName.k_CIDFontType0 || fontType == ASName.k_CIDFontType2 || fontType == ASName.k_TrueType)) {
                boolean embeddedFont = false;
                CosDictionary fdDictionary = LegalAttestationDispatch.this.safeGetDict((CosDictionary)fontObj, ASName.k_FontDescriptor);
                if (fdDictionary != null && (fdDictionary.containsKey(ASName.k_FontFile) || fdDictionary.containsKey(ASName.k_FontFile2) || fdDictionary.containsKey(ASName.k_FontFile3))) {
                    embeddedFont = true;
                }
                if (embeddedFont) {
                    if (fontType == ASName.k_TrueType) {
                        LegalAttestationDispatch.this.incrementCounter(LegalBaseWarning.k_TrueTypeFonts);
                    }
                } else {
                    LegalAttestationDispatch.this.incrementCounter(LegalBaseWarning.k_NonEmbeddedFonts);
                }
            }
            return true;
        }
    }

    private class DispatchOCMD
    implements DispatchItem {
        private DispatchOCMD() {
        }

        @Override
        public boolean verifyIdentity(ASName objKey, CosObject obj, ArrayList<?> curStack) {
            return true;
        }

        @Override
        public boolean visit(CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            OCMembership ocMembership;
            CosContainer ocmd = ((Traverser.TraverserStackItem)curStack.get(curStack.size() - 1)).getContainer();
            if (LegalAttestationDispatch.this.warnings.get(LegalBaseWarning.k_OptionalContent) == null && (ocMembership = OCMembership.getInstance(ocmd)).isDynamic()) {
                LegalAttestationDispatch.this.warnings.put(LegalBaseWarning.k_OptionalContent, 1);
            }
            return true;
        }
    }

    private class DispatchOCProperties
    implements DispatchItem {
        private DispatchOCProperties() {
        }

        @Override
        public boolean verifyIdentity(ASName objKey, CosObject obj, ArrayList<?> curStack) {
            return true;
        }

        @Override
        public boolean visit(CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            OCProperties ocProperies;
            if (LegalAttestationDispatch.this.warnings.get(LegalBaseWarning.k_OptionalContent) == null && (ocProperies = OCProperties.getInstance(obj)).hasDynamicOCConfig()) {
                LegalAttestationDispatch.this.warnings.put(LegalBaseWarning.k_OptionalContent, 1);
            }
            return true;
        }
    }

    private class DispatchInkList
    implements DispatchItem {
        private DispatchInkList() {
        }

        @Override
        public boolean verifyIdentity(ASName objKey, CosObject obj, ArrayList<?> curStack) {
            return true;
        }

        @Override
        public boolean visit(CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            int inkListArrayLength = ((CosArray)obj).size();
            int counter = 0;
            if (LegalAttestationDispatch.this.warnings.containsKey(LegalBaseWarning.k_Annotations)) {
                counter = (Integer)LegalAttestationDispatch.this.warnings.get(LegalBaseWarning.k_Annotations);
            }
            LegalAttestationDispatch.this.warnings.put(LegalBaseWarning.k_Annotations, counter += inkListArrayLength);
            return true;
        }
    }

    private class DispatchAnnotation
    implements DispatchItem {
        private DispatchAnnotation() {
        }

        @Override
        public boolean verifyIdentity(ASName objKey, CosObject obj, ArrayList<?> curStack) {
            return objKey == ASName.k_Subtype;
        }

        @Override
        public boolean visit(CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            CosContainer annotation = ((Traverser.TraverserStackItem)curStack.get(curStack.size() - 1)).getContainer();
            if (annotation != null) {
                LegalAttestationDispatch.this.incrementCounter(LegalBaseWarning.k_Annotations);
            }
            return true;
        }
    }

    private class DispatchExtGStatePDF16
    extends LegalBaseDispatch.DispatchExtGState
    implements DispatchItem {
        private DispatchExtGStatePDF16() {
            super(LegalAttestationDispatch.this);
        }

        @Override
        boolean visitExtGState(CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            if (obj instanceof CosDictionary) {
                boolean found = false;
                CosDictionary gsDict = (CosDictionary)obj;
                if (gsDict.containsKey(ASName.k_OP) && gsDict.getBoolean(ASName.k_OP).booleanValue()) {
                    LegalAttestationDispatch.this.incrementCounter(LegalAttestationWarning.k_DevDepGS_OP);
                    found = true;
                }
                if (!found && gsDict.containsKey(ASName.k_op) && gsDict.getBoolean(ASName.k_op).booleanValue()) {
                    LegalAttestationDispatch.this.incrementCounter(LegalAttestationWarning.k_DevDepGS_OP);
                }
                if (gsDict.containsKey(ASName.k_HT) && LegalAttestationDispatch.this.safeGetName(gsDict, ASName.k_HT) != LegalBaseDispatch.k_defaultKey) {
                    LegalAttestationDispatch.this.incrementCounter(LegalAttestationWarning.k_DevDepGS_HT);
                }
                found = false;
                if (gsDict.containsKey(ASName.k_TR2)) {
                    found = true;
                    if (LegalAttestationDispatch.this.safeGetName(gsDict, ASName.k_TR2) != LegalBaseDispatch.k_defaultKey) {
                        LegalAttestationDispatch.this.incrementCounter(LegalBaseWarning.k_DevDepGS_TR);
                    }
                }
                if (!found && gsDict.containsKey(ASName.k_TR) && LegalAttestationDispatch.this.safeGetName(gsDict, ASName.k_TR) != LegalBaseDispatch.k_identityKey) {
                    LegalAttestationDispatch.this.incrementCounter(LegalBaseWarning.k_DevDepGS_TR);
                }
                found = false;
                if (gsDict.containsKey(ASName.k_UCR2)) {
                    found = true;
                    if (LegalAttestationDispatch.this.safeGetName(gsDict, ASName.k_UCR2) != LegalBaseDispatch.k_defaultKey) {
                        LegalAttestationDispatch.this.incrementCounter(LegalAttestationWarning.k_DevDepGS_UCR);
                    }
                }
                if (!found && gsDict.containsKey(ASName.k_UCR)) {
                    LegalAttestationDispatch.this.incrementCounter(LegalAttestationWarning.k_DevDepGS_UCR);
                }
                found = false;
                if (gsDict.containsKey(ASName.k_BG2)) {
                    found = true;
                    if (LegalAttestationDispatch.this.safeGetName(gsDict, ASName.k_BG2) != LegalBaseDispatch.k_defaultKey) {
                        LegalAttestationDispatch.this.incrementCounter(LegalAttestationWarning.k_DevDepGS_BG);
                    }
                }
                if (!found && gsDict.containsKey(ASName.k_BG)) {
                    LegalAttestationDispatch.this.incrementCounter(LegalAttestationWarning.k_DevDepGS_BG);
                }
                if (gsDict.containsKey(ASName.k_FL)) {
                    LegalAttestationDispatch.this.incrementCounter(LegalBaseWarning.k_DevDepGS_FL);
                }
            }
            return true;
        }
    }
}

