/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.services.digsig.impl.DNUtils;
import com.adobe.internal.pdftoolkit.services.digsig.impl.RDNAttribute;
import com.rsa.certj.cert.AttributeValueAssertion;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.RDN;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.cert.extensions.GeneralName;
import com.rsa.certj.cert.extensions.GeneralNames;
import com.rsa.certj.cert.extensions.OtherName;
import com.rsa.certj.cert.extensions.SubjectAltName;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class DisplayDN {
    private static final String acroNameString = "name=";
    private static final String acroCommonNameString = "cn=";
    private static final String acroSurnameString = "sn=";
    private static final String acroGivenNameString = "givenName=";
    private static final String acroInitialsString = "initials=";
    private static final String acroGenerationQualifierString = "generationQualifier=";
    private static final String acroDNQualifierString = "dnQualifier=";
    private static final String acroCountryNameString = "c=";
    private static final String acroLocalityNameString = "l=";
    private static final String acroStateOrProvinceNameString = "st=";
    private static final String acroOrganizationNameString = "o=";
    private static final String acroOrganizationalUnitNameString = "ou=";
    private static final String acroTitleString = "title=";
    private static final String acroEmailString = "email=";
    private static final String acroSerialNumberString = "serialNumber=";
    private static final String acroDomainComponentString = "dc=";
    private static final String acroPseudonymString = "pseudonym=";
    private static final int attribCount = 17;
    private static final ArrayList<RDNAttribute> attribList = new ArrayList(17);
    private static String BLANK_STRING = "''";

    static String constructDisplayDN(X500Name x500Name) throws NameException, PDFInvalidParameterException {
        HashMap<Integer, String> rdnOIDtoValueMap = new HashMap<Integer, String>();
        DisplayDN.fetchDisplayAttributesFromX500Name(x500Name, rdnOIDtoValueMap);
        return DisplayDN.createDisplayDN(rdnOIDtoValueMap);
    }

    private static void fetchDisplayAttributesFromX500Name(X500Name x500Name, Map<Integer, String> standardAttributesMap) throws NameException {
        RDN rdnObj = null;
        AttributeValueAssertion avaObj = null;
        int rdnCount = x500Name.getRDNCount();
        for (int idx = 0; idx < rdnCount; ++idx) {
            rdnObj = x500Name.getRDN(idx);
            avaObj = rdnObj.getAttributeByIndex(0);
            standardAttributesMap.put(avaObj.getAttributeType(), avaObj.getStringAttributeNoEscapeSequences());
        }
    }

    private static void fetchAlternateDisplayAttributes(X509Certificate cert, Map<Integer, String> alternateAttributesMap) throws NameException, CertificateException, PDFInvalidParameterException {
        GeneralNames altNames;
        SubjectAltName subjectAltNameExtension;
        X509V3Extensions extensions = cert.getExtensions();
        if (extensions != null && (subjectAltNameExtension = (SubjectAltName)extensions.getExtensionByType(17)) != null && (altNames = subjectAltNameExtension.getGeneralNames()) != null) {
            for (int i = 0; i < altNames.getNameCount(); ++i) {
                GeneralName altName = altNames.getGeneralName(i);
                if (altName.getGeneralNameType() == 1) {
                    OtherName otherName = (OtherName)altName.getGeneralName();
                    AttributeValueAssertion otherNameAttribute = new AttributeValueAssertion(otherName.getTypeID(), otherName.getValue());
                    try {
                        alternateAttributesMap.put(otherNameAttribute.getAttributeType(), new String(otherName.getValue(), "UTF8"));
                        continue;
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new PDFInvalidParameterException("Error decoding other name attribute value", e);
                    }
                }
                if (altName.getGeneralNameType() != 5) continue;
                X500Name directoryName = (X500Name)altName.getGeneralName();
                DisplayDN.fetchDisplayAttributesFromX500Name(directoryName, alternateAttributesMap);
            }
        }
    }

    public static String constructDisplayDN(X509Certificate cert) throws PDFInvalidParameterException {
        HashMap<Integer, String> standardAttributes = new HashMap<Integer, String>();
        HashMap<Integer, String> alternateAttributes = new HashMap<Integer, String>();
        try {
            DisplayDN.fetchDisplayAttributesFromX500Name(cert.getSubjectName(), standardAttributes);
            DisplayDN.fetchAlternateDisplayAttributes(cert, alternateAttributes);
        }
        catch (NameException e) {
            throw new PDFInvalidParameterException(e);
        }
        catch (CertificateException e) {
            throw new PDFInvalidParameterException("Error parsing certificate", e);
        }
        HashMap<Integer, String> displayAttributes = new HashMap<Integer, String>();
        for (Map.Entry currentStandardAttribute : standardAttributes.entrySet()) {
            String alternateAttributeValue = (String)alternateAttributes.get(currentStandardAttribute.getKey());
            String currentStandardAttributeValue = (String)currentStandardAttribute.getValue();
            if (alternateAttributeValue == null || alternateAttributeValue.trim().length() == 0) {
                displayAttributes.put((Integer)currentStandardAttribute.getKey(), currentStandardAttributeValue);
                continue;
            }
            if (currentStandardAttributeValue == null || currentStandardAttributeValue.trim().length() == 0) {
                displayAttributes.put((Integer)currentStandardAttribute.getKey(), alternateAttributeValue);
                continue;
            }
            if (DNUtils.isLocalisedString(currentStandardAttributeValue)) {
                displayAttributes.put((Integer)currentStandardAttribute.getKey(), currentStandardAttributeValue);
                continue;
            }
            if (DNUtils.isLocalisedString(alternateAttributeValue)) {
                displayAttributes.put((Integer)currentStandardAttribute.getKey(), alternateAttributeValue);
                continue;
            }
            displayAttributes.put((Integer)currentStandardAttribute.getKey(), currentStandardAttributeValue);
        }
        return DisplayDN.createDisplayDN(displayAttributes);
    }

    private static String createDisplayDN(Map<Integer, String> rdnOIDtoValueMap) {
        Iterator<RDNAttribute> acrodnIter = attribList.iterator();
        RDNAttribute acrodnAttribute = null;
        StringBuilder displayDNBuffer = new StringBuilder();
        String attrName = null;
        String attrValue = null;
        while (acrodnIter.hasNext()) {
            acrodnAttribute = acrodnIter.next();
            if (!rdnOIDtoValueMap.containsKey(acrodnAttribute.attrIndex)) continue;
            acrodnAttribute.setAttrValue(rdnOIDtoValueMap.get(acrodnAttribute.attrIndex));
            attrName = acrodnAttribute.getAttribName();
            attrValue = acrodnAttribute.getAttrValue();
            if (attrValue.equals(BLANK_STRING)) continue;
            displayDNBuffer.append(attrName);
            displayDNBuffer.append(attrValue);
            displayDNBuffer.append(", ");
        }
        if (displayDNBuffer.toString().endsWith(", ")) {
            displayDNBuffer.deleteCharAt(displayDNBuffer.lastIndexOf(", "));
        }
        return displayDNBuffer.toString().trim();
    }

    static {
        attribList.add(new RDNAttribute(acroNameString, AttributeValueAssertion.NAME_OID, 17, ""));
        attribList.add(new RDNAttribute(acroCommonNameString, AttributeValueAssertion.COMMON_NAME_OID, 0, ""));
        attribList.add(new RDNAttribute(acroSurnameString, AttributeValueAssertion.SURNAME_OID, 12, ""));
        attribList.add(new RDNAttribute(acroGivenNameString, AttributeValueAssertion.GIVEN_NAME_OID, 13, ""));
        attribList.add(new RDNAttribute(acroInitialsString, AttributeValueAssertion.INITIALS_OID, 15, ""));
        attribList.add(new RDNAttribute(acroGenerationQualifierString, AttributeValueAssertion.GENERATION_QUALIFIER_OID, 16, ""));
        attribList.add(new RDNAttribute(acroDNQualifierString, AttributeValueAssertion.DN_QUALIFIER_OID, 18, ""));
        attribList.add(new RDNAttribute(acroCountryNameString, AttributeValueAssertion.COUNTRY_NAME_OID, 1, ""));
        attribList.add(new RDNAttribute(acroLocalityNameString, AttributeValueAssertion.LOCALITY_NAME_OID, 2, ""));
        attribList.add(new RDNAttribute(acroStateOrProvinceNameString, AttributeValueAssertion.STATE_NAME_OID, 3, ""));
        attribList.add(new RDNAttribute(acroOrganizationNameString, AttributeValueAssertion.ORGANIZATION_NAME_OID, 4, ""));
        attribList.add(new RDNAttribute(acroOrganizationalUnitNameString, AttributeValueAssertion.ORGANIZATIONAL_UNIT_NAME_OID, 5, ""));
        attribList.add(new RDNAttribute(acroTitleString, AttributeValueAssertion.TITLE_OID, 8, ""));
        attribList.add(new RDNAttribute(acroEmailString, AttributeValueAssertion.EMAIL_ADDRESS_OID, 7, ""));
        attribList.add(new RDNAttribute(acroSerialNumberString, AttributeValueAssertion.SERIAL_NUMBER_OID, 14, ""));
        attribList.add(new RDNAttribute(acroDomainComponentString, AttributeValueAssertion.DOMAIN_COMPONENT_OID, 19, ""));
        attribList.add(new RDNAttribute(acroPseudonymString, AttributeValueAssertion.PSEUDONYM_OID, 21, ""));
    }
}

