/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.docmodanalysis.impl;

import com.adobe.internal.pdftoolkit.core.cos.CosList;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosObjectID;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.services.digsig.docmodanalysis.impl.DocModList;
import java.util.Iterator;

public final class DocModMatch {
    private DocModList mModList = null;
    private CosList mMatchOkObjList = null;
    private CosList mMatchBadObjList = null;

    public DocModMatch(DocModList modList) {
        this.mModList = modList;
        this.mMatchOkObjList = new CosList();
        this.mMatchBadObjList = new CosList();
    }

    public boolean matchLists() {
        Iterator<Object> iter = this.mMatchBadObjList.iterator();
        while (iter.hasNext()) {
            CosObjectID id = (CosObjectID)iter.next();
            if (!this.mMatchOkObjList.containsIndex(id.getObjNum())) continue;
            iter.remove();
        }
        return this.mMatchBadObjList.isEmpty();
    }

    public void addOk(int objNum, CosObjectID id) {
        this.mMatchOkObjList.add(objNum, id);
    }

    public void addBad(int objNum, CosObjectID id) {
        this.mMatchBadObjList.add(objNum, id);
    }

    public void registerMatchedObjIDs(CosObject obj1, CosObject obj2) {
        if (obj1 == null || obj2 == null) {
            return;
        }
        int objNum = obj1.getObjNum();
        if (objNum == 0 || objNum != obj2.getObjNum()) {
            return;
        }
        int objGen = obj1.getObjGen();
        if (objGen != obj2.getObjGen()) {
            return;
        }
        this.addOk(objNum, new CosObjectID(objNum, objGen));
    }

    public void registerUnmatchedIfModified(CosObject obj1, CosObject obj2) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        if (obj1 == null) {
            return;
        }
        int objNum = obj1.getObjNum();
        if (this.mMatchBadObjList.containsIndex(objNum)) {
            return;
        }
        if (!this.mModList.isModified(objNum)) {
            return;
        }
        this.addBad(objNum, new CosObjectID(objNum, obj1.getObjGen()));
    }
}

