/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest;

import com.adobe.agl.text.RuleBasedCollator;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosContainer;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.filter.FlateOutputStream;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.core.util.QuickSort2;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCatalog;
import com.adobe.internal.pdftoolkit.pdf.document.PDFContents;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNameDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTree;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionFactory;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationFactory;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationIterator;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationList;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationPopup;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFField;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldSignature;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFNamedTemplates;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFRendition;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.page.PDFTemplate;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.ActionsDigester;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.AnnotationDigester;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.CatalogDigester;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.FieldAnnotDigester;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.LocaleAwareAnnotationID;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.ObjectDigestDebug;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.ObjectSelector;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.PageDigester;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.RenditionDigester;
import com.adobe.internal.pdftoolkit.services.digsig.impl.MessageDigestFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public class ObjectDigester {
    protected static final byte kNullType = 0;
    protected static final byte kIntegerType = 1;
    protected static final byte kRealType = 2;
    protected static final byte kBooleanType = 3;
    protected static final byte kNameType = 4;
    protected static final byte kStringType = 5;
    protected static final byte kDictionaryType = 6;
    protected static final byte kArrayType = 7;
    protected static final byte kStreamType = 8;
    protected static final boolean DIGEST_KEYS = true;
    protected static final boolean DONT_DIGEST_KEYS = false;
    protected static final boolean DIGEST_VALUES = true;
    protected static final boolean DONT_DIGEST_VALUES = false;
    protected static final boolean IGNORE_MISSING_ENTRIES = true;
    protected static final boolean DONT_IGNORE_MISSING_ENTRIES = false;
    protected PDFDocument pdfDoc;
    protected MessageDigestFactory digesterFactory;
    protected MessageDigest digester;
    protected HashMap digestCache;
    protected ObjectSelector selector;
    protected PDFFieldSignature sigField;
    protected byte[] dummyMarkerHash;
    private static final String rule = "&'-'<' '<'!'<'\"'<'#'<'$'<'%'<'&'<'('<')'<'*'<','<'.'<'/'<':'<';'<'?'<'@'<'['<'\\'<']'<'^'<'_'<'`'<'{'<'|'<'}'<'~'<'+'<'<'<'='<'>'&[before1]'-'<''";
    private static RuleBasedCollator baseCollator = null;

    public ObjectDigester(PDFDocument pdfDoc, MessageDigestFactory digesterFactory, HashMap digestCache, ObjectSelector selector, PDFFieldSignature sigField) throws PDFInvalidParameterException {
        this.pdfDoc = pdfDoc;
        this.digesterFactory = digesterFactory;
        this.digester = digesterFactory.newMessageDigest();
        this.digestCache = digestCache;
        this.selector = selector;
        this.sigField = sigField;
        this.dummyMarkerHash = new byte[this.digester.getDigestLength()];
    }

    public byte[] dummyDigest() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        MessageDigest dummyMD = this.digesterFactory.newMessageDigest();
        return dummyMD.digest();
    }

    private byte[] nullDigest() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        MessageDigest dummyMD = this.digesterFactory.newMessageDigest();
        byte[] sizedDigest = dummyMD.digest();
        for (int i = 0; i < sizedDigest.length; ++i) {
            sizedDigest[i] = 0;
        }
        return sizedDigest;
    }

    public byte[] digest() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        return this.digester.digest();
    }

    protected void update(byte b) {
        this.digester.update(b);
    }

    protected void update(byte[] bytes) {
        this.digester.update(bytes);
    }

    protected void update(byte[] bytes, int offset, int length) {
        this.digester.update(bytes, offset, length);
    }

    protected boolean isDigestCached(CosObject cosObj) {
        return this.digestCache.containsKey(cosObj);
    }

    protected byte[] getCachedDigest(CosObject cosObj) {
        return (byte[])this.digestCache.get(cosObj);
    }

    protected void cacheDigest(CosObject cosObj, byte[] digest) {
        this.digestCache.put(cosObj, digest);
    }

    public void update(CosObject cosObj) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        ++ObjectDigestDebug.indentLevel;
        if (cosObj == null) {
            this.updateValue(cosObj);
        } else if (cosObj instanceof CosContainer) {
            CosStream cosStream;
            SpecialHandling sh = null;
            byte[] localDigest = null;
            int objType = cosObj.getType();
            if (objType == 6) {
                sh = this.updateSpecial((CosDictionary)cosObj);
                if (sh.digest == null) {
                    if (!sh.shouldDigest) {
                        localDigest = this.nullDigest();
                        this.digester.update(localDigest);
                    }
                } else {
                    localDigest = sh.digest;
                }
            }
            if (sh == null || sh.shouldDigest) {
                if (!this.isDigestCached(cosObj)) {
                    this.cacheDigest(cosObj, this.dummyMarkerHash);
                    ObjectDigester localDigester = new ObjectDigester(this.pdfDoc, this.digesterFactory, this.digestCache, this.selector, this.sigField);
                    localDigester.updateValue(cosObj);
                    localDigest = localDigester.digest();
                    this.digester.update(localDigest);
                    this.cacheDigest(cosObj, localDigest);
                } else {
                    localDigest = this.getCachedDigest(cosObj);
                    this.digester.update(localDigest);
                }
            }
            if (objType == 7 && (cosStream = (CosStream)cosObj).containsKey(ASName.k_Resources)) {
                try {
                    this.update(cosStream.get(ASName.k_Resources));
                }
                catch (PDFCosParseException e) {
                    throw new PDFInvalidDocumentException("Invalid document encountered when computing object digest", e);
                }
                catch (PDFIOException e) {
                    throw new PDFIOException("IO exception encountered when computing object digest", e);
                }
                catch (PDFSecurityException e) {
                    throw new PDFSecurityException("Security exception encountered when computing object digest", e);
                }
            }
        } else {
            this.updateValue(cosObj);
        }
        --ObjectDigestDebug.indentLevel;
    }

    protected void updateTag(byte tag) {
        this.digester.update(tag);
    }

    protected void updateLength(int length) {
        this.digester.update(this.intToByteArray(length));
    }

    private void updateValue(CosObject cosObj) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (cosObj == null) {
            this.updateNull();
        } else {
            int cosType = cosObj.getType();
            if (cosType == 0) {
                this.updateNull();
            } else if (cosType == 1) {
                CosNumeric cosNum = (CosNumeric)cosObj;
                Number number = cosNum.numberValue();
                if (number instanceof Integer) {
                    this.update(number.intValue());
                } else if (number instanceof Long) {
                    this.update(number.longValue());
                } else if (number instanceof Double) {
                    this.updateFixed(cosNum.fixedValue());
                }
            } else if (cosType == 2) {
                this.update(cosObj.booleanValue());
            } else if (cosType == 3) {
                this.update(cosObj.nameValue());
            } else if (cosType == 4) {
                try {
                    this.update((CosString)cosObj);
                }
                catch (PDFSecurityException e) {
                    throw new PDFSecurityException("Security exception encountered when computing object digest", e);
                }
            } else if (cosType == 6) {
                this.update((CosDictionary)cosObj);
            } else if (cosType == 5) {
                this.update((CosArray)cosObj);
            } else if (cosType == 7) {
                CosStream cosStream = (CosStream)cosObj;
                this.update(cosStream);
            }
        }
    }

    private void updateNull() {
        this.updateTag((byte)0);
    }

    protected void update(int intValue) {
        this.updateTag((byte)1);
        this.digester.update(this.intToByteArray(intValue));
    }

    protected void update(long longValue) {
        this.updateTag((byte)1);
        this.digester.update(this.intToByteArray((int)longValue));
    }

    protected void updateFixed(int fixedValue) {
        this.updateTag((byte)2);
        int roundedValue = fixedValue + 32768 >> 16;
        this.digester.update(this.intToByteArray(roundedValue));
    }

    protected void update(boolean boolValue) {
        this.updateTag((byte)3);
        if (boolValue) {
            this.digester.update((byte)1);
        } else {
            this.digester.update((byte)0);
        }
    }

    protected void update(ASName name) {
        this.updateTag((byte)4);
        byte[] nameBytes = name.getBytes();
        this.updateLength(nameBytes.length);
        this.digester.update(nameBytes);
    }

    protected void update(ASString string) {
        this.updateTag((byte)5);
        int length = string.getBytes().length;
        this.updateLength(length);
        this.digester.update(string.getBytes());
    }

    protected void updateUnicodeString(String string) {
        this.updateTag((byte)5);
        try {
            byte[] strBytes = string.getBytes("UTF-16BE");
            int length = strBytes.length + 2;
            this.updateLength(length);
            this.digester.update((byte)-2);
            this.digester.update((byte)-1);
            this.digester.update(strBytes);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-16BE encoding is not supported", e);
        }
    }

    protected void updateString(byte[] strBytes) {
        this.updateTag((byte)5);
        int length = strBytes.length;
        this.updateLength(length);
        this.digester.update(strBytes);
    }

    protected void update(CosString string) throws PDFSecurityException {
        this.updateTag((byte)5);
        byte[] stringBytes = string.byteArrayValue();
        int length = stringBytes.length;
        this.updateLength(length);
        this.digester.update(stringBytes);
    }

    private SpecialHandling updateSpecial(CosDictionary dict) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        boolean callerShouldDigest = false;
        byte[] localDigest = null;
        if (this.dictIsCatalog(dict)) {
            if (this.selector.shouldDigestCatalog()) {
                PDFCatalog catalog = this.pdfDoc.requireCatalog();
                CatalogDigester localDigester = new CatalogDigester(this.pdfDoc, catalog, this.digesterFactory, this.digestCache, this.selector, this.sigField);
                localDigest = localDigester.digest();
                this.digester.update(localDigest);
            }
        } else if (this.dictIsPage(dict)) {
            if (this.selector.shouldDigestPage(true)) {
                PDFPage page = PDFPage.getInstance(dict);
                PageDigester localDigester = new PageDigester(this.pdfDoc, page, this.digesterFactory, this.digestCache, this.selector, this.sigField);
                localDigest = localDigester.digest();
                this.digester.update(localDigest);
            }
        } else if (this.dictIsTemplate(dict)) {
            if (this.selector.shouldDigestTemplate(true)) {
                PDFTemplate template = PDFTemplate.getInstance(dict);
                localDigest = this.digestTemplateContents(template);
                this.digester.update(localDigest);
            }
        } else if (this.dictIsAcroFormResource(dict)) {
            if (this.selector.shouldDigestFieldAnnotValue(null, dict == (this.sigField != null ? this.sigField.getCosDictionary() : null))) {
                localDigest = this.updateAcroFormResource(dict);
            }
        } else if (this.dictIsField(dict)) {
            PDFField field = PDFField.getInstance(dict);
            if (this.selector.shouldDigestFieldAnnot(field)) {
                PDFAnnotationWidget widget = PDFAnnotationWidget.getInstance(dict);
                FieldAnnotDigester localDigester = new FieldAnnotDigester(this.pdfDoc, widget, this.digesterFactory, this.digestCache, this.selector, this.sigField);
                localDigest = localDigester.digest();
                this.digester.update(localDigest);
            }
        } else if (this.dictIsAnnot(dict)) {
            PDFAnnotation annot;
            if (this.selector.shouldDigestNonFieldAnnot() && (annot = PDFAnnotationFactory.getInstance(dict)).getSubtype() != ASName.k_Popup) {
                AnnotationDigester localDigester = new AnnotationDigester(this.pdfDoc, annot, this.digesterFactory, this.digestCache, this.selector, this.sigField);
                localDigest = localDigester.digest();
                this.digester.update(localDigest);
            }
        } else if (this.dictIsAction(dict)) {
            PDFAction action = PDFActionFactory.getInstance(dict);
            ActionsDigester localDigester = new ActionsDigester(this.pdfDoc, action, this.digesterFactory, this.digestCache, this.selector, this.sigField);
            localDigest = localDigester.digest();
            this.digester.update(localDigest);
        } else if (this.dictIsRendObj(dict)) {
            PDFRendition rendition = PDFRendition.getInstance(dict);
            RenditionDigester localDigester = new RenditionDigester(this.pdfDoc, rendition, this.digesterFactory, this.digestCache, this.selector, this.sigField);
            localDigest = localDigester.digest();
            this.digester.update(localDigest);
        } else {
            callerShouldDigest = true;
        }
        return new SpecialHandling(callerShouldDigest, localDigest);
    }

    protected void update(CosDictionary dict) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.update(dict, null);
    }

    private void update(CosDictionary dict, ASName[] orderedKeys) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        ObjectDigester localDigester = new ObjectDigester(this.pdfDoc, this.digesterFactory, this.digestCache, this.selector, this.sigField);
        int entriesDigested = localDigester.updateKeysAndValues(dict, orderedKeys);
        byte[] localDigest = localDigester.digest();
        this.updateTag((byte)6);
        this.updateLength(entriesDigested);
        this.digester.update(localDigest);
    }

    protected int updateKeysOnly(CosDictionary dict, ASName[] orderedKeys) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        return this.updateDictionaryEntries(dict, orderedKeys, true, false, true);
    }

    protected int updateValuesOnly(CosDictionary dict, ASName[] orderedKeys) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        return this.updateDictionaryEntries(dict, orderedKeys, false, true, true);
    }

    protected int updateValuesOnly(CosDictionary dict, ASName[] orderedKeys, boolean ignoreMissingEntries) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        return this.updateDictionaryEntries(dict, orderedKeys, false, true, ignoreMissingEntries);
    }

    protected int updateKeysAndValues(CosDictionary dict, ASName[] orderedKeys) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        return this.updateDictionaryEntries(dict, orderedKeys, true, true, true);
    }

    protected int updateKeysAndValues(CosDictionary dict, ASName[] orderedKeys, boolean ignoreMissingEntries) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        return this.updateDictionaryEntries(dict, orderedKeys, true, true, ignoreMissingEntries);
    }

    private int updateDictionaryEntries(CosDictionary dict, ASName[] orderedKeys, boolean digestKeys, boolean digestValues, boolean ignoreMissingEntries) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        int entryCount = 0;
        if (orderedKeys != null) {
            for (int i = 0; i < orderedKeys.length; ++i) {
                ASName key = orderedKeys[i];
                if (!dict.containsKey(key) && ignoreMissingEntries) continue;
                if (digestKeys) {
                    this.update(key);
                }
                if (digestValues) {
                    this.update(dict.get(key));
                }
                ++entryCount;
            }
        } else {
            KeyComparatorAscending comparator = new KeyComparatorAscending();
            TreeSet<ASName> sortedKeys = new TreeSet<ASName>(comparator);
            sortedKeys.addAll(dict.getKeys());
            for (ASName key : sortedKeys) {
                if (digestKeys) {
                    this.update(key);
                }
                if (digestValues) {
                    this.update(dict.get(key));
                }
                ++entryCount;
            }
        }
        return entryCount;
    }

    private void update(ASName[] names) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        ObjectDigester parentDigester = new ObjectDigester(this.pdfDoc, this.digesterFactory, this.digestCache, this.selector, this.sigField);
        ObjectDigester localDigester = new ObjectDigester(this.pdfDoc, this.digesterFactory, this.digestCache, this.selector, this.sigField);
        for (int i = 0; i < names.length; ++i) {
            localDigester.update(names[i]);
        }
        byte[] localDigest = localDigester.digest();
        parentDigester.updateTag((byte)7);
        parentDigester.updateLength(names.length);
        parentDigester.update(localDigest);
        byte[] parentDigest = parentDigester.digest();
        this.digester.update(parentDigest);
    }

    private void update(CosArray array) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        ObjectDigester localDigester = new ObjectDigester(this.pdfDoc, this.digesterFactory, this.digestCache, this.selector, this.sigField);
        Iterator<CosObject> iter = array.iterator();
        while (iter.hasNext()) {
            localDigester.update(iter.next());
        }
        byte[] localDigest = localDigester.digest();
        this.updateTag((byte)7);
        this.updateLength(array.size());
        this.digester.update(localDigest);
    }

    private void update(CosStream stream) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        try {
            ASName[] keys = new ASName[]{ASName.k_DecodeParms, ASName.k_F, ASName.k_FDecodeParms, ASName.k_FFilter, ASName.k_Filter, ASName.k_Length};
            ObjectDigester localDigester = new ObjectDigester(this.pdfDoc, this.digesterFactory, this.digestCache, this.selector, this.sigField);
            int entriesDigested = localDigester.updateKeysAndValues(stream, keys);
            byte[] localDigest = localDigester.digest();
            this.updateTag((byte)8);
            this.updateLength(entriesDigested);
            this.digester.update(localDigest);
            InputByteStream byteStream = stream.getStreamEncoded();
            this.updateLength((int)byteStream.bytesAvailable());
            byte[] buffer = new byte[4096];
            int bytesRead = byteStream.read(buffer, 0, buffer.length);
            while (bytesRead > 0) {
                this.digester.update(buffer, 0, bytesRead);
                bytesRead = byteStream.read(buffer, 0, buffer.length);
            }
            byteStream.close();
            byteStream = null;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    private boolean dictIsCatalog(CosDictionary dict) throws PDFIOException, PDFSecurityException, PDFCosParseException {
        if (dict.containsKey(ASName.k_Type)) {
            CosObject typeObj = dict.get(ASName.k_Type);
            return typeObj.getType() == 3 && typeObj.nameValue() == ASName.k_Catalog;
        }
        return false;
    }

    private boolean dictIsPage(CosDictionary dict) throws PDFIOException, PDFSecurityException, PDFCosParseException {
        if (dict.containsKey(ASName.k_Type)) {
            CosObject typeObj = dict.get(ASName.k_Type);
            return typeObj.getType() == 3 && typeObj.nameValue() == ASName.k_Page;
        }
        return false;
    }

    private boolean dictIsTemplate(CosDictionary dict) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFCosParseException {
        CosDictionary catalog = dict.getDocument().getRoot();
        if (catalog.containsKey(ASName.k_Names)) {
            PDFNamedTemplates namedTemplates;
            PDFNameDictionary names = PDFNameDictionary.getInstance(catalog.get(ASName.k_Names));
            PDFNamedTemplates pDFNamedTemplates = namedTemplates = names == null ? null : names.getNamedTemplates();
            if (namedTemplates != null) {
                Iterator<PDFTree.Entry> iter = namedTemplates.iterator();
                while (iter.hasNext()) {
                    PDFTree.Entry ntEntry = iter.next();
                    PDFTemplate template = (PDFTemplate)ntEntry.getValue();
                    if (template.getCosDictionary() != dict) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean dictIsAcroFormResource(CosDictionary dict) throws PDFIOException, PDFSecurityException, PDFCosParseException {
        CosObject dr;
        CosDictionary acroFormDict;
        CosObject acroFormObj;
        boolean result = false;
        CosDictionary root = dict.getDocument().getRoot();
        if (root.containsKey(ASName.k_AcroForm) && (acroFormObj = root.get(ASName.k_AcroForm)).getType() == 6 && (acroFormDict = (CosDictionary)acroFormObj).containsKey(ASName.k_DR) && (dr = acroFormDict.get(ASName.k_DR)) == dict) {
            return true;
        }
        return result;
    }

    private boolean dictIsAnnot(CosDictionary dict) throws PDFIOException, PDFSecurityException, PDFCosParseException {
        ASName st;
        CosObject subtypeObj;
        if (dict.containsKey(ASName.k_Type)) {
            CosObject typeObj = dict.get(ASName.k_Type);
            return typeObj.getType() == 3 && ((CosName)typeObj).nameValue() == ASName.k_Annot;
        }
        return dict.containsKey(ASName.k_Subtype) && (subtypeObj = dict.get(ASName.k_Subtype)).getType() == 3 && ((st = ((CosName)subtypeObj).nameValue()) == ASName.k_Text || st == ASName.k_Link || st == ASName.k_FreeText || st == ASName.k_Line || st == ASName.k_Square || st == ASName.k_Circle || st == ASName.k_Highlight || st == ASName.k_Underline || st == ASName.k_Squiggly || st == ASName.k_StrikeOut || st == ASName.k_Stamp || st == ASName.k_Ink || st == ASName.k_Popup || st == ASName.k_FileAttachment || st == ASName.k_Sound || st == ASName.k_Movie || st == ASName.k_PrinterMark || st == ASName.k_TrapNet || st == ASName.create("Screen") || st == ASName.k_Polygon || st == ASName.k_PolyLine || st == ASName.k_Caret);
    }

    private boolean dictIsField(CosDictionary dict) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFCosParseException {
        boolean result = false;
        if ((!dict.containsKey(ASName.k_Type) || dict.get(ASName.k_Type).getType() == 3 && dict.getName(ASName.k_Type) == ASName.k_Annot) && dict.containsKey(ASName.k_Subtype)) {
            result = this.isValidFieldAnnot(dict);
        }
        return result;
    }

    private boolean dictIsRendObj(CosDictionary dict) throws PDFIOException, PDFSecurityException, PDFCosParseException {
        ASName name;
        CosObject value;
        return dict.containsKey(ASName.k_S) && (value = dict.get(ASName.k_S)).getType() == 3 && ((name = value.nameValue()) == ASName.create("MR") || name == ASName.create("SR"));
    }

    private boolean dictIsAction(CosDictionary dict) throws PDFIOException, PDFSecurityException, PDFCosParseException {
        ASName st;
        CosObject sObj;
        if (dict.containsKey(ASName.k_Type)) {
            CosObject typeObj = dict.get(ASName.k_Type);
            return typeObj.getType() == 3 && ((CosName)typeObj).nameValue() == ASName.k_Action;
        }
        return dict.containsKey(ASName.k_S) && (sObj = dict.get(ASName.k_S)).getType() == 3 && ((st = ((CosName)sObj).nameValue()) == ASName.k_Text || st == ASName.k_GoTo || st == ASName.k_GoToR || st == ASName.k_Launch || st == ASName.k_Thread || st == ASName.k_URI || st == ASName.k_Sound || st == ASName.k_Movie || st == ASName.k_Hide || st == ASName.k_Named || st == ASName.k_SubmitForm || st == ASName.k_ResetForm || st == ASName.k_ImportData || st == ASName.k_JavaScript || st == ASName.k_SetOCGState || st == ASName.k_Rendition);
    }

    private boolean isValidFieldAnnot(CosDictionary dict) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (dict.containsKey(ASName.k_Rect) && dict.containsKey(ASName.k_Widget) && dict.getName(ASName.k_Widget) == ASName.k_Widget) {
            PDFAnnotationWidget widget = PDFAnnotationWidget.getInstance(dict);
            widget.isField();
        }
        return false;
    }

    private byte[] intToByteArray(int intValue) {
        byte[] bytes = new byte[]{(byte)(intValue >>> 24), (byte)(intValue >>> 16), (byte)(intValue >>> 8), (byte)intValue};
        return bytes;
    }

    protected byte[] normalize(byte[] string) {
        int normLength = 0;
        byte[] tempBytes = new byte[string.length];
        for (int i = 0; i < string.length; ++i) {
            if (string[i] == 10 || string[i] == 13 || string[i] == 9 || string[i] == 11 || string[i] == 32) continue;
            tempBytes[normLength] = string[i];
            ++normLength;
        }
        byte[] normBytes = new byte[normLength];
        System.arraycopy(tempBytes, 0, normBytes, 0, normLength);
        return normBytes;
    }

    void update(PDFAnnotationList annots) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (annots != null) {
            int i;
            byte[] digest;
            PDFAnnotationIterator annotsIter = annots.iterator();
            HashMap<PDFAnnotation, byte[]> annotDigestMap = new HashMap<PDFAnnotation, byte[]>();
            while (annotsIter.hasNext()) {
                boolean isFieldAnnot;
                PDFAnnotation annot = annotsIter.next();
                boolean bl = isFieldAnnot = annot instanceof PDFAnnotationWidget && ((PDFAnnotationWidget)annot).isField();
                if (isFieldAnnot) {
                    if (!this.selector.shouldDigestFieldAnnot(((PDFAnnotationWidget)annot).getField())) continue;
                    FieldAnnotDigester fieldAnnotDigester = new FieldAnnotDigester(this.pdfDoc, (PDFAnnotationWidget)annot, this.digesterFactory, this.digestCache, this.selector, this.sigField);
                    digest = fieldAnnotDigester.digest();
                    annotDigestMap.put(annot, digest);
                    continue;
                }
                if (!this.selector.shouldDigestNonFieldAnnot() || annot instanceof PDFAnnotationPopup) continue;
                AnnotationDigester annotDigester = new AnnotationDigester(this.pdfDoc, annot, this.digesterFactory, this.digestCache, this.selector, this.sigField);
                digest = annotDigester.digest();
                annotDigestMap.put(annot, digest);
            }
            int length = annots.size();
            Object[] annotArray = new PDFAnnotation[length];
            for (i = 0; i < length; ++i) {
                annotArray[i] = annots.get(i);
            }
            QuickSort2.sort_acro6(annotArray, new AnnotComparator());
            for (i = 0; i < annotArray.length; ++i) {
                if (!annotDigestMap.containsKey(annotArray[i])) continue;
                digest = (byte[])annotDigestMap.get(annotArray[i]);
                this.update(digest);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] digestTemplateContents(PDFPage page) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        byte[] digest;
        byte[] deflatedStreamData = null;
        CosDictionary cosDict = page.getCosDictionary();
        if (!this.isDigestCached(cosDict)) {
            Object inStm;
            PDFContents contents = page.getContents();
            PDFContents.PDFContentStreamsIterator stmIter = contents.listIterator();
            ByteArrayOutputStream outStm = new ByteArrayOutputStream();
            FlateOutputStream flateStm = new FlateOutputStream(outStm);
            byte[] buffer = new byte[4096];
            try {
                flateStm.write(113);
                flateStm.write(10);
                while (stmIter.hasNext()) {
                    inStm = null;
                    boolean bytesWritten = false;
                    int lastByteWritten = 0;
                    try {
                        int length;
                        inStm = stmIter.next();
                        while ((length = inStm.read(buffer)) > 0) {
                            flateStm.write(buffer, 0, length);
                            lastByteWritten = buffer[length - 1];
                            bytesWritten = true;
                        }
                    }
                    finally {
                        if (inStm != null) {
                            inStm.close();
                        }
                    }
                    if (!bytesWritten || lastByteWritten == 0 || lastByteWritten == 10) continue;
                    flateStm.write(10);
                }
                flateStm.write(81);
                flateStm.write(10);
                flateStm.flush();
                flateStm.close();
                outStm.flush();
                deflatedStreamData = outStm.toByteArray();
                outStm.close();
            }
            catch (IOException e) {
                throw new PDFInvalidDocumentException(e);
            }
            inStm = new ByteArrayInputStream(deflatedStreamData);
            byte[] streamDigest = this.updateTemplateContentStream((InputStream)inStm, deflatedStreamData.length);
            ObjectDigester localDigester = new ObjectDigester(this.pdfDoc, this.digesterFactory, this.digestCache, this.selector, this.sigField);
            localDigester.update(streamDigest);
            digest = localDigester.digest();
            this.cacheDigest(cosDict, digest);
        } else {
            digest = this.getCachedDigest(cosDict);
        }
        return digest;
    }

    private byte[] updateTemplateContentStream(InputStream stream, int length) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        ASName[] filters = new ASName[]{ASName.k_FlateDecode};
        byte[] parentDigest = null;
        ObjectDigester parentDigester = new ObjectDigester(this.pdfDoc, this.digesterFactory, this.digestCache, this.selector, this.sigField);
        ObjectDigester localDigester = new ObjectDigester(this.pdfDoc, this.digesterFactory, this.digestCache, this.selector, this.sigField);
        localDigester.update(ASName.k_Filter);
        localDigester.update(filters);
        localDigester.update(ASName.k_Length);
        localDigester.update(length);
        byte[] localDigest = localDigester.digest();
        parentDigester.updateTag((byte)8);
        parentDigester.updateLength(2);
        parentDigester.update(localDigest);
        try {
            parentDigester.updateLength(length);
            byte[] buffer = new byte[4096];
            int bytesRead = stream.read(buffer, 0, buffer.length);
            while (bytesRead > 0) {
                parentDigester.update(buffer, 0, bytesRead);
                bytesRead = stream.read(buffer, 0, buffer.length);
            }
            parentDigest = parentDigester.digest();
        }
        catch (IOException e) {
            throw new PDFInvalidDocumentException(e);
        }
        return parentDigest;
    }

    private byte[] updateAcroFormResource(CosDictionary afrDict) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        byte[] localDigest;
        if (!this.isDigestCached(afrDict)) {
            this.cacheDigest(afrDict, this.dummyMarkerHash);
            ObjectDigester localDigester = new ObjectDigester(this.pdfDoc, this.digesterFactory, this.digestCache, this.selector, this.sigField);
            localDigester.updateKeysAndValues(afrDict, null);
            localDigest = localDigester.digest();
            this.digester.update(localDigest);
            this.cacheDigest(afrDict, localDigest);
        } else {
            localDigest = this.getCachedDigest(afrDict);
            this.digester.update(localDigest);
        }
        return localDigest;
    }

    private static class KeyComparatorAscending
    implements Comparator {
        private KeyComparatorAscending() {
        }

        public int compare(Object o1, Object o2) {
            ASName key1 = (ASName)o1;
            ASName key2 = (ASName)o2;
            return key1.compareTo(key2);
        }
    }

    public static class AnnotComparator
    implements Comparator {
        private Map cacheMap = new HashMap();
        private RuleBasedCollator collator;

        public AnnotComparator() {
            try {
                if (baseCollator == null) {
                    try {
                        baseCollator = new RuleBasedCollator(ObjectDigester.rule);
                        baseCollator.setAlternateHandlingShifted(true);
                        baseCollator.setStrength(3);
                        baseCollator.setVariableTop(baseCollator.getCollationElementIterator("-").next());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.collator = (RuleBasedCollator)baseCollator.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }

        public int compare(Object o1, Object o2) {
            LocaleAwareAnnotationID id1 = null;
            LocaleAwareAnnotationID id2 = null;
            try {
                id1 = LocaleAwareAnnotationID.getID((PDFAnnotation)o1, this.cacheMap, this.collator);
                id2 = LocaleAwareAnnotationID.getID((PDFAnnotation)o2, this.cacheMap, this.collator);
            }
            catch (PDFInvalidDocumentException e) {
                throw new RuntimeException("Problem enountered trying to sort annotations.", e);
            }
            catch (PDFIOException e) {
                throw new RuntimeException("Problem enountered trying to sort annotations.", e);
            }
            catch (PDFSecurityException e) {
                throw new RuntimeException("Problem enountered trying to sort annotations.", e);
            }
            if (id1 == null && id2 == null) {
                return 0;
            }
            if (id1 == null) {
                return -1;
            }
            if (id2 == null) {
                return 1;
            }
            return id1.compareTo(id2);
        }
    }

    private static class SpecialHandling {
        boolean shouldDigest;
        byte[] digest;

        SpecialHandling(boolean shouldDigest, byte[] digest) {
            this.shouldDigest = shouldDigest;
            this.digest = digest;
        }
    }
}

