/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl;

import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignature;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.SignatureHandlerPPKLite;
import com.adobe.internal.pdftoolkit.services.digsig.spi.RevocationInfoProvider;
import com.adobe.internal.pdftoolkit.services.digsig.spi.TimeStampProvider;

public final class SignatureHandlerPKCS7
extends SignatureHandlerPPKLite {
    static final String subFilterPKCS7Sha1 = PDFSignature.k_adbe_pkcs7_sha1.asString(true);
    static final String subFilterPKCS7Detached = PDFSignature.k_adbe_pkcs7_detached.asString(true);
    static final String subFilterCADESDetached = PDFSignature.k_ETSI_CADES_detached.asString(true);
    static final String[] subFilters = new String[]{subFilterPKCS7Sha1, subFilterPKCS7Detached, subFilterCADESDetached};
    static final String[] byteRangeDigestMethodsSha1 = new String[]{PDFSignature.k_SHA1.asString(true)};
    static final String[] byteRangeDigestMethodsDetached = new String[]{PDFSignature.k_MD5.asString(true), PDFSignature.k_SHA1.asString(true), PDFSignature.k_SHA256.asString(true), PDFSignature.k_SHA384.asString(true), PDFSignature.k_SHA512.asString(true), PDFSignature.k_RIPEMD160.asString(true)};
    static final String[] transformDigestMethods = new String[]{PDFSignature.k_MD5.asString(true), PDFSignature.k_SHA1.asString(true)};
    static final String[] cipherAlgorithms = new String[]{"RSA"};
    static final String[] signatureAlgorithms = new String[]{"RSA", "DSA", "EC"};

    @Override
    public String getFilterName() {
        return filter;
    }

    @Override
    public String[] getSubFilterNames() {
        return subFilters;
    }

    @Override
    public String getDefaultSubFilterName() {
        return subFilterPKCS7Detached;
    }

    @Override
    public String[] getSupportedDigestMethods(String subFilter) {
        if (subFilter.equals(subFilterPKCS7Sha1)) {
            return byteRangeDigestMethodsSha1;
        }
        if (subFilter.equals(subFilterPKCS7Detached) || subFilter.equals(subFilterCADESDetached)) {
            return byteRangeDigestMethodsDetached;
        }
        return null;
    }

    @Override
    public String getDefaultDigestMethod() {
        return PDFSignature.k_SHA1.asString(true);
    }

    @Override
    public boolean isDigestMethodSupported(String subFilter, String digestMethod) {
        if (subFilter.equals(subFilterPKCS7Sha1)) {
            return this.ArrayContainsStringIgnoreCase(byteRangeDigestMethodsSha1, digestMethod);
        }
        if (subFilter.equals(subFilterPKCS7Detached) || subFilter.equals(subFilterCADESDetached)) {
            return this.ArrayContainsStringIgnoreCase(byteRangeDigestMethodsDetached, digestMethod);
        }
        return false;
    }

    @Override
    public String[] getSupportedSignatureAlgorithms(String subFilter) {
        return signatureAlgorithms;
    }

    @Override
    public boolean isSignatureAlgorithmSupported(String subFilter, String sigAlgorithm) {
        return this.ArrayContainsStringIgnoreCase(signatureAlgorithms, sigAlgorithm);
    }

    @Override
    public String[] getSupportedTransformDigestMethods(String subFilter) {
        return transformDigestMethods;
    }

    @Override
    public String getDefaultTransformDigestMethod() {
        return PDFSignature.k_MD5.asString(true);
    }

    @Override
    public String[] getEncryptionSupported(String subFilter) {
        return cipherAlgorithms;
    }

    @Override
    public boolean usesCertField() {
        return false;
    }

    @Override
    public boolean supportsDocMDP() {
        return true;
    }

    @Override
    public boolean supportsFieldMDP() {
        return true;
    }

    @Override
    public boolean supportsUR() {
        return true;
    }

    @Override
    public boolean supportsEmbeddingRevocationInfo(String subFilter) {
        return true;
    }

    @Override
    public boolean supportsTimeStamping(String subFilter) {
        return true;
    }

    @Override
    public void setTimeStampProvider(TimeStampProvider timestampProvider) {
        this.tsProvider = timestampProvider;
    }

    @Override
    public TimeStampProvider getTimeStampProvider() {
        return this.tsProvider;
    }

    @Override
    public void setRevocationInfoProvider(RevocationInfoProvider revocationProvider) {
        this.revInfoProvider = revocationProvider;
    }

    @Override
    public RevocationInfoProvider getRevocationInfoProvider() {
        return this.revInfoProvider;
    }
}

