/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl;

import java.math.BigInteger;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.interfaces.RSAPublicKey;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.cms.CMSPatchKit;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;

public class SignerInformationUtility {
    private static final Map<ASN1ObjectIdentifier, AlgorithmIdentifier> signatureAlgorithms = new HashMap<ASN1ObjectIdentifier, AlgorithmIdentifier>();

    public static SignerInformation patchRsaDigestSignature(PublicKey key, SignerInformation signerInformation) throws SignatureException {
        if (!(key instanceof RSAPublicKey)) {
            throw new IllegalArgumentException("patching only works for RSA PKCS1.5 signatures");
        }
        BigInteger sigInt = new BigInteger(1, signerInformation.getSignature());
        byte[] encString = BigIntegers.asUnsignedByteArray((BigInteger)(sigInt = sigInt.modPow(((RSAPublicKey)key).getPublicExponent(), ((RSAPublicKey)key).getModulus())));
        boolean isValid = encString[0] == 1;
        int index = 1;
        while (index != encString.length && encString[index] != 0) {
            isValid &= (encString[index++] & 0xFF) == 255;
        }
        if (isValid &= index < encString.length) {
            DigestInfo digInfo;
            try {
                digInfo = DigestInfo.getInstance((Object)Arrays.copyOfRange((byte[])encString, (int)(index + 1), (int)encString.length));
            }
            catch (IllegalArgumentException e) {
                throw new SignatureException("parsing error: " + e.getMessage(), e);
            }
            ASN1ObjectIdentifier digestAlg = digInfo.getAlgorithmId().getAlgorithm();
            if (signatureAlgorithms.containsKey(digestAlg)) {
                return CMSPatchKit.createWithSignatureAlgorithm((SignerInformation)signerInformation, (AlgorithmIdentifier)signatureAlgorithms.get(digInfo.getAlgorithmId().getAlgorithm()));
            }
            throw new SignatureException("unknown digest algorithm in signature: " + digestAlg);
        }
        throw new SignatureException("signature does not appear to be in PKCS#1.5 format");
    }

    static {
        signatureAlgorithms.put(OIWObjectIdentifiers.idSHA1, new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1WithRSAEncryption, (ASN1Encodable)DERNull.INSTANCE));
        signatureAlgorithms.put(NISTObjectIdentifiers.id_sha224, new AlgorithmIdentifier(PKCSObjectIdentifiers.sha224WithRSAEncryption, (ASN1Encodable)DERNull.INSTANCE));
        signatureAlgorithms.put(NISTObjectIdentifiers.id_sha256, new AlgorithmIdentifier(PKCSObjectIdentifiers.sha256WithRSAEncryption, (ASN1Encodable)DERNull.INSTANCE));
        signatureAlgorithms.put(NISTObjectIdentifiers.id_sha384, new AlgorithmIdentifier(PKCSObjectIdentifiers.sha384WithRSAEncryption, (ASN1Encodable)DERNull.INSTANCE));
        signatureAlgorithms.put(NISTObjectIdentifiers.id_sha512, new AlgorithmIdentifier(PKCSObjectIdentifiers.sha512WithRSAEncryption, (ASN1Encodable)DERNull.INSTANCE));
        signatureAlgorithms.put(NISTObjectIdentifiers.id_sha512_224, new AlgorithmIdentifier(PKCSObjectIdentifiers.sha512_224WithRSAEncryption, (ASN1Encodable)DERNull.INSTANCE));
        signatureAlgorithms.put(NISTObjectIdentifiers.id_sha512_256, new AlgorithmIdentifier(PKCSObjectIdentifiers.sha512_256WithRSAEncryption, (ASN1Encodable)DERNull.INSTANCE));
        signatureAlgorithms.put(NISTObjectIdentifiers.id_sha3_224, new AlgorithmIdentifier(NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_224, (ASN1Encodable)DERNull.INSTANCE));
        signatureAlgorithms.put(NISTObjectIdentifiers.id_sha3_256, new AlgorithmIdentifier(NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_256, (ASN1Encodable)DERNull.INSTANCE));
        signatureAlgorithms.put(NISTObjectIdentifiers.id_sha3_384, new AlgorithmIdentifier(NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_384, (ASN1Encodable)DERNull.INSTANCE));
        signatureAlgorithms.put(NISTObjectIdentifiers.id_sha3_512, new AlgorithmIdentifier(NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_512, (ASN1Encodable)DERNull.INSTANCE));
    }
}

