/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSignatureException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.BCUtilities;
import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OIDList;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.asn1.SetContainer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertStore;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.cert.jcajce.JcaCertStoreBuilder;
import org.bouncycastle.cert.selector.X509CertificateHolderSelector;
import org.bouncycastle.cert.selector.jcajce.JcaX509CertSelectorConverter;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSABlindedEngine;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

public final class RSAVerifyUtils {
    private static final boolean debug = false;

    public static boolean verify(byte[] signedDataPacket, InputStream inputStream) throws PDFSignatureException {
        return RSAVerifyUtils.verify(signedDataPacket, 0, signedDataPacket.length, inputStream);
    }

    public static byte[] getSignatureBytes(byte[] pkcs1Bytes) throws PDFInvalidDocumentException, PDFUnableToCompleteOperationException {
        byte[] sigBytes = null;
        try {
            OctetStringContainer octetContainer = new OctetStringContainer(0);
            ASN1Container[] asn1Def = new ASN1Container[]{octetContainer};
            ASN1.berDecode((byte[])pkcs1Bytes, (int)0, (ASN1Container[])asn1Def);
            if (!octetContainer.dataPresent) {
                throw new PDFInvalidDocumentException("Signature did not contain valid a PKCS#1 packet.");
            }
            sigBytes = new byte[octetContainer.dataLen];
            System.arraycopy(octetContainer.data, octetContainer.dataOffset, sigBytes, 0, octetContainer.dataLen);
        }
        catch (ASN_Exception e) {
            throw new PDFUnableToCompleteOperationException("Could not decode the pkcs#1 object.", e);
        }
        return sigBytes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean verify(byte[] signatureBytes, int offset, int length, InputStream dataStream) throws PDFSignatureException {
        boolean verificationResult = false;
        InputStream signatureStream = null;
        try {
            SignerId signer_id;
            X509CertificateHolderSelector sel;
            JcaX509CertSelectorConverter conv;
            X509CertSelector signerConstraints;
            X509Certificate cert;
            PublicKey key;
            SignerInformation signer;
            signatureStream = new ByteArrayInputStream(signatureBytes, 0, signatureBytes.length);
            CMSSignedData signedData = new CMSSignedData(signatureStream);
            byte[] signedContent = null;
            if (signedData.getSignedContent() != null) {
                signedContent = (byte[])signedData.getSignedContent().getContent();
            }
            boolean validContent = true;
            if (signedContent != null) {
                if (dataStream == null) {
                    dataStream = new ByteArrayInputStream(signedContent);
                } else {
                    int bytes;
                    byte[] buf = new byte[1024];
                    int contentOffset = 0;
                    while ((bytes = dataStream.read(buf)) != -1) {
                        for (int i = 0; i < bytes && i < signedContent.length - contentOffset; ++i) {
                            if (buf[i] == signedContent[contentOffset + i]) continue;
                            validContent = false;
                            break;
                        }
                        if (!validContent) break;
                        contentOffset += bytes;
                    }
                    validContent &= contentOffset == signedContent.length;
                    if (dataStream.markSupported()) {
                        dataStream.reset();
                    }
                }
            }
            JcaCertStoreBuilder storeBuilder = new JcaCertStoreBuilder();
            storeBuilder.addCertificates(signedData.getCertificates());
            storeBuilder.addCRLs(signedData.getCRLs());
            CertStore certStore = storeBuilder.build();
            SignerInformationStore signers = signedData.getSignerInfos();
            Iterator it = signers.getSigners().iterator();
            while (it.hasNext() && !(verificationResult = RSAVerifyUtils.verify(signer = (SignerInformation)it.next(), dataStream, signedData, key = (cert = (X509Certificate)certStore.getCertificates(signerConstraints = (conv = new JcaX509CertSelectorConverter()).getCertSelector(sel = new X509CertificateHolderSelector((signer_id = signer.getSID()).getIssuer(), signer_id.getSerialNumber()))).iterator().next()).getPublicKey()))) {
            }
            int actualSigSize = signedData.getEncoded().length;
            if (actualSigSize > signatureBytes.length) {
                boolean bl = false;
                return bl;
            }
            if (RSAVerifyUtils.hasPaddingBeenTampered(signatureBytes, actualSigSize)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = verificationResult;
            return bl;
        }
        catch (ASN_Exception e) {
            throw new PDFSignatureException("Error verifying the signature Bytes.", e);
        }
        catch (GeneralSecurityException e) {
            throw new PDFSignatureException("Error verifying the signature Bytes.", e);
        }
        catch (GSSException e) {
            throw new PDFSignatureException("Error verifying the signature Bytes.", e);
        }
        catch (CMSException e) {
            throw new PDFSignatureException("Error verifying the signature Bytes.", e);
        }
        catch (IOException e) {
            throw new PDFSignatureException("Error verifying the signature Bytes.", e);
        }
        finally {
            if (signatureStream != null) {
                try {
                    signatureStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static boolean verify(SignerInformation signer, InputStream datastream, CMSSignedData signedData, PublicKey key) throws ASN_Exception, GeneralSecurityException, IOException, GSSException {
        ASN1InputStream inputStream;
        ASN1Sequence ecdsa_seq;
        String digestAlgName = null;
        byte[] oidBytes = RSAVerifyUtils.getOIDBytesFromString(signer.getDigestAlgOID());
        digestAlgName = OIDList.getTrans((byte[])oidBytes, (int)0, (int)oidBytes.length, (int)11);
        if (digestAlgName == null) {
            digestAlgName = OIDList.getTrans((byte[])oidBytes, (int)0, (int)oidBytes.length, (int)1);
        }
        if (digestAlgName != null) {
            digestAlgName = digestAlgName.split("/")[0];
        }
        if (digestAlgName == null) {
            return false;
        }
        oidBytes = RSAVerifyUtils.getOIDBytesFromString(signer.getEncryptionAlgOID());
        Map<String, byte[]> authAttr = RSAVerifyUtils.getAttributes(signer.getSignedAttributes());
        String keyAlgoName = key.getAlgorithm();
        if (keyAlgoName.equalsIgnoreCase("EC")) {
            keyAlgoName = "ECDSA";
        }
        String sigAlgName = digestAlgName + "with" + keyAlgoName;
        Signature verifier = Signature.getInstance(sigAlgName, BCUtilities.provider);
        verifier.initVerify(key);
        boolean isVerified = false;
        byte[] buf = new byte[32768];
        int bytes = 0;
        if (authAttr == null) {
            while ((bytes = datastream.read(buf)) != -1) {
                verifier.update(buf, 0, bytes);
            }
        } else {
            MessageDigest digester = MessageDigest.getInstance(digestAlgName, BCUtilities.provider);
            while ((bytes = datastream.read(buf)) != -1) {
                digester.update(buf, 0, bytes);
            }
            byte[] digestOverData = digester.digest();
            OctetStringContainer asn1String = new OctetStringContainer(0);
            ASN1.berDecode((byte[])authAttr.get(CMSAttributes.messageDigest.getId()), (int)0, (ASN1Container[])new ASN1Container[]{new SetContainer(0), asn1String, new EndContainer()});
            byte[] digestAuthAttrBytes = new byte[asn1String.dataLen];
            System.arraycopy(asn1String.data, asn1String.dataOffset, digestAuthAttrBytes, 0, asn1String.dataLen);
            if (!Arrays.equals(digestOverData, digestAuthAttrBytes)) {
                return false;
            }
            EncodedContainer oidCont = new EncodedContainer(1536);
            ASN1.berDecode((byte[])authAttr.get(CMSAttributes.contentType.getId()), (int)0, (ASN1Container[])new ASN1Container[]{new SetContainer(0), oidCont, new EndContainer()});
            byte[] oidDER = new byte[oidCont.dataLen];
            System.arraycopy(oidCont.data, oidCont.dataOffset, oidDER, 0, oidDER.length);
            Oid contentTypeOID = new Oid(oidDER);
            if (!contentTypeOID.toString().equalsIgnoreCase(signedData.getSignedContentTypeOID())) {
                return false;
            }
            verifier.update(signer.getEncodedSignedAttributes());
        }
        byte[] signature = signer.getSignature();
        if (keyAlgoName.equals("ECDSA") && (ecdsa_seq = ASN1Sequence.getInstance((Object)(inputStream = new ASN1InputStream(signature)).readObject())).size() == 2 && ecdsa_seq.getObjectAt(0) instanceof ASN1Integer && ecdsa_seq.getObjectAt(1) instanceof ASN1Integer) {
            ASN1EncodableVector v = new ASN1EncodableVector();
            ASN1Integer r = ASN1Integer.getInstance((Object)ecdsa_seq.getObjectAt(0));
            r = new ASN1Integer(r.getPositiveValue());
            v.add((ASN1Encodable)r);
            ASN1Integer s = ASN1Integer.getInstance((Object)ecdsa_seq.getObjectAt(1));
            s = new ASN1Integer(s.getPositiveValue());
            v.add((ASN1Encodable)s);
            signature = new DERSequence(v).getEncoded();
        }
        if (isVerified = verifier.verify(signature)) {
            isVerified = RSAVerifyUtils.checkHashPadding(key, signature);
        }
        return isVerified;
    }

    private static byte[] getOIDBytesFromString(String oidString) {
        try {
            Oid oid = new Oid(oidString);
            if (oid != null) {
                OIDContainer asn1Oid = new OIDContainer(0);
                ASN1Container[] asn1Cont = new ASN1Container[]{asn1Oid};
                ASN1.berDecode((byte[])oid.getDER(), (int)0, (ASN1Container[])asn1Cont);
                byte[] oidBytes = new byte[asn1Oid.dataLen];
                System.arraycopy(asn1Oid.data, asn1Oid.dataOffset, oidBytes, 0, asn1Oid.dataLen);
                return oidBytes;
            }
        }
        catch (GSSException gSSException) {
        }
        catch (ASN_Exception aSN_Exception) {
            // empty catch block
        }
        return null;
    }

    private static Map<String, byte[]> getAttributes(AttributeTable table) {
        Hashtable signedAttrs;
        if (table != null && (signedAttrs = table.toHashtable()) != null) {
            HashMap<String, byte[]> map = new HashMap<String, byte[]>();
            Enumeration en = signedAttrs.keys();
            while (en.hasMoreElements()) {
                ASN1ObjectIdentifier key = (ASN1ObjectIdentifier)en.nextElement();
                try {
                    Vector vAttr;
                    Object attr = signedAttrs.get(key);
                    if (attr instanceof Attribute) {
                        map.put(key.getId(), ((Attribute)attr).getAttrValues().toASN1Primitive().getEncoded("DER"));
                        continue;
                    }
                    if (!(attr instanceof Vector) || (vAttr = (Vector)attr).size() <= 0 || !(vAttr.get(0) instanceof Attribute)) continue;
                    map.put(key.getId(), ((Attribute)vAttr.get(0)).getAttrValues().toASN1Primitive().getEncoded("DER"));
                }
                catch (IOException iOException) {}
            }
            return map;
        }
        return null;
    }

    private static boolean checkHashPadding(PublicKey key, byte[] signature) {
        if (key.getAlgorithm().equalsIgnoreCase("RSA")) {
            try {
                PKCS1Encoding cipher = new PKCS1Encoding((AsymmetricBlockCipher)new RSABlindedEngine());
                cipher.init(false, (CipherParameters)new RSAKeyParameters(false, ((RSAPublicKey)key).getModulus(), ((RSAPublicKey)key).getPublicExponent()));
                byte[] hashDER = cipher.processBlock(signature, 0, signature.length);
                OctetStringContainer hashCont = new OctetStringContainer(0);
                ASN1.berDecode((byte[])hashDER, (int)0, (ASN1Container[])new ASN1Container[]{new SequenceContainer(0), new EncodedContainer(12288), hashCont, new EndContainer()});
                for (int i = hashCont.dataOffset + hashCont.dataLen; i < hashDER.length; ++i) {
                    if (hashDER[i] == 0) continue;
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    private static Map<String, String> parseSignatureAlgo(String alg) {
        String[] rsaAlgos = alg.split("/");
        int jceBreaker = alg.indexOf("with");
        HashMap<String, String> output = new HashMap<String, String>();
        if (rsaAlgos.length >= 2) {
            output.put("digest", rsaAlgos[0]);
            output.put("encrypt", rsaAlgos[1]);
            if (rsaAlgos.length >= 3) {
                output.put("pad", rsaAlgos[2]);
            }
        }
        if (jceBreaker > 0) {
            output.put("digest", alg.substring(0, jceBreaker));
            output.put("encrypt", alg.substring(jceBreaker + 4));
        }
        return output;
    }

    private static boolean hasPaddingBeenTampered(byte[] contents, int actualDataSize) {
        if (contents.length > actualDataSize) {
            for (int i = actualDataSize; i < contents.length; ++i) {
                if (contents[i] == 0) continue;
                return true;
            }
        }
        return false;
    }
}

