/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSignatureException;
import com.adobe.internal.pdftoolkit.core.securityframework.CryptoMode;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.content.InstructionFactory;
import com.adobe.internal.pdftoolkit.pdf.content.MarkedContentOperands;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentModifier;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentWriter;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ModifiableContent;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFBuildProp;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFDocMDPPermissions;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFFieldAction;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFFieldLock;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFFilterBuildData;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignature;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignatureReference;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignatureReferenceList;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignatureSubFilter;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFTransformParametersFieldMDP;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFTransformParametersUR;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFURAnnots;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFURDocument;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFUREmbeddedFiles;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFURForm;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFURSignature;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectMap;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFField;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldList;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldNode;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldSignature;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldUtils;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureContentArray;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureElement;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureUtils;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureFieldInterface;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureFieldPDF;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureManager;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureOptions;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureValidationStatus;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.CryptoContext;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.SignatureServiceProvider;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.CertJNonFIPSProvider;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.SignatureHandler;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.SignatureHandlerFactory;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.XFADigSigWorkFlow;
import com.adobe.internal.pdftoolkit.services.digsig.impl.SigningUtils;
import com.adobe.internal.pdftoolkit.services.xfa.XFAService;
import com.adobe.internal.pdftoolkit.services.xfa.form.FieldMDP;
import com.adobe.internal.pdftoolkit.services.xfa.impl.SOMExpressionUtils;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;

public class SignatureUtils {
    private static HashMap<String, String> oidCoreMap = new HashMap();
    private static HashMap<String, String> oidMap = new HashMap();
    private static HashMap<String, String> reverseOidCoreMap = new HashMap();

    public static byte[] getContents(PDFSignature pdfSignature) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosString contentsStr = pdfSignature.getCosDictionary().getCosString(ASName.k_Contents);
        if (contentsStr != null) {
            if (SignatureUtils.isURSignature(pdfSignature)) {
                contentsStr.setIsEncrypted(true);
            } else {
                contentsStr.setIsEncrypted(false);
            }
            return contentsStr.byteArrayValue();
        }
        return null;
    }

    public static boolean hasCertificates(PDFSignature pdfSignature) {
        return pdfSignature.getCosDictionary().containsKey(ASName.k_Cert);
    }

    public static boolean hasReferences(PDFSignature pdfSignature) {
        if (pdfSignature == null) {
            return false;
        }
        return pdfSignature.getCosDictionary().containsKey(ASName.k_Reference);
    }

    public static Iterator getReferencesIterator(PDFSignature pdfSignature) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (SignatureUtils.hasReferences(pdfSignature)) {
            return pdfSignature.getSignatureReferences().iterator();
        }
        return null;
    }

    public static boolean isRecipientSignature(PDFSignature pdfSignature) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return !SignatureUtils.isAuthorSignature(pdfSignature) && !SignatureUtils.isUsageRightsSignature(pdfSignature);
    }

    public static boolean isAuthorSignature(PDFSignature pdfSignature) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return SignatureUtils.containsTransformMethod(PDFSignature.k_DocMDP, pdfSignature);
    }

    public static boolean isDocumentTimeStampSignature(PDFSignature pdfSignature) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName subFilter = pdfSignature.getSubFilterName();
        return subFilter != null && subFilter.asString(true).equals(PDFSignatureSubFilter.ETSIRFC3161.toString());
    }

    public static boolean isCADESSignature(PDFSignature pdfSignature) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName subFilter = pdfSignature.getSubFilterName();
        return subFilter != null && subFilter.asString(true).equals(PDFSignatureSubFilter.ETSICADESDetached.toString());
    }

    public static boolean isUsageRightsSignature(PDFSignature pdfSignature) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return SignatureUtils.containsTransformMethod(PDFSignature.k_UR, pdfSignature) || SignatureUtils.containsTransformMethod(PDFSignature.k_UR3, pdfSignature);
    }

    public static boolean isUR3Signature(PDFSignature pdfSignature) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return SignatureUtils.containsTransformMethod(PDFSignature.k_UR3, pdfSignature);
    }

    public static boolean isURSignature(PDFSignature pdfSignature) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return SignatureUtils.containsTransformMethod(PDFSignature.k_UR, pdfSignature);
    }

    public static boolean hasFieldMDPRestrictions(PDFSignature pdfSignature) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return SignatureUtils.containsTransformMethod(PDFSignature.k_FieldMDP, pdfSignature);
    }

    public static boolean hasIdentityTransform(PDFSignature pdfSignature) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return SignatureUtils.containsTransformMethod(PDFSignature.k_Identity, pdfSignature);
    }

    private static boolean containsTransformMethod(ASName compareTransformMethod, PDFSignature pdfSignature) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!SignatureUtils.hasReferences(pdfSignature)) {
            return false;
        }
        PDFSignatureReferenceList sigRefList = pdfSignature.getSignatureReferences();
        for (PDFSignatureReference sigRef : sigRefList) {
            ASName transformMethod = sigRef.getTransformMethodName();
            if (transformMethod != compareTransformMethod) continue;
            return true;
        }
        return false;
    }

    public static boolean isPreReleaseSignature(PDFSignature pdfSignature) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFilterBuildData filterDict;
        PDFBuildProp buildPropDict = pdfSignature.getPDFBuildPropDictionary();
        if (buildPropDict != null && (filterDict = buildPropDict.getFilterDict()) != null) {
            return filterDict.getPreRelease();
        }
        return false;
    }

    public static boolean coversEntireDocument(PDFSignature pdfSignature) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        try {
            InputByteStream ibs = pdfSignature.getPDFDocument().getCosDocument().getStream();
            long docLength = ibs.length();
            ibs.close();
            ibs = null;
            long[] byteRanges = pdfSignature.getByteRanges();
            if (byteRanges == null) {
                throw new PDFInvalidParameterException("Missing byterange entry for signature");
            }
            long sigCoverageLength = byteRanges[2] + byteRanges[3];
            if (sigCoverageLength != docLength) {
                return false;
            }
            if (pdfSignature.getPDFDocument().getCosDocument().isDirty()) {
                return false;
            }
        }
        catch (IOException e) {
            throw new PDFIOException("IO exception when computing signature coverage", e);
        }
        return true;
    }

    private static boolean signatureInByteRange(PDFSignature pdfSignature) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        CosObject sigCosObj = pdfSignature.getCosObject();
        long sigPosition = sigCosObj.getObjPos();
        long[] byteRanges = pdfSignature.getByteRanges();
        if (byteRanges == null) {
            throw new PDFInvalidParameterException("Missing byterange entry for signature");
        }
        long sigHoleStart = byteRanges[0] + byteRanges[1];
        long endOfByteRange = byteRanges[2] + byteRanges[3];
        return sigPosition > byteRanges[0] && sigPosition < sigHoleStart || sigPosition > byteRanges[2] && sigPosition < endOfByteRange;
    }

    private static PDFTransformParametersFieldMDP getPDFTransformParametersFieldMDP(PDFSignature signature) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (signature == null) {
            return null;
        }
        PDFSignatureReferenceList sigRefList = signature.getSignatureReferences();
        if (sigRefList == null) {
            return null;
        }
        for (PDFSignatureReference sigRef : sigRefList) {
            ASName transformMethod;
            if (sigRef == null || (transformMethod = sigRef.getTransformMethodName()) != PDFSignature.k_FieldMDP) continue;
            return (PDFTransformParametersFieldMDP)sigRef.getPDFTransformParameters();
        }
        return null;
    }

    static void addSignatureFieldAppearanceToPageContentStream(SignatureFieldInterface sigField, PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFFontException, PDFSecurityException, PDFCosParseException, PDFConfigurationException, PDFInvalidParameterException {
        Content updatedContent;
        SignatureFieldPDF pdfField = sigField.getPDFField();
        if (pdfField == null) {
            return;
        }
        PDFAnnotationWidget annot = pdfField.getPDFFieldSignature().getAnnotation();
        PDFPage curPage = annot.getPage();
        ModifiableContent content = ModifiableContent.newInstance(curPage);
        ContentWriter contentWriter = ContentWriter.newInstance(content);
        if (content.getContents().hasContents()) {
            contentWriter.prepend(InstructionFactory.newGSave());
            contentWriter.write(InstructionFactory.newGRestore());
        }
        PDFStructureContentArray pageStructParents = PDFStructureUtils.getStructParentArray(curPage);
        PDFField annotField = annot.getField();
        if (!(annotField instanceof PDFFieldSignature)) {
            return;
        }
        int annotFlags = annot.getFlags();
        if ((annotFlags & 2) != 0 || (annotFlags & 0x20) != 0) {
            return;
        }
        PDFXObjectForm annotAppearance = annot.getNormalStateAppearance();
        if (annotAppearance == null) {
            return;
        }
        ASMatrix transformMatrix = annot.getTransformationMatrix(pdfDoc, annotAppearance);
        if (transformMatrix.geta() * transformMatrix.getd() - transformMatrix.getb() * transformMatrix.getc() != 0.0) {
            PDFStructureElement annotsStructParent;
            if (!annotAppearance.dictionaryContains(ASName.k_Subtype)) {
                annotAppearance.setDictionaryNameValue(ASName.k_Subtype, ASName.k_Form);
            }
            if ((annotsStructParent = PDFStructureUtils.getStructParentElement(annot)) != null) {
                if (pageStructParents == null) {
                    pageStructParents = PDFStructureContentArray.newInstance(curPage.getPDFDocument(), null);
                    PDFStructureUtils.setStructParentsInTree(pageStructParents, curPage);
                }
                PDFStructureUtils.removeOBJReference(annot);
                int newMCID = pageStructParents.size();
                ContentModifier.addXObject(contentWriter, null, transformMatrix, annotAppearance, new MarkedContentOperands(annotsStructParent, newMCID));
                annotsStructParent.addMCID(pageStructParents, newMCID);
                annotsStructParent.setPage(curPage);
            } else {
                ContentModifier.addXObject(contentWriter, null, transformMatrix, annotAppearance);
            }
        }
        if ((updatedContent = contentWriter.close()) != null) {
            curPage.setContents(updatedContent.getContents());
            curPage.setResources(updatedContent.getResources());
        }
    }

    static PDFTransformParametersUR createURTransform(PDFURDocument[] documentRights, PDFURAnnots[] annotRights, PDFUREmbeddedFiles[] embeddedFileRights, PDFURForm[] formRights, PDFURSignature[] signatureRights, String message, boolean restrictPermissions, PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFTransformParametersUR transformParams = PDFTransformParametersUR.newInstance(pdfDoc);
        transformParams.setMessage(message);
        transformParams.setDocumentUsageRights(documentRights);
        transformParams.setAnnotationUsageRights(annotRights);
        transformParams.setFormUsageRights(formRights);
        transformParams.setSignatureUsageRights(signatureRights);
        transformParams.setRestrictPermissions(restrictPermissions);
        transformParams.setEFUsageRights(embeddedFileRights);
        return transformParams;
    }

    private static boolean isFieldLockedByOthers(PDFSignature signature, String fieldName, Iterator<SignatureFieldInterface> sigIter) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        boolean fieldFound = false;
        while (sigIter.hasNext()) {
            int i;
            PDFTransformParametersFieldMDP fieldMDP;
            PDFSignature otherSignature;
            SignatureFieldInterface sigField = sigIter.next();
            fieldFound = false;
            if (!sigField.isSigned() || (otherSignature = sigField.getPDFField().getPDFFieldSignature().getSignature()).getCosObject() == signature.getCosObject() || (fieldMDP = SignatureUtils.getPDFTransformParametersFieldMDP(otherSignature)) == null) continue;
            PDFFieldAction action = fieldMDP.getAction();
            if (action == PDFFieldAction.All) {
                return true;
            }
            if (action == PDFFieldAction.Include) {
                String[] includeNames = fieldMDP.getFieldNames();
                for (i = 0; i < includeNames.length; ++i) {
                    if (!includeNames[i].equalsIgnoreCase(fieldName)) continue;
                    return true;
                }
                continue;
            }
            if (action != PDFFieldAction.Exclude) continue;
            String[] excludeNames = fieldMDP.getFieldNames();
            for (i = 0; i < excludeNames.length; ++i) {
                if (!excludeNames[i].equalsIgnoreCase(fieldName)) continue;
                fieldFound = true;
            }
            if (fieldFound) continue;
            return true;
        }
        return false;
    }

    static void clearFieldLocks(PDFFieldSignature sigField, PDFDocument pdfDoc, boolean formModelWorkFlow) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFTransformParametersFieldMDP fieldMDP;
        PDFSignature signature = sigField.getSignature();
        PDFFieldLock fieldLock = sigField.getPDFFieldLock();
        if (fieldLock != null) {
            fieldLock.setLockPermissions(null);
        }
        if ((fieldMDP = SignatureUtils.getPDFTransformParametersFieldMDP(signature)) == null) {
            return;
        }
        Set<String> fieldNamesToUnlock = SignatureUtils.removeFieldFromPDF(sigField, fieldMDP);
        if (fieldNamesToUnlock != null) {
            PDFFieldNode[] fieldsToUnlock;
            String[] fieldNames = fieldNamesToUnlock.toArray(new String[fieldNamesToUnlock.size()]);
            for (int i = 0; i < fieldNames.length; ++i) {
                fieldNames[i] = SOMExpressionUtils.trimSomExpression(fieldNames[i]);
            }
            PDFFieldNode[] pDFFieldNodeArray = fieldsToUnlock = fieldNames != null ? PDFFieldUtils.searchFields(fieldNames, pdfDoc) : null;
            if (fieldsToUnlock != null) {
                PDFField field = null;
                for (int i = 0; i < fieldsToUnlock.length; ++i) {
                    PDFFieldList fieldList = PDFFieldList.newInstance(pdfDoc);
                    if (fieldsToUnlock[i] != null && fieldsToUnlock[i] instanceof PDFField) {
                        field = (PDFField)fieldsToUnlock[i];
                        fieldList.add(field);
                    } else {
                        fieldList = fieldsToUnlock[i].getChildren(true);
                    }
                    for (int j = 0; j < fieldList.size(); ++j) {
                        field = (PDFField)fieldList.get(j);
                        PDFFieldNode flaggedNode = field.getInheritableValueFieldNode(ASName.k_Ff);
                        if (flaggedNode != null) {
                            flaggedNode.setFlags(field.getFlags() & 0xFFFFFFFE);
                            continue;
                        }
                        field.setFlags(field.getFlags() & 0xFFFFFFFE);
                    }
                }
            }
        }
        if (formModelWorkFlow) {
            try {
                FieldMDP xfaFieldMDP;
                SignatureFieldPDF pdfSigField;
                if (XFAService.getDocumentType(pdfDoc) == PDFDocument.PDFDocumentType.StaticNonShellXFA) {
                    pdfSigField = new SignatureFieldPDF(sigField);
                    if (pdfSigField.getXFAField() == null) {
                        return;
                    }
                    xfaFieldMDP = new FieldMDP(pdfDoc, pdfSigField);
                    xfaFieldMDP.removeFieldMDP();
                } else if (XFAService.getDocumentType(pdfDoc).isDynamic()) {
                    pdfSigField = new SignatureFieldPDF(sigField);
                    xfaFieldMDP = new FieldMDP(pdfDoc, pdfSigField);
                    xfaFieldMDP.removeFieldMDP();
                }
            }
            catch (PDFInvalidParameterException e) {
                throw new PDFInvalidDocumentException(e);
            }
        }
    }

    private static Set<String> removeFieldFromPDF(PDFFieldSignature sigField, PDFTransformParametersFieldMDP fieldMDP) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        HashSet<String> fieldsToUnlock = null;
        String[] fields = fieldMDP.getFieldNames();
        fieldsToUnlock = new HashSet<String>();
        PDFFieldAction action = fieldMDP.getAction();
        if (action == PDFFieldAction.Include && fields != null) {
            for (int i = 0; i < fields.length; ++i) {
                fieldsToUnlock.add(fields[i]);
            }
        } else if (action == PDFFieldAction.All || action == PDFFieldAction.Exclude) {
            PDFInteractiveForm iform = sigField.getPDFDocument().getInteractiveForm();
            Iterator<PDFField> fieldIter = iform.iterator();
            while (fieldIter.hasNext()) {
                fieldsToUnlock.add(fieldIter.next().getQualifiedName());
            }
            if (action == PDFFieldAction.Exclude && fields != null) {
                for (int i = 0; i < fields.length; ++i) {
                    fieldsToUnlock.remove(fields[i]);
                }
            }
        }
        Iterator fieldsIter = fieldsToUnlock.iterator();
        SignatureManager sigMgr = SignatureManager.newInstance(sigField.getPDFDocument());
        Iterator<SignatureFieldInterface> sigIter = null;
        String field = null;
        while (fieldsIter.hasNext()) {
            field = (String)fieldsIter.next();
            sigIter = sigMgr.getPDFSignatureFieldIterator();
            if (!SignatureUtils.isFieldLockedByOthers(sigField.getSignature(), field, sigIter)) continue;
            fieldsIter.remove();
        }
        if (fieldsToUnlock != null && fieldsToUnlock.isEmpty()) {
            fieldsToUnlock = null;
        }
        return fieldsToUnlock;
    }

    static void enforceSigFieldOnPDFDoc(SignatureFieldInterface sigField, PDFDocument pdfDoc) throws PDFInvalidParameterException {
        PDFDocument sigFieldDoc = sigField.getPDFDocument();
        if (sigFieldDoc != pdfDoc) {
            throw new PDFInvalidParameterException("Signature field not found in PDF document");
        }
    }

    static void removeXObjects(PDFDocument pdfDoc) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        PDFInteractiveForm iform = pdfDoc.requireCatalog().procureInteractiveForm();
        PDFResources resources = iform.procureResources();
        PDFXObjectMap drXObjMap = resources.procureXObjectMap();
        if (drXObjMap.containsKey((Object)ASName.create("DSx"))) {
            drXObjMap.remove(ASName.create("DSx"));
        }
        if (drXObjMap.containsKey((Object)ASName.create("DSy"))) {
            drXObjMap.remove(ASName.create("DSy"));
        }
        if (drXObjMap.containsKey((Object)ASName.create("DSy"))) {
            drXObjMap.remove(ASName.create("DSy"));
        }
        if (drXObjMap.containsKey((Object)ASName.create("DSz"))) {
            drXObjMap.remove(ASName.create("DSz"));
        }
        resources.removeValue(ASName.k_XObject);
    }

    static SignatureValidationStatus validate(XFADigSigWorkFlow workFlow, PDFSignature pdfSignature, SignatureOptions signatureOptions, SignatureServiceProvider sigServiceProvider) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFConfigurationException, PDFSignatureException {
        SignatureFieldInterface sigField = workFlow.getSignatureField();
        if (sigField != null && pdfSignature == null) {
            SignatureFieldPDF sigFieldPDF = sigField.getPDFField();
            PDFSignature pDFSignature = pdfSignature = sigFieldPDF != null ? sigFieldPDF.getPDFFieldSignature().getSignature() : null;
        }
        if (pdfSignature == null) {
            throw new PDFInvalidParameterException("signature parameter can not be null");
        }
        if (sigServiceProvider == null) {
            CryptoContext cryptoContext = new CryptoContext(CryptoMode.NON_FIPS_MODE, null, null);
            sigServiceProvider = new CertJNonFIPSProvider(cryptoContext, signatureOptions);
        }
        SignatureHandlerFactory handlerFactory = SignatureHandlerFactory.getSignatureHandlerFactory(PDFSignature.k_Adobe_PPKLite.asString(true));
        ASName subFilter = pdfSignature.getSubFilterName();
        if (subFilter == null) {
            throw new PDFConfigurationException("No subfilter present for Filter " + pdfSignature.getFilterName());
        }
        SignatureHandler sigHandler = handlerFactory.getSignatureHandler(subFilter.asString(true));
        if (sigHandler == null) {
            throw new PDFConfigurationException("The subfilter " + subFilter + " is not supported.");
        }
        if (!SignatureUtils.signatureInByteRange(pdfSignature)) {
            if (sigField != null) {
                return new SignatureValidationStatus(pdfSignature);
            }
            return new SignatureValidationStatus(null);
        }
        return workFlow.validate(sigHandler, pdfSignature.getPDFDocument(), sigField, pdfSignature, signatureOptions, sigServiceProvider);
    }

    public static boolean isSigningPermitted(PDFFieldSignature pdfFieldSignature) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFDocMDPPermissions perms;
        PDFFieldLock fieldLock = pdfFieldSignature.getPDFFieldLock();
        if (fieldLock != null && (perms = fieldLock.getLockPermissions()) == PDFDocMDPPermissions.NoChanges) {
            return false;
        }
        try {
            return SigningUtils.getSignatureFieldInterface(pdfFieldSignature).isSigningPermitted();
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException(e);
        }
    }

    public static boolean isCertifyPermitted(PDFFieldSignature pdfFieldSignature) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            return SigningUtils.getSignatureFieldInterface(pdfFieldSignature).isCertifyingPermitted();
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException(e);
        }
    }

    public static boolean isVisible(PDFFieldSignature pdfFieldSignature) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        return SigningUtils.getSignatureFieldInterface(pdfFieldSignature).isVisible();
    }

    public static boolean isSigned(PDFFieldSignature pdfFieldSignature) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            return SigningUtils.getSignatureFieldInterface(pdfFieldSignature).isSigned();
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException(e);
        }
    }

    public static String getAlgorithmName(ASN1ObjectIdentifier asn1ObjectIdentifier) throws IOException {
        return SignatureUtils.getAlgorithmName(asn1ObjectIdentifier.getId());
    }

    public static String getAlgorithmName(String algorithmID) throws IOException {
        String algorithmName = null;
        algorithmName = oidCoreMap.containsKey(algorithmID) ? oidCoreMap.get(algorithmID) : oidMap.get(algorithmID);
        return algorithmName;
    }

    public static String getAlgorithmId(String algorithmName) throws IOException, NoSuchAlgorithmException {
        algorithmName = SignatureUtils.getModifiedAlgorithmName(algorithmName);
        return reverseOidCoreMap.get(algorithmName);
    }

    public static PDFDocMDPPermissions getPossiblePermissionsAllowed(PDFDocument pdfDoc, PDFDocMDPPermissions perms) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (perms == null) {
            return null;
        }
        SignatureManager sigMgr = SignatureManager.newInstance(pdfDoc);
        PDFDocMDPPermissions fieldPerms = perms;
        PDFDocMDPPermissions docMDPPerms = sigMgr.getPDFDocMDPPermissions();
        if (docMDPPerms != null) {
            fieldPerms = docMDPPerms;
        }
        return PDFDocMDPPermissions.getInstance(Math.min(fieldPerms.getValue(), perms.getValue()));
    }

    private static String getModifiedAlgorithmName(String algorithmName) {
        if (algorithmName.equalsIgnoreCase("SHA") || algorithmName.equalsIgnoreCase("SHA1") || algorithmName.equalsIgnoreCase("SHA-1")) {
            return "SHA";
        }
        if (algorithmName.equalsIgnoreCase("SHA-256") || algorithmName.equalsIgnoreCase("SHA256")) {
            return "SHA256";
        }
        if (algorithmName.equalsIgnoreCase("SHA-384") || algorithmName.equalsIgnoreCase("SHA384")) {
            return "SHA384";
        }
        if (algorithmName.equalsIgnoreCase("SHA-512") || algorithmName.equalsIgnoreCase("SHA512")) {
            return "SHA512";
        }
        if (algorithmName.equalsIgnoreCase("MD5withRSA") || algorithmName.equalsIgnoreCase("MD5/RSA")) {
            return "MD5withRSA";
        }
        if (algorithmName.equalsIgnoreCase("MD2withRSA") || algorithmName.equalsIgnoreCase("MD2/RSA")) {
            return "MD2withRSA";
        }
        if (algorithmName.equalsIgnoreCase("SHAwithDSA") || algorithmName.equalsIgnoreCase("SHA1withDSA") || algorithmName.equalsIgnoreCase("SHA/DSA") || algorithmName.equalsIgnoreCase("SHA1/DSA") || algorithmName.equalsIgnoreCase("DSAWithSHA1") || algorithmName.equalsIgnoreCase("DSS") || algorithmName.equalsIgnoreCase("SHA-1/DSA")) {
            return "SHA1withDSA";
        }
        if (algorithmName.equalsIgnoreCase("SHA1WithRSA") || algorithmName.equalsIgnoreCase("SHA1/RSA")) {
            return "SHA1withRSA";
        }
        if (algorithmName.equalsIgnoreCase("SHA1withECDSA") || algorithmName.equalsIgnoreCase("ECDSA")) {
            return "SHA1withECDSA";
        }
        return null;
    }

    static {
        oidCoreMap.put("1.2.840.113549.2.5", "MD5");
        oidCoreMap.put("1.2.840.113549.2.2", "MD2");
        oidCoreMap.put("1.2.840.10045.2.1", "EC");
        oidCoreMap.put("1.2.840.10045.4.3.1", "SHA224withECDSA");
        oidCoreMap.put("1.2.840.10045.4.3.2", "SHA256withECDSA");
        oidCoreMap.put("1.2.840.10045.4.3.3", "SHA384withECDSA");
        oidCoreMap.put("1.2.840.10045.4.3.4", "SHA512withECDSA");
        oidCoreMap.put("1.3.14.3.2.12", "DSA");
        oidCoreMap.put("1.2.840.113549.1.1.11", "SHA256withRSA");
        oidCoreMap.put("1.2.840.113549.1.1.12", "SHA384withRSA");
        oidCoreMap.put("1.2.840.113549.1.1.13", "SHA512withRSA");
        oidCoreMap.put("1.2.840.113549.1.5.3", "PBEWithMD5AndDES");
        oidCoreMap.put("1.2.840.113549.1.5.6", "PBEWithMD5AndRC2");
        oidCoreMap.put("1.2.840.113549.1.5.10", "PBEWithSHA1AndDES");
        oidCoreMap.put("1.2.840.113549.1.5.11", "PBEWithSHA1AndRC2");
        oidCoreMap.put("1.2.840.113549.1.12.1.3", "PBEWithSHA1AndDESede");
        oidCoreMap.put("1.2.840.113549.1.12.1.6", "PBEWithSHA1AndRC2_40");
        oidCoreMap.put("1.3.14.3.2.26", "SHA");
        oidCoreMap.put("2.16.840.1.101.3.4.2.1", "SHA256");
        oidCoreMap.put("2.16.840.1.101.3.4.2.2", "SHA384");
        oidCoreMap.put("2.16.840.1.101.3.4.2.3", "SHA512");
        oidCoreMap.put("1.2.840.113549.1.1.4", "MD5withRSA");
        oidCoreMap.put("1.2.840.113549.1.1.2", "MD2withRSA");
        oidCoreMap.put("1.2.840.10040.4.3", "SHA1withDSA");
        oidCoreMap.put("1.2.840.113549.1.1.5", "SHA1withRSA");
        oidCoreMap.put("1.2.840.10045.4.1", "SHA1withECDSA");
        oidCoreMap.put("1.2.840.113549.1.1.1", "RSA");
        oidMap.put("2.5.8.1.1", "RSA");
        oidMap.put("1.3.14.3.2.27", "SHA1withDSA");
        oidMap.put("1.3.14.3.2.13", "SHA1withDSA");
        oidMap.put("1.3.14.3.2.29", "SHA1withRSA");
        Set<Map.Entry<String, String>> entries = oidCoreMap.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            reverseOidCoreMap.put(entry.getValue(), entry.getKey());
        }
    }
}

