/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnsupportedFeatureException;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignature;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureOptionsLeanDoc;
import com.adobe.internal.pdftoolkit.services.xfa.XFAProcessingOptions;

public class SignatureOptionsUR
extends SignatureOptionsLeanDoc {
    private String transformDigestMethod;

    private SignatureOptionsUR() {
        this.signingEventsList.remove((Object)XFAProcessingOptions.SigningEvent.PRESIGN);
        this.signingEventsList.remove((Object)XFAProcessingOptions.SigningEvent.POSTSIGN);
    }

    public static SignatureOptionsUR newInstance() {
        return new SignatureOptionsUR();
    }

    public boolean hasTransformDigestMethod() {
        return this.transformDigestMethod != null;
    }

    public String getTransformDigestMethod() {
        return this.transformDigestMethod;
    }

    public void setTransformDigestMethod(String digestMethod) {
        if (!this.isTransformDigestSupported(digestMethod)) {
            throw new PDFUnsupportedFeatureException("Digest method " + digestMethod + " not supported");
        }
        this.transformDigestMethod = digestMethod;
    }

    private boolean isTransformDigestSupported(String digest) {
        return digest.equalsIgnoreCase(PDFSignature.k_MD5.asString(true)) || digest.equalsIgnoreCase(PDFSignature.k_SHA1.asString(true));
    }
}

