/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.ap.impl;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.fontset.PDFFontSet;
import com.adobe.internal.pdftoolkit.core.fontset.impl.PDFFontSetImpl;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationIterator;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAppearance;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAppearanceCharacteristics;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFField;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldBarcode;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldButton;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldChoice;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldSignature;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldText;
import com.adobe.internal.pdftoolkit.services.ap.AppearanceAttributes;
import com.adobe.internal.pdftoolkit.services.ap.ButtonApProviderImpl;
import com.adobe.internal.pdftoolkit.services.ap.extension.APExtensionException;
import com.adobe.internal.pdftoolkit.services.ap.extension.APExtensionOptions;
import com.adobe.internal.pdftoolkit.services.ap.extension.BarcodeApProvider;
import com.adobe.internal.pdftoolkit.services.ap.extension.ButtonApProvider;
import com.adobe.internal.pdftoolkit.services.ap.impl.TextAppearance;
import com.adobe.internal.pdftoolkit.services.ap.spi.APResources;
import com.adobe.internal.pdftoolkit.services.ap.spi.TextFormatter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class FieldAppearance {
    private static ASName[] FIELD_KEYS = new ASName[]{ASName.k_V, ASName.k_RV, ASName.k_DV, ASName.k_Opt};

    private FieldAppearance() {
    }

    public static void generateFieldAppearance(PDFField pdfField, PDFFontSet pdfFonts, PDFResources defResources, Locale locale, HashMap afePDFFontMap, APExtensionOptions extensionOptions, TextFormatter textFormatter) throws PDFFontException, PDFConfigurationException, PDFIOException, PDFInvalidDocumentException, PDFInvalidParameterException, PDFSecurityException {
        FieldAppearance.generateFieldAppearance(pdfField, pdfFonts, defResources, locale, afePDFFontMap, extensionOptions, textFormatter, null, null, null);
    }

    public static void generateFieldAppearance(PDFField pdfField, PDFFontSet pdfFonts, PDFResources defResources, Locale locale, HashMap afePDFFontMap, APExtensionOptions extensionOptions, TextFormatter textFormatter, Map<String, AppearanceAttributes> valueListAPAttr, Map<String, PDFAnnotation> valueListPDFAnnot, Map<String, PDFXObjectForm> valueListAPStream) throws PDFFontException, PDFConfigurationException, PDFIOException, PDFInvalidDocumentException, PDFInvalidParameterException, PDFSecurityException {
        if (pdfField instanceof PDFFieldText || pdfField instanceof PDFFieldChoice || pdfField instanceof PDFFieldButton || pdfField instanceof PDFFieldSignature && pdfField.getDictionaryValue(ASName.k_V) == null) {
            PDFDocument curDoc = pdfField.getPDFDocument();
            PDFAnnotationIterator annotsIter = pdfField.getAnnotationsIterator();
            if (annotsIter != null) {
                while (annotsIter.hasNext()) {
                    PDFXObjectForm appearanceStream;
                    PDFAnnotation annot = annotsIter.next();
                    if (!(annot instanceof PDFAnnotationWidget)) continue;
                    if (pdfField instanceof PDFFieldText && ((PDFAnnotationWidget)annot).hasPMD()) {
                        if (extensionOptions == null) {
                            return;
                        }
                        BarcodeApProvider barcodeApProvider = extensionOptions.getBarcodeApProvider();
                        if (barcodeApProvider == null) {
                            throw new PDFConfigurationException("BarcodeApProvider is not registered.");
                        }
                        try {
                            barcodeApProvider.generateAppearance(PDFFieldBarcode.getInstance(pdfField.getCosObject()));
                            return;
                        }
                        catch (APExtensionException e) {
                            throw new PDFInvalidDocumentException(e);
                        }
                    }
                    if (pdfField instanceof PDFFieldButton) {
                        ButtonApProvider buttonApProvider = null;
                        if (extensionOptions != null) {
                            buttonApProvider = extensionOptions.getButtonApProvider();
                        }
                        if (buttonApProvider == null) {
                            buttonApProvider = new ButtonApProviderImpl(new APResources(pdfFonts, locale, afePDFFontMap));
                        }
                        try {
                            buttonApProvider.generateAppearance(PDFFieldButton.getInstance(pdfField.getCosObject()));
                            return;
                        }
                        catch (APExtensionException e) {
                            throw new PDFInvalidDocumentException(e);
                        }
                    }
                    if (pdfField instanceof PDFFieldSignature && !((PDFAnnotationWidget)annot).hasAppearanceCharacteristics() || (appearanceStream = FieldAppearance.generateSingleAnnotAppearance(annot, pdfField, curDoc, pdfFonts, defResources, locale, afePDFFontMap, textFormatter, valueListAPAttr, valueListPDFAnnot, valueListAPStream)) == null) continue;
                    PDFAppearance fieldAppearance = annot.getAppearance();
                    if (fieldAppearance == null) {
                        fieldAppearance = PDFAppearance.newInstance(curDoc);
                    }
                    fieldAppearance = fieldAppearance.setNormalStateAppearance(annot.getAppearanceState(), appearanceStream);
                    annot.setAppearance(fieldAppearance);
                }
            }
        }
    }

    public static PDFXObjectForm generateSingleAnnotAppearance(PDFAnnotation annot, PDFField field, PDFDocument curDoc, PDFFontSet pdfFonts, PDFResources defResources, Locale locale, HashMap afePDFFontMap, TextFormatter textFormatter) throws PDFFontException, PDFConfigurationException, PDFIOException, PDFInvalidDocumentException, PDFInvalidParameterException, PDFSecurityException {
        return FieldAppearance.generateSingleAnnotAppearance(annot, field, curDoc, pdfFonts, defResources, locale, afePDFFontMap, textFormatter, null, null, null);
    }

    public static PDFXObjectForm generateSingleAnnotAppearance(PDFAnnotation annot, PDFField field, PDFDocument curDoc, PDFFontSet pdfFonts, PDFResources defResources, Locale locale, HashMap afePDFFontMap, TextFormatter textFormatter, Map<String, AppearanceAttributes> valueListAPAttr, Map<String, PDFAnnotation> valueListPDFAnnot, Map<String, PDFXObjectForm> valueListAPStream) throws PDFFontException, PDFConfigurationException, PDFIOException, PDFInvalidDocumentException, PDFInvalidParameterException, PDFSecurityException {
        if (annot.getCosObject() != field.getCosObject()) {
            FieldAppearance.removeFieldEntriesFormPureAnnotation(annot);
        }
        AppearanceAttributes appearanceAttributes = textFormatter.fetchAppearanceAttributes(annot, defResources, locale);
        PDFXObjectForm appearanceStream = null;
        double targetRegionHeight = appearanceAttributes.getRcgOptions().getHeight();
        double targetRegionWidth = appearanceAttributes.getRcgOptions().getWidth();
        if (targetRegionHeight == 0.0 || targetRegionWidth == 0.0) {
            return appearanceStream;
        }
        if (appearanceAttributes.getTextValue() != null) {
            String keyTextValue;
            if (pdfFonts == null) {
                pdfFonts = new PDFFontSetImpl();
            }
            PDFAnnotationWidget pdfAnnotWidget = null;
            if (annot instanceof PDFAnnotationWidget) {
                pdfAnnotWidget = (PDFAnnotationWidget)annot;
            }
            if (FieldAppearance.checkCondition(appearanceAttributes, valueListAPAttr, valueListPDFAnnot, pdfAnnotWidget, keyTextValue = FieldAppearance.fetchSubString(appearanceAttributes.getTextValue()))) {
                appearanceStream = valueListAPStream.get(keyTextValue);
            } else {
                if (valueListAPAttr != null && !keyTextValue.isEmpty()) {
                    valueListAPAttr.put(keyTextValue, appearanceAttributes);
                    valueListPDFAnnot.put(keyTextValue, pdfAnnotWidget);
                }
                appearanceStream = TextAppearance.buildTextAppearance(curDoc, pdfFonts, annot, field, afePDFFontMap, appearanceAttributes, textFormatter);
                if (valueListAPAttr != null && !keyTextValue.isEmpty()) {
                    valueListAPStream.put(keyTextValue, appearanceStream);
                }
            }
        }
        return appearanceStream;
    }

    private static String fetchSubString(String keyTextValue) {
        if (keyTextValue == null || keyTextValue.isEmpty()) {
            return "";
        }
        int initialIndex = keyTextValue.indexOf("<p>");
        int lastIndex = keyTextValue.lastIndexOf("</p>");
        if (initialIndex == -1 || lastIndex == -1) {
            return keyTextValue;
        }
        return keyTextValue.substring(initialIndex + 3, lastIndex);
    }

    private static boolean checkCondition(AppearanceAttributes appearanceAttributes, Map<String, AppearanceAttributes> valueListAPAttr, Map<String, PDFAnnotation> valueListPDFAnnot, PDFAnnotationWidget pdfAnnotWidget, String keyTextValue) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        if (valueListAPAttr == null) {
            return false;
        }
        if (!appearanceAttributes.equals(valueListAPAttr.get(keyTextValue))) {
            return false;
        }
        PDFAnnotationWidget otherPDFAnnotWidget = (PDFAnnotationWidget)valueListPDFAnnot.get(keyTextValue);
        if (pdfAnnotWidget == null || otherPDFAnnotWidget == null) {
            return false;
        }
        CosObject DV1 = pdfAnnotWidget.getCosDictionary().get(ASName.k_DV);
        CosObject DV2 = otherPDFAnnotWidget.getCosDictionary().get(ASName.k_DV);
        if (DV1 == null || DV2 == null) {
            return false;
        }
        if (!DV1.equals(DV2)) {
            return false;
        }
        PDFAppearanceCharacteristics pdfAPCharact = null;
        PDFAppearanceCharacteristics otherPDFAPCharact = null;
        if (pdfAnnotWidget.hasAppearanceCharacteristics()) {
            pdfAPCharact = pdfAnnotWidget.getAppearanceCharacteristics();
        }
        if (otherPDFAnnotWidget.hasAppearanceCharacteristics()) {
            otherPDFAPCharact = otherPDFAnnotWidget.getAppearanceCharacteristics();
        }
        if (pdfAPCharact == null) {
            return false;
        }
        return pdfAPCharact.compare(otherPDFAPCharact);
    }

    private static void removeFieldEntriesFormPureAnnotation(PDFAnnotation annot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        for (int i = 0; i < FIELD_KEYS.length; ++i) {
            annot.removeValue(FIELD_KEYS[i]);
        }
    }
}

