/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.ap;

import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontException;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.inlineformatting.FormattingException;
import com.adobe.internal.afml.AFMLAttribute__Abstract;
import com.adobe.internal.afml.AFMLException;
import com.adobe.internal.afml.AFMLExceptionInvalidParameter;
import com.adobe.internal.afml.AFMLExceptionUnsupportedFeature;
import com.adobe.internal.agm.AGMException;
import com.adobe.internal.agm.AGMPort;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnsupportedFeatureException;
import com.adobe.internal.pdftoolkit.core.fontset.PDFFontSet;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType0;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRedaction;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFBorderStyle;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFField;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldChoice;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldText;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldUtils;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFVariableText;
import com.adobe.internal.pdftoolkit.services.ap.AppearanceAttributes;
import com.adobe.internal.pdftoolkit.services.ap.StyleAttributes;
import com.adobe.internal.pdftoolkit.services.ap.impl.AppearanceUtils;
import com.adobe.internal.pdftoolkit.services.ap.impl.DefaultFont;
import com.adobe.internal.pdftoolkit.services.ap.impl.TextFormatterCompatibility;
import com.adobe.internal.pdftoolkit.services.ap.impl.XFAAttributesUtils;
import com.adobe.internal.pdftoolkit.services.ap.spi.TextFormatter;
import com.adobe.internal.pdftoolkit.services.rcg.RCGAlignment;
import com.adobe.internal.pdftoolkit.services.rcg.RCGOptions;
import com.adobe.internal.pdftoolkit.services.rcg.RCGOverflowMode;
import com.adobe.internal.pdftoolkit.services.rcg.RCGWrapOption;
import com.adobe.internal.pdftoolkit.services.rcg.impl.RichTextHandler;
import com.adobe.internal.pdftoolkit.services.xfa.XFADOM;
import com.adobe.internal.pdftoolkit.services.xfa.XFADOMService;
import com.adobe.internal.pdftoolkit.services.xfa.XFAProcessingOptions;
import com.adobe.internal.pdftoolkit.services.xfa.XFAService;
import com.adobe.internal.pdftoolkit.services.xfa.form.DocumentContext;
import com.adobe.internal.pdftoolkit.services.xfatext.FormatXFAResultInfo;
import com.adobe.internal.pdftoolkit.services.xfatext.FormatXFAText;
import com.adobe.internal.pdftoolkit.services.xfatext.RegionAndAnnotInfo;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.Element;
import com.adobe.xfa.Measurement;
import com.adobe.xfa.XFA;
import com.adobe.xfa.template.TemplateModel;
import com.adobe.xfa.template.containers.Field;
import com.adobe.xfa.template.ui.UI;
import com.adobe.xfa.text.TextMeasurement;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class TextFormatterImpl
implements TextFormatter {
    private static final String TEXT_ALIGN_LEFT_ATTR = " text-align = \"left\"";
    private static final String TEXT_ALIGN_LEFT_CSS = "; text-align:left";
    private static final String BODY_NAME_START = "<b";
    private static final String XML_END_TAG = ">";
    private static final String STYLE_NAME = " style";
    private static final String PARA_NAME_TEXTVALIGN = "text-valign:";
    private static final String PARA_NAME_END = ";";
    private static final String ALIGNMENT_MIDDLE = "middle";
    private static final String ALIGNMENT_TOP = "top";
    private static final String bgCOLOR_NAME = "background-color";
    private static final String fontHL_COLOR_ATTR = " color=\"rgb(0,0,0)\"";
    private static final String fontHL_COLOR_CSS = ";color:#000000";
    private static final String bgCOLOR_STYLE_ATTR = "background-color=\"rgb(153,193,218)\"";
    private static final String bgCOLOR_STYLE_CSS = "background-color:rgb(153,193,218);";
    protected XFADOM xfaDom;
    private static final int MAX_ITERATIONS_FONT_SIZE_ADJUSTMENT = 10;
    private static final double CONVERGENCE_FACTOR_FONT_SIZE_ADJUSTMENT = 0.999;

    public TextFormatterImpl(PDFDocument pdfDoc) throws PDFSecurityException, PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException {
        if (pdfDoc == null) {
            throw new PDFInvalidParameterException("pdfDoc is a required parameter");
        }
        if (XFAService.getDocumentType(pdfDoc) == PDFDocument.PDFDocumentType.StaticNonShellXFA) {
            this.xfaDom = XFADOMService.ensureXFADOMCreated(pdfDoc);
        }
    }

    protected TextFormatterImpl() {
    }

    @Override
    public AppearanceAttributes fetchAppearanceAttributes(PDFAnnotation annot, PDFResources defResources, Locale locale) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFCosParseException, PDFInvalidParameterException, PDFFontException {
        PDFField field = PDFField.getInstance(annot.getCosObject());
        if (field == null) {
            field = ((PDFAnnotationWidget)annot).getParentField();
        }
        if (field == null) {
            throw new PDFInvalidDocumentException("Parent field can not be foudn for the annotation");
        }
        PDFVariableText varText = PDFVariableText.getInstance(field.getCosObject());
        PDFDocument curDoc = field.getPDFDocument();
        AppearanceAttributes appearanceAttributes = this.getAppearanceAttributesFromCOS(annot, field, curDoc, defResources, locale, varText);
        boolean xfaAppearanceGenerationRequired = field instanceof PDFFieldText || field instanceof PDFFieldChoice;
        boolean isLegacyXFAProcessingRequired = false;
        if (xfaAppearanceGenerationRequired) {
            try {
                isLegacyXFAProcessingRequired = TextFormatterImpl.isLegacyProcessingRequired(curDoc, defResources, appearanceAttributes.getStyleAttributes().getFontName());
                xfaAppearanceGenerationRequired = this.getAppearanceAttributesFromXFA(annot, field, appearanceAttributes, isLegacyXFAProcessingRequired);
                appearanceAttributes.getRcgOptions().getTargetRegion().setXFAVersion(this.getXFAVersion());
            }
            catch (PDFUnableToCompleteOperationException e) {
                throw new PDFInvalidDocumentException("Error fetching attributes from XFA", e);
            }
        }
        int fieldFlags = 0;
        if (field != null && field.hasFlags()) {
            fieldFlags = field.getFlags();
        }
        appearanceAttributes.setMultiLine((fieldFlags & 0x1000) != 0);
        if (appearanceAttributes.isMultiLine() & !appearanceAttributes.isAutoSize() && !xfaAppearanceGenerationRequired || annot instanceof PDFAnnotationRedaction) {
            appearanceAttributes.getStyleAttributes().setLineHeightPrecedenceOverride("use-font-size");
        }
        double[] clipPadding = null;
        if (xfaAppearanceGenerationRequired && !isLegacyXFAProcessingRequired) {
            clipPadding = new double[]{appearanceAttributes.getRcgOptions().getPaddingLeft(), appearanceAttributes.getRcgOptions().getPaddingRight(), appearanceAttributes.getRcgOptions().getPaddingTop(), appearanceAttributes.getRcgOptions().getPaddingBottom()};
        } else {
            PDFBorderStyle bs = annot.getBorderStyle();
            double lineWidth = 1.0;
            if (bs != null && bs.hasWidth()) {
                lineWidth = bs.getWidth();
            }
            clipPadding = new double[]{lineWidth, lineWidth, lineWidth, lineWidth};
        }
        appearanceAttributes.setClipPadding(clipPadding);
        XFAProcessingOptions xfaProcessingOptions = XFADOMService.getXFAProcessingOptions(curDoc);
        String valueText = TextFormatterImpl.getFieldValue(curDoc, field, varText, appearanceAttributes.getStyleAttributes().getStyleString(), appearanceAttributes.getPasswordChar(), xfaProcessingOptions != null && xfaProcessingOptions.xfaCosSyncEnabled(), appearanceAttributes);
        appearanceAttributes.setTextValue(valueText);
        appearanceAttributes.setField(field);
        StyleAttributes styleAttributes = appearanceAttributes.getStyleAttributes();
        if (!(field instanceof PDFFieldChoice)) {
            this.adjustAlignment(styleAttributes);
        }
        return appearanceAttributes;
    }

    protected void adjustAlignment(StyleAttributes styleAttributes) {
        if (styleAttributes.getTextAlignment() == 0) {
            styleAttributes.setCollapsibleTrailingSpaces(false);
        } else if (styleAttributes.getTextAlignment() == 1) {
            styleAttributes.setCollapsibleTrailingSpaces(true);
            styleAttributes.setDeleteTrailingSpaces(true);
            styleAttributes.setIncludeTrailingSpacesToComputeFontSize(true);
        } else if (styleAttributes.getTextAlignment() == 2) {
            styleAttributes.setCollapsibleTrailingSpaces(true);
            styleAttributes.setDeleteTrailingSpaces(true);
        }
    }

    private static boolean isLegacyProcessingRequired(PDFDocument curDoc, PDFResources resources, String fontName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (resources != null && resources.getFontMap() != null) {
            PDFFont font = resources.getFontMap().get(ASName.create(fontName));
            if (font instanceof PDFFontType0) {
                return false;
            }
            return DocumentContext.isLegacyXFADoc(curDoc);
        }
        return false;
    }

    protected AppearanceAttributes getAppearanceAttributesFromCOS(PDFAnnotation annot, PDFField field, PDFDocument curDoc, PDFResources defResources, Locale locale, PDFVariableText varText) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        boolean isRichText = varText.getRichText() != null;
        int quadding = varText.getQuadding();
        String fieldDefStyle = varText.getDefaultStyle();
        StyleAttributes defaultStyleAttr = null;
        RCGOptions options = null;
        boolean autoSize = false;
        if (fieldDefStyle == null) {
            String defAppearance = null;
            if (varText != null && varText.getDefaultAppearance() != null) {
                defAppearance = varText.getDefaultAppearance().asString();
            }
            if (defAppearance == null) {
                defAppearance = curDoc.getInteractiveForm().getDefaultAppearance();
            }
            autoSize = (defaultStyleAttr = AppearanceUtils.makeStyle(curDoc, defaultStyleAttr, defAppearance, quadding, defResources, locale)).getFontSize() == 0.0;
            options = this.getOptions(annot, field, autoSize);
            if (field instanceof PDFFieldText && ((PDFFieldText)field).isComb() && annot instanceof PDFAnnotationWidget) {
                AppearanceUtils.addCombFontSize((PDFFieldText)field, (PDFAnnotationWidget)annot, autoSize, options, defaultStyleAttr);
            }
        } else {
            defaultStyleAttr = new StyleAttributes(fieldDefStyle);
            options = this.getOptions(annot, field, autoSize);
        }
        if (defaultStyleAttr.getFontSize() == 0.0) {
            defaultStyleAttr.setFontSize(DefaultFont.getDefaultSize(locale));
        }
        AppearanceAttributes ap = new AppearanceAttributes(defaultStyleAttr, options);
        ap.setRichText(isRichText);
        ap.setAutoSize(autoSize);
        return ap;
    }

    private static String getFieldValue(PDFDocument curDoc, PDFField pdfField, PDFVariableText varText, String style, char passwordChar, boolean isXFAProcessed, AppearanceAttributes appearanceAttributes) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        String valueText = null;
        if (appearanceAttributes.isRichText()) {
            valueText = pdfField.getValueList() != null ? TextFormatterImpl.synchRichTextWithPlainText(curDoc, pdfField, varText, style, passwordChar, isXFAProcessed) : varText.getRichText();
            if (!TextFormatterImpl.determineStringIsARichTextString(valueText)) {
                ArrayList<String> values = new ArrayList<String>();
                values.add(valueText);
                valueText = RichTextHandler.convertString2RichText(values);
            }
        } else {
            valueText = RichTextHandler.getRichTextForValue(pdfField, passwordChar, isXFAProcessed, appearanceAttributes);
        }
        if (valueText == null) {
            return "";
        }
        return valueText;
    }

    private static boolean determineStringIsARichTextString(String testString) {
        String[] values = new String[]{"<div", "</div>", "</xml>", "<?xml version=\"1.0\"?>", "</body>", "</p>", "</span>"};
        for (int i = 0; i < values.length; ++i) {
            if (!testString.contains(values[i])) continue;
            return true;
        }
        return false;
    }

    protected RCGOptions getOptions(PDFAnnotation annot, PDFField field, boolean autoSize) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        boolean isRichTextValue;
        PDFRectangle targetRect = null;
        if (annot.getNormalStateAppearance() != null) {
            PDFXObjectForm appearanceOld = annot.getNormalStateAppearance();
            targetRect = appearanceOld.getBBox();
        }
        if (targetRect == null) {
            if (annot instanceof PDFAnnotationWidget) {
                targetRect = AppearanceUtils.getBBoxRectangle((PDFAnnotationWidget)annot);
            } else {
                PDFRectangle annotRect = annot.getRect();
                targetRect = PDFRectangle.newInstance(annot.getPDFDocument(), 0.0, 0.0, annotRect.width(), annotRect.height());
            }
        }
        RCGOptions options = new RCGOptions(targetRect.width(), targetRect.height());
        double borderWidth = AppearanceUtils.getBorderWidth(annot);
        int fieldFlags = 0;
        if (field != null && field.hasFlags()) {
            fieldFlags = field.getFlags();
        }
        boolean isMultiLine = (fieldFlags & 0x1000) != 0;
        boolean bl = isRichTextValue = (fieldFlags & 0x2000000) != 0;
        if (!isMultiLine) {
            options.setVerticalAlignment(RCGAlignment.Middle);
            options.setWrap(RCGWrapOption.NoWrap);
        } else {
            options.setVerticalAlignment(RCGAlignment.Top);
            options.setWrap(RCGWrapOption.Emergency);
        }
        if (field instanceof PDFFieldChoice && !((PDFFieldChoice)field).isComboBox()) {
            options.setVerticalAlignment(RCGAlignment.Top);
        }
        if (autoSize && !isMultiLine && !isRichTextValue) {
            options.setOverflow(RCGOverflowMode.ShrinkToFit);
        } else {
            options.setOverflow(RCGOverflowMode.Auto);
        }
        if (field instanceof PDFFieldText && ((PDFFieldText)field).isComb()) {
            options.setOverflow(RCGOverflowMode.Auto);
        }
        double paddingLeft = borderWidth * 2.0;
        double paddingRight = borderWidth * 2.0;
        double paddingTop = borderWidth;
        double paddingBottom = borderWidth;
        if (isMultiLine) {
            paddingTop *= 2.0;
            if (autoSize && !isRichTextValue) {
                paddingBottom *= 2.0;
            }
        }
        try {
            if (targetRect.width() - paddingLeft - paddingRight > 0.0) {
                options.setPaddingLeft(paddingLeft);
                options.setPaddingRight(paddingRight);
            } else {
                options.setPaddingLeft(0.0);
                options.setPaddingRight(0.0);
            }
            if (targetRect.height() - paddingTop - paddingBottom > 0.0) {
                options.setPaddingTop(paddingTop);
                options.setPaddingBottom(paddingBottom);
            } else {
                options.setPaddingTop(0.0);
                options.setPaddingBottom(0.0);
            }
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException("Cannot set RCGOptions.", e);
        }
        return options;
    }

    protected boolean getAppearanceAttributesFromXFA(PDFAnnotation annot, PDFField field, AppearanceAttributes appearanceAttributes, boolean isLegacyXFAProcessingRequired) throws PDFCosParseException, PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, PDFFontException {
        Attribute borderPresence;
        Element oBorder;
        Element oTextEdit;
        Field oField = XFAAttributesUtils.getXFAField(this.xfaDom, field);
        if (oField == null) {
            return false;
        }
        Element oPara = oField.peekElement(XFA.PARATAG, true, 0);
        if (oPara == null) {
            throw new PDFInvalidDocumentException("Para element not found");
        }
        TextFormatterImpl.getHorizontalAlignmentFromXFA(appearanceAttributes.getStyleAttributes(), oPara);
        Element oUi = oField.peekElement(XFA.UITAG, true, 0);
        if (oUi != null && (oTextEdit = oUi.peekElement(XFA.TEXTEDITTAG, true, 0)) != null && (oBorder = oTextEdit.peekElement(XFA.BORDERTAG, true, 0)) != null && (borderPresence = oBorder.getAttributeByName("presence", false)) != null && (borderPresence.getAttrValue().equalsIgnoreCase("HIDDEN") || borderPresence.getAttrValue().equalsIgnoreCase("INACTIVE"))) {
            appearanceAttributes.getRcgOptions().setPaddingAll(0.0);
        }
        if (field instanceof PDFFieldText || field instanceof PDFFieldChoice && ((PDFFieldChoice)field).isComboBox()) {
            Element oFont = oField.peekElement(XFA.FONTTAG, true, 0);
            if (oFont == null) {
                throw new PDFInvalidDocumentException("Font element not found");
            }
            TextFormatterImpl.getPasswordCharFromXFA(oField, appearanceAttributes);
            if (!isLegacyXFAProcessingRequired) {
                TextFormatterImpl.populateRCGOptionsFromXFA(appearanceAttributes.getRcgOptions(), oField, oPara, appearanceAttributes.isRichText());
            }
            TextFormatterImpl.populateStyleAttributesFromXFA(annot, appearanceAttributes.getStyleAttributes(), oPara, oFont, isLegacyXFAProcessingRequired);
        }
        return true;
    }

    private static void populateRCGOptionsFromXFA(RCGOptions options, Field oField, Element oPara, boolean isRichText) throws PDFInvalidParameterException {
        TextFormatterImpl.getVericalAlignmentFromXFA(options, oPara);
        TextFormatterImpl.getMarginFromXFA(options, oField, !isRichText);
    }

    private static void populateStyleAttributesFromXFA(PDFAnnotation annot, StyleAttributes styleAttributes, Element oPara, Element oFont, boolean isLegacyXFAProcessingRequired) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Attribute fonttypeface;
        TextFormatterImpl.getTextUnderlineFromXFA(styleAttributes, oFont);
        TextFormatterImpl.getTextLinethroughFromXFA(styleAttributes, oFont);
        if (!isLegacyXFAProcessingRequired) {
            TextFormatterImpl.getLineHeightFromXFA(styleAttributes, oPara);
            TextFormatterImpl.getTextIndentFromXFA(styleAttributes, oPara);
            TextFormatterImpl.getLetterSpacingFromXFA(styleAttributes, oFont, annot.getPDFDocument());
        }
        if ((fonttypeface = oFont.getAttributeByName("typeface", false)) != null) {
            Attribute fontposture;
            boolean shouldSetFont = false;
            if (styleAttributes.getFontName() == null || styleAttributes.getRealFontName() == null) {
                shouldSetFont = true;
            }
            if (!shouldSetFont && styleAttributes.getFontName().contains("+")) {
                shouldSetFont = true;
            }
            String fontname = fonttypeface.getAttrValue();
            if (!shouldSetFont) {
                String realFontName = styleAttributes.getRealFontName();
                String[] parts = realFontName.split("-");
                realFontName = parts[0];
                if (!fontname.replaceAll("\\s+", "").equalsIgnoreCase(realFontName.replaceAll("\\s+", ""))) {
                    shouldSetFont = true;
                }
            }
            String fontWeightPosture = null;
            Attribute fontweight = oFont.getAttributeByName("weight", false);
            if (fontweight != null && fontweight.getAttrValue().equalsIgnoreCase("BOLD")) {
                fontWeightPosture = "Bold";
                if (!shouldSetFont && !styleAttributes.getFontName().contains("Bold")) {
                    shouldSetFont = true;
                }
            }
            if ((fontposture = oFont.getAttributeByName("posture", false)) != null && fontposture.getAttrValue().equalsIgnoreCase("ITALIC")) {
                fontWeightPosture = (fontWeightPosture == null ? "" : fontWeightPosture) + "Italic";
                if (!shouldSetFont && !styleAttributes.getFontName().contains("Italic")) {
                    shouldSetFont = true;
                }
            }
            if (fontWeightPosture != null) {
                fontname = fontname + "-" + fontWeightPosture;
            }
            if (shouldSetFont) {
                styleAttributes.setFontName(fontname);
            }
        } else if (null == styleAttributes.getFontName()) {
            styleAttributes.setFontName(ASName.k_Helvetica.asString());
        }
        Attribute fontsize = oFont.getAttributeByName("size", false);
        if (fontsize != null) {
            double size = AFMLAttribute__Abstract.convertAFMLLengthToPoints(fontsize.getAttrValue());
            if (size > 0.0) {
                styleAttributes.setFontSize(size);
            } else if (styleAttributes.getFontSize() <= 0.0) {
                styleAttributes.setFontSize(12.0);
            }
        }
    }

    private static void getTextUnderlineFromXFA(StyleAttributes styleAttributes, Element oFont) {
        boolean bFullUnderline = oFont.getEnum(XFA.UNDERLINEPERIODTAG) == 0x130000;
        int eUnderLine = oFont.getEnum(XFA.UNDERLINETAG);
        if (eUnderLine == 0x120001) {
            styleAttributes.setTextDecorationUnderline(bFullUnderline ? "underline" : "word");
        } else if (eUnderLine == 0x120002) {
            styleAttributes.setTextDecorationUnderline(bFullUnderline ? "double" : "double word");
        }
    }

    private static void getTextLinethroughFromXFA(StyleAttributes styleAttributes, Element oFont) {
        int eLineThrough = oFont.getEnum(XFA.LINETHROUGHTAG);
        if (eLineThrough == 786433) {
            styleAttributes.setTextDecorationStrikeThrough("line-through");
        } else if (eLineThrough == 786434) {
            styleAttributes.setTextDecorationStrikeThrough("double-line-through");
        }
    }

    private static void getLetterSpacingFromXFA(StyleAttributes styleAttributes, Element oFont, PDFDocument doc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (oFont.isPropertySpecified(XFA.LETTERSPACINGTAG, true, 0)) {
            String letterSpacingValue = oFont.getAttribute(XFA.LETTERSPACINGTAG).getAttrValue();
            TextMeasurement oMeasure2 = TextMeasurement.fromString(letterSpacingValue);
            int letterSpacingUnit = oMeasure2.getType();
            styleAttributes.setLetterSpacingUnit(letterSpacingUnit);
            if (letterSpacingUnit == 0) {
                Measurement oMeasure = new Measurement(oFont.getAttribute(XFA.LETTERSPACINGTAG));
                styleAttributes.setLetterSpacing(String.valueOf(oMeasure.getValueAsUnit(0x3C0000)));
            } else if (letterSpacingUnit == 2) {
                String currentFontName = styleAttributes.getFontName();
                PDFFont currentFontObj = doc.getInteractiveForm().procureResources().getFont(ASName.create(currentFontName));
                double spaceCharacterWidth = currentFontObj.getGlyphWidth(currentFontObj.getSpaceCharCode());
                double d = oMeasure2.getScale();
                d *= spaceCharacterWidth;
                styleAttributes.setLetterSpacing(String.valueOf(d /= 1000.0));
            } else {
                double d = oMeasure2.getScale();
                styleAttributes.setLetterSpacing(String.valueOf(d));
            }
        } else {
            styleAttributes.setLetterSpacing("0");
            styleAttributes.setLetterSpacingUnit(0);
        }
    }

    private static void getMarginFromXFA(RCGOptions rcgOptions, Field oField, boolean useDefaultMarginValue) throws PDFInvalidParameterException {
        Element oCurrentUI;
        UI oUI = (UI)oField.peekElement(XFA.UITAG, false, 0);
        if (oUI != null && (oCurrentUI = oUI.getUIElement(true)) != null && oCurrentUI.isPropertyValid(XFA.MARGINTAG)) {
            double paddingValue;
            Element oMargins = oCurrentUI.peekElement(XFA.MARGINTAG, true, 0);
            Measurement oMeasure = (Measurement)oMargins.getAttribute(XFA.LEFTINSETTAG, !useDefaultMarginValue, false);
            if (oMeasure != null) {
                paddingValue = oMeasure.getValueAsUnit(0x3C0000);
                rcgOptions.setPaddingLeft(paddingValue);
            }
            if ((oMeasure = (Measurement)oMargins.getAttribute(XFA.TOPINSETTAG, !useDefaultMarginValue, false)) != null) {
                paddingValue = oMeasure.getValueAsUnit(0x3C0000);
                rcgOptions.setPaddingTop(paddingValue);
            }
            if ((oMeasure = (Measurement)oMargins.getAttribute(XFA.RIGHTINSETTAG, !useDefaultMarginValue, false)) != null) {
                paddingValue = oMeasure.getValueAsUnit(0x3C0000);
                rcgOptions.setPaddingRight(paddingValue);
            }
            if ((oMeasure = (Measurement)oMargins.getAttribute(XFA.BOTTOMINSETTAG, !useDefaultMarginValue, false)) != null) {
                paddingValue = oMeasure.getValueAsUnit(0x3C0000);
                rcgOptions.setPaddingBottom(paddingValue);
            }
        }
    }

    private static void getVericalAlignmentFromXFA(RCGOptions options, Element oPara) {
        int vAlignVal = oPara.getEnum(XFA.VALIGNTAG);
        switch (vAlignVal) {
            case 0x3E0000: {
                options.setVerticalAlignment(RCGAlignment.Top);
                break;
            }
            case 4063234: {
                options.setVerticalAlignment(RCGAlignment.Bottom);
                break;
            }
            case 4063233: {
                options.setVerticalAlignment(RCGAlignment.Middle);
                break;
            }
        }
    }

    private static void getPasswordCharFromXFA(Field oField, AppearanceAttributes appearanceAttributes) {
        String xfaPasswordChar;
        Element oCurrentUI;
        UI oUI = (UI)oField.peekElement(XFA.UITAG, false, 0);
        if (oUI != null && (oCurrentUI = oUI.getUIElement(true)) != null && oCurrentUI.isSameClass(XFA.PASSWORDEDITTAG) && !(xfaPasswordChar = oCurrentUI.getAttribute(XFA.PASSWORDCHARTAG).getAttrValue()).trim().equals("")) {
            appearanceAttributes.setPasswordChar(xfaPasswordChar.charAt(0));
        }
    }

    private static void getHorizontalAlignmentFromXFA(StyleAttributes styleAttributes, Element oPara) {
        int hAlignVal = oPara.getEnum(XFA.HALIGNTAG);
        switch (hAlignVal) {
            case 0x160000: {
                styleAttributes.setTextAlignment(0);
                break;
            }
            case 0x160001: {
                styleAttributes.setTextAlignment(1);
                break;
            }
            case 1441794: {
                styleAttributes.setTextAlignment(2);
                break;
            }
        }
    }

    private static void getLineHeightFromXFA(StyleAttributes styleAttributes, Element oPara) {
        if (oPara.isPropertySpecified(XFA.LINEHEIGHTTAG, true, 0)) {
            double value = ((Measurement)oPara.getAttribute(XFA.LINEHEIGHTTAG)).getValueAsUnit(0x3C0000);
            styleAttributes.setLineHeight(String.valueOf(value));
        }
    }

    private static void getTextIndentFromXFA(StyleAttributes styleAttributes, Element oPara) {
        if (oPara.isPropertySpecified(XFA.TEXTINDENTTAG, true, 0)) {
            double value = ((Measurement)oPara.getAttribute(XFA.TEXTINDENTTAG)).getValueAsUnit(0x3C0000);
            styleAttributes.setTextIndent(String.valueOf(value));
        }
    }

    private int getXFAVersion() {
        if (this.xfaDom != null) {
            TemplateModel model = this.xfaDom.getTemplateModel();
            if (model != null) {
                return model.getCurrentVersion();
            }
            return 0;
        }
        return 0;
    }

    private static String synchRichTextWithPlainText(PDFDocument curDoc, PDFField pdfField, PDFVariableText varText, String style, char passwordChar, boolean isXFAProcessed) throws PDFIOException, PDFInvalidDocumentException, PDFInvalidParameterException, PDFSecurityException {
        String styleStrippedQuote;
        boolean replaceRV = false;
        String valueText = null;
        if (varText.getRichText() != null && pdfField.getValueList() != null && pdfField instanceof PDFFieldText) {
            valueText = varText.getRichText();
            RichTextHandler handler = new RichTextHandler();
            String richTextRawString = handler.getRawContent(varText.getRichText());
            List valueVList = pdfField.getValueList();
            if (valueVList == null || valueVList.isEmpty() || richTextRawString == null || richTextRawString.length() == 0) {
                replaceRV = true;
            } else {
                boolean promotePlainText;
                if (valueVList.size() > 1) {
                    throw new PDFInvalidDocumentException("A text field has more than one value.");
                }
                String stringValue = (String)valueVList.get(0);
                stringValue = stringValue.replaceAll("(\n\r)|(\r\n)|[\n]|[\r]", "");
                boolean promoteRichText = !PDFText.isUTF16(richTextRawString = richTextRawString.replaceAll("(\n\r)|(\r\n)|[\n]|[\r]", ""));
                boolean bl = promotePlainText = !PDFText.isUTF16(stringValue);
                if (promoteRichText && !promotePlainText) {
                    PDFText rawRichTextUTF16 = PDFText.newInstance(richTextRawString, true, curDoc);
                    richTextRawString = rawRichTextUTF16.stringValue();
                }
                if (!promoteRichText && promotePlainText) {
                    PDFText plainTextUTF16 = PDFText.newInstance(stringValue, true, curDoc);
                    stringValue = plainTextUTF16.stringValue();
                }
                if (promoteRichText) {
                    richTextRawString = richTextRawString.replaceAll("\u00a0", " ");
                    stringValue = stringValue.replaceAll("\u00a0", " ");
                }
                if (!stringValue.equals(richTextRawString)) {
                    replaceRV = true;
                }
            }
        }
        if ((replaceRV || varText.getRichText() == null || pdfField instanceof PDFFieldChoice) && (valueText = RichTextHandler.getRichTextForValue(pdfField, passwordChar, isXFAProcessed)) != null && replaceRV && style != null && style.trim().length() > 0 && (valueText = TextFormatterImpl.insertAttributeToXMLBody(valueText, styleStrippedQuote = " style=\"" + style.replaceAll("\"", "") + "\"")) != null) {
            varText.setRichText(valueText);
        }
        return valueText;
    }

    static String insertAttributeToXMLBody(String xml, String attr) {
        String ret = null;
        int idxBodyStartBracket = xml.indexOf(BODY_NAME_START);
        int idxBodyEndBracket = xml.indexOf(XML_END_TAG, idxBodyStartBracket);
        if (xml.indexOf(BODY_NAME_START) > -1 && idxBodyEndBracket > -1) {
            ret = xml.substring(0, idxBodyEndBracket) + attr + xml.substring(idxBodyEndBracket);
        }
        return ret;
    }

    @Override
    public void formatAndRenderText(AppearanceAttributes appearanceAttributes, PDFFontSet pdfFonts, Font psFont, AGMPort agmPort) throws PDFConfigurationException, PDFFontException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            PDFField field = appearanceAttributes.getField();
            boolean isNonComboBoxChoiceField = field instanceof PDFFieldChoice && !((PDFFieldChoice)field).isComboBox();
            String textString = appearanceAttributes.getTextValue();
            if (field instanceof PDFFieldText && appearanceAttributes.isRichText() && textString != null) {
                textString = RichTextHandler.processRichTextString(textString);
            }
            FormatXFAText textFormatter = new FormatXFAText(TextFormatterCompatibility.LATEST);
            RCGOptions options = appearanceAttributes.getRcgOptions();
            StyleAttributes styleAttributes = appearanceAttributes.getStyleAttributes();
            List<String> rawOptionValuesForListBox = null;
            if (isNonComboBoxChoiceField) {
                rawOptionValuesForListBox = TextFormatterImpl.getRawOptionsValuesList(appearanceAttributes);
                textString = TextFormatterImpl.buildListBoxAppearance(textString, (PDFFieldChoice)field);
                if (!appearanceAttributes.isAutoSize()) {
                    textString = this.getUpdatedOptionValuesList(textString, appearanceAttributes, textFormatter, psFont, pdfFonts, rawOptionValuesForListBox);
                }
            }
            FormatXFAResultInfo resultInfo = this.getFormattedTextRegion(textFormatter, psFont, pdfFonts, textString, appearanceAttributes);
            resultInfo = this.handleOverflow(appearanceAttributes, pdfFonts, psFont, field, isNonComboBoxChoiceField, textString, textFormatter, options, styleAttributes, rawOptionValuesForListBox, resultInfo);
            resultInfo.renderRegion(agmPort, 0, 0);
        }
        catch (InvalidFontException e) {
            throw new PDFFontException("Invalid Font in the Font Set.", e);
        }
        catch (UnsupportedFontException e) {
            throw new PDFUnsupportedFeatureException("Attempt to use unsupported font type.", e);
        }
        catch (FontLoadingException e) {
            throw new PDFFontException("Error loading a font.", e);
        }
        catch (AFMLExceptionInvalidParameter e) {
            throw new PDFInvalidDocumentException("Invalid document, error during text formatting. ", e);
        }
        catch (AGMException e) {
            throw new PDFInvalidDocumentException("Formatting error. " + e.getMessage(), e);
        }
        catch (AFMLException e) {
            throw new PDFInvalidDocumentException("Formatting error. " + e.getMessage(), e);
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException("Formatting error. " + e.getMessage(), e);
        }
    }

    protected FormatXFAResultInfo handleOverflow(AppearanceAttributes appearanceAttributes, PDFFontSet pdfFonts, Font psFont, PDFField field, boolean isNonComboBoxChoiceField, String textString, FormatXFAText textFormatter, RCGOptions options, StyleAttributes styleAttributes, List<String> rawOptionValuesForListBox, FormatXFAResultInfo resultInfo) throws AFMLException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFConfigurationException, PDFFontException, PDFInvalidParameterException {
        if (TextFormatterImpl.isTextOverflowedHorizontally(resultInfo, options)) {
            if (isNonComboBoxChoiceField) {
                int startIndex;
                for (int currIndex = startIndex = ((PDFFieldChoice)field).getTopIndex(); currIndex < rawOptionValuesForListBox.size(); ++currIndex) {
                    String currOptionString = rawOptionValuesForListBox.get(currIndex);
                    if (currOptionString == null) continue;
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(currOptionString);
                    FormatXFAResultInfo tempResultInfo = this.getFormattedTextRegion(textFormatter, psFont, pdfFonts, RichTextHandler.convertString2RichText(list), appearanceAttributes);
                    if (!TextFormatterImpl.isTextOverflowedHorizontally(tempResultInfo, options)) continue;
                    textString = AppearanceUtils.insertStyleAttribute(textString, TEXT_ALIGN_LEFT_CSS, TEXT_ALIGN_LEFT_ATTR, new int[]{currIndex - startIndex}, 0);
                }
                resultInfo = this.getFormattedTextRegion(textFormatter, psFont, pdfFonts, textString, appearanceAttributes);
            } else if (!appearanceAttributes.isMultiLine()) {
                styleAttributes.setTextAlignment(0);
                resultInfo = this.getFormattedTextRegion(textFormatter, psFont, pdfFonts, textString, appearanceAttributes);
            }
        }
        if ((options.getVerticalAlignment().equals(RCGAlignment.Middle) || options.getVerticalAlignment().equals(RCGAlignment.Bottom) || appearanceAttributes.isRichText() && TextFormatterImpl.getFirstTextVAlignInRichText(textString).equalsIgnoreCase(ALIGNMENT_MIDDLE)) && options.getOverflowMode().equals(RCGOverflowMode.Auto)) {
            String oldLineHeight = appearanceAttributes.getStyleAttributes().getLineHeight();
            double oldAdjstBelowBaselineFactor = options.getAdjustmentBelowBaselineFactor();
            if (!appearanceAttributes.isMultiLine() && TextFormatterImpl.isTextOverflowed(resultInfo, options, textString, appearanceAttributes.isRichText())) {
                styleAttributes.setLineHeight(String.valueOf(styleAttributes.getFontSize()));
                options.setAdjustmentBelowBaselineFactor(0.0);
                resultInfo = this.getFormattedTextRegion(textFormatter, psFont, pdfFonts, textString, appearanceAttributes);
            }
            styleAttributes.setLineHeight(oldLineHeight);
            options.setAdjustmentBelowBaselineFactor(oldAdjstBelowBaselineFactor);
            if (TextFormatterImpl.isTextOverflowed(resultInfo, options, textString, appearanceAttributes.isRichText())) {
                options.setVerticalAlignment(RCGAlignment.Top);
                textString = TextFormatterImpl.setTextVAlignInRichText(textString, ALIGNMENT_TOP);
                resultInfo = null;
                resultInfo = this.getFormattedTextRegion(textFormatter, psFont, pdfFonts, textString, appearanceAttributes);
            }
        } else if (appearanceAttributes.isMultiLine() && options.getOverflowMode().equals(RCGOverflowMode.Auto) && appearanceAttributes.isAutoSize()) {
            if (TextFormatterImpl.isTextOverflowed(resultInfo, options, textString, appearanceAttributes.isRichText())) {
                options.setOverflow(RCGOverflowMode.ShrinkToFit);
                resultInfo = null;
                resultInfo = this.getFormattedTextRegion(textFormatter, psFont, pdfFonts, textString, appearanceAttributes);
            }
        } else if (appearanceAttributes.isMultiLine() && options.getOverflowMode().equals(RCGOverflowMode.Auto)) {
            double overflowFactor = 1.0;
            if (TextFormatterImpl.isTextOverflowed(resultInfo, options, textString, appearanceAttributes.isRichText())) {
                options.setAdjustmentBelowBaselineFactor(0.0);
                FormatXFAResultInfo tempResultInfo = this.getFormattedTextRegion(textFormatter, psFont, pdfFonts, textString, appearanceAttributes);
                if (!TextFormatterImpl.isTextOverflowed(tempResultInfo, options, textString, appearanceAttributes.isRichText())) {
                    resultInfo = tempResultInfo;
                    double overflowMax = overflowFactor;
                    double overflowMin = 0.0;
                    for (int count = 0; count < 4; ++count) {
                        options.setAdjustmentBelowBaselineFactor((overflowMax + overflowMin) / 2.0);
                        tempResultInfo = this.getFormattedTextRegion(textFormatter, psFont, pdfFonts, textString, appearanceAttributes);
                        if (TextFormatterImpl.isTextOverflowed(tempResultInfo, options, textString, appearanceAttributes.isRichText())) {
                            overflowMax = (overflowMax + overflowMin) / 2.0;
                            continue;
                        }
                        resultInfo = tempResultInfo;
                        overflowMin = (overflowMax + overflowMin) / 2.0;
                    }
                }
            }
        }
        if (!appearanceAttributes.isRichText() && appearanceAttributes.isMultiLine() && appearanceAttributes.isAutoSize() && TextFormatterImpl.isTextOverflowed(resultInfo, options, textString, appearanceAttributes.isRichText())) {
            double currFontSize;
            options.setOverflow(RCGOverflowMode.Auto);
            double fontSizeUL = currFontSize = appearanceAttributes.getStyleAttributes().getFontSize();
            double fontSizeLL = 0.0;
            double bestFontSize = currFontSize;
            boolean isOverflowed = true;
            for (int i = 0; i < 10; ++i) {
                if (isOverflowed) {
                    fontSizeUL = currFontSize;
                } else {
                    fontSizeLL = currFontSize;
                }
                double newFontSize = (fontSizeUL + fontSizeLL) / 2.0;
                double ratio = Math.min(newFontSize, currFontSize) / Math.max(newFontSize, currFontSize);
                if (!(ratio < 0.999)) break;
                currFontSize = newFontSize;
                appearanceAttributes.getStyleAttributes().setFontSize(currFontSize);
                resultInfo = this.getFormattedTextRegion(textFormatter, psFont, pdfFonts, textString, appearanceAttributes);
                isOverflowed = TextFormatterImpl.isTextOverflowed(resultInfo, options, textString, appearanceAttributes.isRichText());
                if (isOverflowed) continue;
                bestFontSize = currFontSize;
            }
            if (isOverflowed) {
                appearanceAttributes.getStyleAttributes().setFontSize(bestFontSize);
                resultInfo = this.getFormattedTextRegion(textFormatter, psFont, pdfFonts, textString, appearanceAttributes);
            }
        }
        return resultInfo;
    }

    private static List<String> getRawOptionsValuesList(AppearanceAttributes appearanceAttributes) {
        ArrayList<String> rawValuesAsStringList = new ArrayList<String>();
        List rawValues = appearanceAttributes.getRawValuesList();
        Iterator iter = rawValues.iterator();
        if (iter != null) {
            while (iter.hasNext()) {
                Object optionItemObj = iter.next();
                String optionItemStr = null;
                if (optionItemObj instanceof String) {
                    optionItemStr = (String)optionItemObj;
                } else if (optionItemObj instanceof List) {
                    List optionItem = (List)optionItemObj;
                    if (optionItem.size() == 1) {
                        optionItemStr = (String)optionItem.get(0);
                    } else if (optionItem.size() == 2) {
                        optionItemStr = (String)optionItem.get(0);
                    }
                }
                rawValuesAsStringList.add(optionItemStr);
            }
        }
        return rawValuesAsStringList;
    }

    protected FormatXFAResultInfo getFormattedTextRegion(FormatXFAText textFormatter, Font psFont, PDFFontSet pdfFonts, String textString, AppearanceAttributes appearanceAttributes) throws PDFConfigurationException, PDFFontException, PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException {
        FormatXFAResultInfo resultInfo = null;
        boolean preserveOldBehaviour = false;
        try {
            ByteArrayInputStream textValue;
            try {
                textValue = new ByteArrayInputStream(textString.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Error decoding a rich text string: ", e);
            }
            if (appearanceAttributes.getRcgOptions().getVerticalAlignment() == RCGAlignment.Middle) {
                preserveOldBehaviour = true;
            }
            resultInfo = appearanceAttributes.isRichText() ? textFormatter.processXFAText(appearanceAttributes.getRcgOptions().getTargetRegion().toString(), appearanceAttributes.getStyleAttributes().getStyleString(), textValue, null, pdfFonts, preserveOldBehaviour) : textFormatter.processPlainText(appearanceAttributes.getRcgOptions().getTargetRegion().toString(), appearanceAttributes.getStyleAttributes().getStyleString(), textValue, null, psFont, pdfFonts.getFallbackFontSet(), preserveOldBehaviour);
        }
        catch (IOException e) {
            throw new PDFIOException("IO Exception FormatXFAText.processXFAText().", e);
        }
        catch (ParserConfigurationException e) {
            throw new PDFConfigurationException("Parser Configuration Exception FormatXFAText.processXFAText().", e);
        }
        catch (SAXException e) {
            throw new PDFConfigurationException("SAX Exception FormatXFAText.processXFAText()", e);
        }
        catch (InvalidFontException e) {
            throw new PDFFontException("Invalid Font in the Font Set.", e);
        }
        catch (UnsupportedFontException e) {
            throw new PDFUnsupportedFeatureException("Attempt to use unsupported font type.", e);
        }
        catch (FontLoadingException e) {
            throw new PDFFontException("Error loading a font.", e);
        }
        catch (FormattingException e) {
            throw new PDFFontException("Error formatting with a fontset.", e);
        }
        catch (AFMLExceptionInvalidParameter e) {
            throw new PDFInvalidDocumentException("Invalid document, error during text formatting.", e);
        }
        catch (AFMLExceptionUnsupportedFeature e) {
            throw new PDFUnsupportedFeatureException("Feature not supported, error during text formatting.", e);
        }
        catch (AGMException e) {
            throw new PDFInvalidDocumentException("Formatting error.", e);
        }
        catch (FontException e) {
            throw new PDFFontException("Error during text formatting.", e);
        }
        catch (PDFFontException e) {
            throw new PDFFontException("Error while gettin fallback font set", e);
        }
        if (resultInfo == null) {
            throw new PDFInvalidDocumentException("FormatXFAText returns invalid Null object.");
        }
        return resultInfo;
    }

    private static String getFirstTextVAlignInRichText(String text) {
        int idxStart = text.indexOf(PARA_NAME_TEXTVALIGN);
        if (idxStart > -1) {
            int idxEnd = text.indexOf(PARA_NAME_END, idxStart += PARA_NAME_TEXTVALIGN.length());
            if (idxEnd == -1) {
                return text.substring(idxStart).trim();
            }
            return text.substring(idxStart, idxEnd).trim();
        }
        return "";
    }

    private static String setTextVAlignInRichText(String text, String newVAlign) {
        int idxStart = text.indexOf(PARA_NAME_TEXTVALIGN);
        if (idxStart > -1) {
            int idxEnd = text.indexOf(PARA_NAME_END, idxStart);
            String replacedAttr = null;
            replacedAttr = idxEnd == -1 ? text.substring(idxStart) : text.substring(idxStart, idxEnd + 1);
            text = text.replaceAll(replacedAttr, PARA_NAME_TEXTVALIGN + newVAlign + PARA_NAME_END);
        }
        return text;
    }

    private static boolean isTextOverflowedHorizontally(FormatXFAResultInfo resultInfo, RCGOptions options) throws AFMLException, PDFInvalidDocumentException {
        ArrayList<RegionAndAnnotInfo> regionSizes = resultInfo.getRegionSizes();
        if (regionSizes != null && regionSizes.size() == 1) {
            double targetWidth;
            RegionAndAnnotInfo regionInfo = regionSizes.get(0);
            double resultWidth = regionInfo.getRight() - regionInfo.getLeft();
            return resultWidth > (targetWidth = options.getWidth() - options.getPaddingRight() - options.getPaddingLeft());
        }
        return false;
    }

    private static boolean isTextOverflowed(FormatXFAResultInfo resultInfo, RCGOptions options, String textValue, boolean isRichText) throws AFMLException, PDFInvalidDocumentException {
        ArrayList<RegionAndAnnotInfo> regionSizes = resultInfo.getRegionSizes();
        if (regionSizes != null) {
            if (regionSizes.size() == 1) {
                double targetHeight;
                RegionAndAnnotInfo regionInfo = regionSizes.get(0);
                double resultHeight = regionInfo.getTop() - regionInfo.getBottom();
                return resultHeight > (targetHeight = options.getHeight() - options.getPaddingBottom() - options.getPaddingTop());
            }
            if (regionSizes.isEmpty() && isRichText && new RichTextHandler().getRawContent(textValue) == null) {
                return false;
            }
        }
        throw new PDFInvalidDocumentException("FormatXFAText returns invalid region sizes arraylist object.");
    }

    private static String buildListBoxAppearance(String plainTextString, PDFFieldChoice field) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (field.getValueList() != null) {
            if (field.getValueList().size() == 0) {
                return plainTextString;
            }
            int[] indexArray = new int[1];
            if (field.getValueList().size() == 1) {
                indexArray[0] = PDFFieldUtils.getSelectedIndexForChoiceField((String)field.getValueList().get(0), field.getOptionList(), field.getQualifiedName());
                if (indexArray[0] == -1) {
                    return plainTextString;
                }
            } else if (field.hasIndexArray()) {
                indexArray = field.getIndexArray();
            }
            if (indexArray.length > 0) {
                plainTextString = AppearanceUtils.insertStyleAttribute(plainTextString, "background-color:rgb(153,193,218);;color:#000000", "background-color=\"rgb(153,193,218)\" color=\"rgb(0,0,0)\"", indexArray, 0);
            }
        }
        return plainTextString;
    }

    private String getUpdatedOptionValuesList(String originalOptionsList, AppearanceAttributes appearanceAttributes, FormatXFAText textFormatter, Font psFont, PDFFontSet pdfFonts, List<String> rawOptionValues) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFConfigurationException, PDFFontException, PDFInvalidParameterException, AFMLException {
        ArrayList<String> currentOptionList;
        int i;
        PDFFieldChoice choiceField = (PDFFieldChoice)appearanceAttributes.getField();
        if (choiceField.getValueList() == null || choiceField.getValueList().size() == 0) {
            return originalOptionsList;
        }
        int[] selectedValuesIndexArray = null;
        selectedValuesIndexArray = choiceField.getValueList().size() == 1 ? new int[]{PDFFieldUtils.getSelectedIndexForChoiceField((String)choiceField.getValueList().get(0), choiceField.getOptionList(), choiceField.getQualifiedName())} : choiceField.getIndexArray();
        if (selectedValuesIndexArray == null || selectedValuesIndexArray.length == 0 || selectedValuesIndexArray.length == 1 && selectedValuesIndexArray[0] == -1) {
            return originalOptionsList;
        }
        int firstSelectedValueIndex = selectedValuesIndexArray[0];
        int lastSelectedValueIndex = selectedValuesIndexArray[selectedValuesIndexArray.length - 1];
        int topIndex = choiceField.getTopIndex();
        if (topIndex > firstSelectedValueIndex || topIndex < 0) {
            topIndex = firstSelectedValueIndex;
        }
        RCGOptions options = appearanceAttributes.getRcgOptions();
        double totalPermittedHeight = appearanceAttributes.getRcgOptions().getHeight() - options.getPaddingBottom() - options.getPaddingTop();
        double currentHeight = 0.0;
        boolean overflow = false;
        for (i = firstSelectedValueIndex; i < rawOptionValues.size(); ++i) {
            currentOptionList = new ArrayList<String>();
            currentOptionList.add(rawOptionValues.get(i));
            currentHeight += this.getLineHeight(textFormatter, psFont, pdfFonts, RichTextHandler.convertString2RichText(currentOptionList), appearanceAttributes);
            if (currentHeight > totalPermittedHeight) {
                topIndex = firstSelectedValueIndex;
                overflow = true;
                break;
            }
            if (i == lastSelectedValueIndex) break;
        }
        if (!overflow && topIndex != firstSelectedValueIndex) {
            for (i = firstSelectedValueIndex - 1; i >= topIndex; --i) {
                currentOptionList = new ArrayList();
                currentOptionList.add(rawOptionValues.get(i));
                currentHeight += this.getLineHeight(textFormatter, psFont, pdfFonts, RichTextHandler.convertString2RichText(currentOptionList), appearanceAttributes);
                if (!(currentHeight > totalPermittedHeight)) continue;
                topIndex = i + 1;
                break;
            }
        }
        choiceField.setTopIndex(topIndex);
        return RichTextHandler.removeFirstNParaNodesFromRichText(topIndex, originalOptionsList);
    }

    private double getLineHeight(FormatXFAText textFormatter, Font psFont, PDFFontSet pdfFonts, String richText, AppearanceAttributes appearanceAttributes) throws PDFConfigurationException, PDFFontException, PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, AFMLException {
        FormatXFAResultInfo resultInfo = this.getFormattedTextRegion(textFormatter, psFont, pdfFonts, richText, appearanceAttributes);
        ArrayList<RegionAndAnnotInfo> regionSizes = resultInfo.getRegionSizes();
        if (regionSizes != null && regionSizes.size() == 1) {
            RegionAndAnnotInfo regionInfo = regionSizes.get(0);
            return regionInfo.getTop() - regionInfo.getBottom();
        }
        return 0.0;
    }
}

