/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.Jpeg2000;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Box;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxInfo;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Utils;
import java.io.IOException;

public class ROIDescriptionBox
extends Jpeg2000Box {
    private int numberOfRegionsOfInterest;
    private int[] regionOfInterestList;
    private int[] regionOfInterestTypeList;
    private int[] regionOfInterestCodingPriorityList;
    private long[] regionOfInterestHorizontalLocationList;
    private long[] regionOfInterestVerticalLocationList;
    private long[] regionOfInterestWidthList;
    private long[] regionOfInterestHeightList;

    ROIDescriptionBox(Jpeg2000BoxInfo boxInfo) {
        this.boxInfo = boxInfo;
    }

    public int getNumberOfRegionsOfInterest() throws IOException {
        this.lazilyPopulateFields();
        return this.numberOfRegionsOfInterest;
    }

    public int[] getRegionOfInterestList() throws IOException {
        this.lazilyPopulateFields();
        return this.regionOfInterestList;
    }

    public int[] getRegionOfInterestTypeList() throws IOException {
        this.lazilyPopulateFields();
        return this.regionOfInterestTypeList;
    }

    public int[] getRegionOfInterestCodingPriorityList() throws IOException {
        this.lazilyPopulateFields();
        return this.regionOfInterestCodingPriorityList;
    }

    public long[] getRegionOfInterestHorizontalLocationList() throws IOException {
        this.lazilyPopulateFields();
        return this.regionOfInterestHorizontalLocationList;
    }

    public long[] getRegionOfInterestVerticalLocationList() throws IOException {
        this.lazilyPopulateFields();
        return this.regionOfInterestVerticalLocationList;
    }

    public long[] getRegionOfInterestWidthList() throws IOException {
        this.lazilyPopulateFields();
        return this.regionOfInterestWidthList;
    }

    public long[] getRegionOfInterestHeightList() throws IOException {
        this.lazilyPopulateFields();
        return this.regionOfInterestHeightList;
    }

    @Override
    protected void lazilyPopulateFields() throws IOException {
        InputByteStream boxContents = this.boxInfo.getBoxContents();
        if (boxContents == null) {
            return;
        }
        try {
            this.numberOfRegionsOfInterest = Jpeg2000Utils.bytesToInteger(boxContents, 1);
            this.regionOfInterestList = new int[this.numberOfRegionsOfInterest];
            this.regionOfInterestTypeList = new int[this.numberOfRegionsOfInterest];
            this.regionOfInterestCodingPriorityList = new int[this.numberOfRegionsOfInterest];
            this.regionOfInterestHorizontalLocationList = new long[this.numberOfRegionsOfInterest];
            this.regionOfInterestVerticalLocationList = new long[this.numberOfRegionsOfInterest];
            this.regionOfInterestWidthList = new long[this.numberOfRegionsOfInterest];
            this.regionOfInterestHeightList = new long[this.numberOfRegionsOfInterest];
            for (int i = 0; i < this.numberOfRegionsOfInterest; ++i) {
                this.regionOfInterestList[i] = Jpeg2000Utils.bytesToInteger(boxContents, 1);
                this.regionOfInterestTypeList[i] = Jpeg2000Utils.bytesToInteger(boxContents, 1);
                this.regionOfInterestCodingPriorityList[i] = Jpeg2000Utils.bytesToInteger(boxContents, 1);
                this.regionOfInterestHorizontalLocationList[i] = Jpeg2000Utils.bytesToLong(boxContents, 4);
                this.regionOfInterestVerticalLocationList[i] = Jpeg2000Utils.bytesToLong(boxContents, 4);
                this.regionOfInterestWidthList[i] = Jpeg2000Utils.bytesToLong(boxContents, 4);
                this.regionOfInterestHeightList[i] = Jpeg2000Utils.bytesToLong(boxContents, 4);
            }
        }
        finally {
            this.boxInfo.clearContents();
        }
    }

    @Override
    protected void close() throws IOException {
        this.boxInfo.clearContents();
    }
}

