/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.Jpeg2000;

import com.adobe.internal.io.stream.InputByteStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public enum Jpeg2000BoxType {
    signatureBox,
    fileTypeBox,
    jp2HeaderBox,
    imageHeaderBox,
    bitsPerComponentBox,
    colourSpecificationBox,
    paletteBox,
    componentMappingBox,
    channelDefinitionBox,
    resolutionBox,
    captureResolutionBox,
    defaultDisplayResolutionBox,
    contiguousCodeStreamBox,
    intellectualPropertyBox,
    xmlBox,
    uuidBox,
    uuidInfoBox,
    uuidListBox,
    dataEntryURLBox,
    readerRequirementsBox,
    labelBox,
    codestreamHeaderBox,
    compositingLayerHeaderBox,
    colourGroupBox,
    opacityBox,
    codestreamRegistrationBox,
    dataReferenceBox,
    fragmentTableBox,
    fragmentListBox,
    mediaDataBox,
    compositionBox,
    compositionOptionsBox,
    instructionSetBox,
    desiredReproductionsBox,
    graphicsTechStandardOutputBox,
    roiDescriptionBox,
    crossReferenceBox,
    associationBox,
    numberListBox,
    binaryFilterBox,
    digitalSignatureBox,
    mpeg7BinaryBox,
    freeBox;

    private static final Map<String, Jpeg2000BoxType> hexStringToBoxType;

    static Jpeg2000BoxType getInstance(InputByteStream data) throws IOException {
        String name = Long.toHexString(data.read() << 24 | data.read() << 16 | data.read() << 8 | data.read()).toUpperCase();
        return hexStringToBoxType.get(name);
    }

    static {
        hexStringToBoxType = new HashMap<String, Jpeg2000BoxType>();
        hexStringToBoxType.put("6A502020", signatureBox);
        hexStringToBoxType.put("72657320", resolutionBox);
        hexStringToBoxType.put("66747970", fileTypeBox);
        hexStringToBoxType.put("72657363", captureResolutionBox);
        hexStringToBoxType.put("6A703268", jp2HeaderBox);
        hexStringToBoxType.put("72657364", defaultDisplayResolutionBox);
        hexStringToBoxType.put("69686472", imageHeaderBox);
        hexStringToBoxType.put("6A703263", contiguousCodeStreamBox);
        hexStringToBoxType.put("62706363", bitsPerComponentBox);
        hexStringToBoxType.put("6A703269", intellectualPropertyBox);
        hexStringToBoxType.put("636F6C72", colourSpecificationBox);
        hexStringToBoxType.put("786D6C20", xmlBox);
        hexStringToBoxType.put("70636C72", paletteBox);
        hexStringToBoxType.put("75756964", uuidBox);
        hexStringToBoxType.put("636D6170", componentMappingBox);
        hexStringToBoxType.put("75696E66", uuidInfoBox);
        hexStringToBoxType.put("63646566", channelDefinitionBox);
        hexStringToBoxType.put("756C7374", uuidListBox);
        hexStringToBoxType.put("75726C20", dataEntryURLBox);
        hexStringToBoxType.put("6674626C", fragmentTableBox);
        hexStringToBoxType.put("72726571", readerRequirementsBox);
        hexStringToBoxType.put("666C7374", fragmentListBox);
        hexStringToBoxType.put("6C626C20", labelBox);
        hexStringToBoxType.put("6D646174", mediaDataBox);
        hexStringToBoxType.put("6A706368", codestreamHeaderBox);
        hexStringToBoxType.put("636F6D70", compositionBox);
        hexStringToBoxType.put("6A706C68", compositingLayerHeaderBox);
        hexStringToBoxType.put("636F7074", compositionOptionsBox);
        hexStringToBoxType.put("63677270", colourGroupBox);
        hexStringToBoxType.put("696E7374", instructionSetBox);
        hexStringToBoxType.put("6F706374", opacityBox);
        hexStringToBoxType.put("64726570", desiredReproductionsBox);
        hexStringToBoxType.put("63726567", codestreamRegistrationBox);
        hexStringToBoxType.put("6774736F", graphicsTechStandardOutputBox);
        hexStringToBoxType.put("6474626C", dataReferenceBox);
        hexStringToBoxType.put("726F6964", roiDescriptionBox);
        hexStringToBoxType.put("63726566", crossReferenceBox);
        hexStringToBoxType.put("61736F63", associationBox);
        hexStringToBoxType.put("6E6C7374", numberListBox);
        hexStringToBoxType.put("6266696C", binaryFilterBox);
        hexStringToBoxType.put("6368636B", digitalSignatureBox);
        hexStringToBoxType.put("6D703762", mpeg7BinaryBox);
        hexStringToBoxType.put("66726565", freeBox);
    }
}

