/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.Jpeg2000;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Box;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxInfo;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Utils;
import java.io.IOException;

public class ImageHeaderBox
extends Jpeg2000Box {
    private long height;
    private long width;
    private int numberOfComponents;
    private byte bitsPerComponent;
    private int compressionType;
    private int colourSpaceUnknown;
    private int intellectualProperty;

    ImageHeaderBox(Jpeg2000BoxInfo boxInfo) {
        this.boxInfo = boxInfo;
    }

    public long getHeight() throws IOException {
        this.lazilyPopulateFields();
        return this.height;
    }

    public long getWidth() throws IOException {
        this.lazilyPopulateFields();
        return this.width;
    }

    public int getNumberOfComponents() throws IOException {
        this.lazilyPopulateFields();
        return this.numberOfComponents;
    }

    public byte getBitsPerComponent() throws IOException {
        this.lazilyPopulateFields();
        return this.bitsPerComponent;
    }

    public int getCompressionType() throws IOException {
        this.lazilyPopulateFields();
        return this.compressionType;
    }

    public int getColourSpaceUnknown() throws IOException {
        this.lazilyPopulateFields();
        return this.colourSpaceUnknown;
    }

    public int getIntellectualProperty() throws IOException {
        this.lazilyPopulateFields();
        return this.intellectualProperty;
    }

    @Override
    protected void lazilyPopulateFields() throws IOException {
        InputByteStream boxContents = this.boxInfo.getBoxContents();
        if (boxContents == null) {
            return;
        }
        try {
            this.height = Jpeg2000Utils.bytesToLong(boxContents, 4);
            this.width = Jpeg2000Utils.bytesToLong(boxContents, 4);
            this.numberOfComponents = Jpeg2000Utils.bytesToInteger(boxContents, 2);
            this.bitsPerComponent = (byte)boxContents.read();
            this.compressionType = Jpeg2000Utils.bytesToInteger(boxContents, 1);
            this.colourSpaceUnknown = Jpeg2000Utils.bytesToInteger(boxContents, 1);
            this.intellectualProperty = Jpeg2000Utils.bytesToInteger(boxContents, 1);
        }
        finally {
            this.boxInfo.clearContents();
        }
    }

    @Override
    protected void close() throws IOException {
        this.boxInfo.clearContents();
    }
}

