/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.Jpeg2000;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.CompositionOptionsBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.InstructionSetBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Box;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxInfo;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxType;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxesList;
import java.io.IOException;

public class CompositionBox
extends Jpeg2000Box {
    private CompositionOptionsBox compositionOptionsBox;
    private Jpeg2000BoxesList<InstructionSetBox> instructionSetBoxesList;

    CompositionBox(Jpeg2000BoxInfo boxInfo) {
        this.boxInfo = boxInfo;
    }

    public CompositionOptionsBox getCompositionOptionsBox() throws IOException {
        this.lazilyPopulateFields();
        return this.compositionOptionsBox;
    }

    public Jpeg2000BoxesList<InstructionSetBox> getInstructionSetBoxesList() throws IOException {
        this.lazilyPopulateFields();
        return this.instructionSetBoxesList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void lazilyPopulateFields() throws IOException {
        InputByteStream boxContents = this.boxInfo.getBoxContents();
        if (boxContents == null) {
            return;
        }
        try {
            this.instructionSetBoxesList = new Jpeg2000BoxesList();
            block7: while (boxContents.bytesAvailable() > 0L) {
                Jpeg2000BoxInfo innerBoxInfo = new Jpeg2000BoxInfo(boxContents);
                Jpeg2000BoxType innerBoxType = innerBoxInfo.getType();
                if (innerBoxType == null) continue;
                switch (innerBoxType) {
                    case compositionOptionsBox: {
                        this.compositionOptionsBox = new CompositionOptionsBox(innerBoxInfo);
                        continue block7;
                    }
                    case instructionSetBox: {
                        this.instructionSetBoxesList.add(new InstructionSetBox(innerBoxInfo));
                        continue block7;
                    }
                }
            }
        }
        finally {
            this.boxInfo.clearContents();
        }
    }

    @Override
    protected void close() throws IOException {
        try {
            if (this.compositionOptionsBox != null) {
                this.compositionOptionsBox.close();
            }
        }
        finally {
            try {
                if (this.instructionSetBoxesList != null) {
                    this.instructionSetBoxesList.close();
                }
            }
            finally {
                this.boxInfo.clearContents();
            }
        }
    }
}

