/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.Jpeg2000;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Box;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxInfo;
import java.io.IOException;

public class BinaryFilterBox
extends Jpeg2000Box {
    private InputByteStream filterType;
    private InputByteStream data;

    BinaryFilterBox(Jpeg2000BoxInfo boxInfo) {
        this.boxInfo = boxInfo;
    }

    public InputByteStream getFilterType() throws IOException {
        this.lazilyPopulateFields();
        return this.filterType != null ? this.filterType.slice() : null;
    }

    public InputByteStream getData() throws IOException {
        this.lazilyPopulateFields();
        return this.data != null ? this.data.slice() : null;
    }

    @Override
    protected void lazilyPopulateFields() throws IOException {
        InputByteStream boxContents = this.boxInfo.getBoxContents();
        if (boxContents == null) {
            return;
        }
        try {
            this.filterType = boxContents.slice(0L, 16L);
            this.data = boxContents.slice(16L, boxContents.bytesAvailable() - 16L);
        }
        finally {
            this.boxInfo.clearContents();
        }
    }

    @Override
    protected void close() throws IOException {
        try {
            if (this.filterType != null) {
                this.filterType.close();
            }
        }
        finally {
            try {
                if (this.data != null) {
                    this.data.close();
                }
            }
            finally {
                this.boxInfo.clearContents();
            }
        }
    }
}

