/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.rendering;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.rendering.PDFHalfToneType;
import com.adobe.internal.pdftoolkit.pdf.rendering.PDFHalftone;

public class PDFHalftoneType5
extends PDFHalftone {
    private PDFHalftoneType5(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    public static PDFHalftoneType5 newInstance(PDFDocument pdfDocument, CosDictionary key_Default) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (key_Default == null) {
            throw new PDFInvalidParameterException("Default is required when creating newInstance of PDFHalftoneType5.");
        }
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFHalftoneType5 pdfObject = new PDFHalftoneType5(cosObject);
        pdfObject.setHalftoneType(PDFHalfToneType.HALFTONE_TYPE5);
        pdfObject.setDefault(key_Default);
        return pdfObject;
    }

    public static PDFHalftoneType5 getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFHalftoneType5 pdfObject = (PDFHalftoneType5)PDFCosObject.getCachedInstance(cosObject, PDFHalftoneType5.class);
        if (pdfObject == null) {
            pdfObject = new PDFHalftoneType5(cosObject);
        }
        return pdfObject;
    }

    public CosDictionary getDefaultAsDict() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDictionaryValue(ASName.k_Default);
    }

    public void setDefault(CosDictionary value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("Default is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(ASName.k_Default, value);
    }

    public CosStream getDefaultAsStream() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryValue(ASName.k_Default);
        if (cosObject instanceof CosStream) {
            return (CosStream)cosObject;
        }
        return null;
    }

    public void setDefault(CosStream value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("Default is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(ASName.k_Default, value);
    }

    public boolean hasDefault() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Default);
    }
}

