/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.rendering;

import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.rendering.PDFHalfToneType;

public abstract class PDFHalftone
extends PDFCosDictionary {
    protected PDFHalftone(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    public boolean hasType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Type);
    }

    public ASString getHalftoneName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryStringValue(ASName.k_HalftoneName);
    }

    public void setHalftoneName(ASString value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("HalftoneName is a required key therefore cannot be removed.");
        }
        this.setDictionaryASStringValue(ASName.k_HalftoneName, value);
    }

    public void setHalftoneName(byte[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("HalftoneName is a required key therefore cannot be removed.");
        }
        this.setDictionaryByteArrayValue(ASName.k_HalftoneName, value);
    }

    public boolean hasHalftoneName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_HalftoneName);
    }

    public int getHalftoneType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_HalftoneType);
    }

    public int requireHalftoneType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryCosObjectValue(ASName.k_HalftoneType);
        if (!(cosObject instanceof CosNumeric)) {
            throw new PDFInvalidDocumentException("Unable to get HalftoneType.");
        }
        return ((CosNumeric)cosObject).intValue();
    }

    public boolean hasHalftoneType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_HalftoneType);
    }

    protected void setHalftoneType(PDFHalfToneType halfTone_Type) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (halfTone_Type == null) {
            this.removeValue(ASName.k_HalftoneType);
        } else {
            this.setDictionaryIntValue(ASName.k_HalftoneType, halfTone_Type.getValue());
        }
    }
}

