/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.page;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosArrayList;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageTreeNode;

public class PDFPageTreeList
extends PDFCosArrayList<PDFPageTreeNode> {
    private PDFPageTreeList(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFPageTreeList getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFPageTreeList pdfObject = (PDFPageTreeList)PDFCosObject.getCachedInstance(cosObject, PDFPageTreeList.class);
        if (pdfObject == null) {
            pdfObject = new PDFPageTreeList(cosObject);
        }
        return pdfObject;
    }

    static PDFPageTreeList newInstance(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray kidsArray = pdfDoc.getCosDocument().createCosArray();
        return new PDFPageTreeList(kidsArray);
    }

    @Override
    protected PDFPageTreeNode itemInstantiator(CosObject cosObject) throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!(cosObject instanceof CosDictionary)) {
            throw new PDFInvalidDocumentException("Object should be instance of Cos Dictionary");
        }
        CosDictionary cosItem = (CosDictionary)cosObject;
        CosObject typeObj = cosItem.get(ASName.k_Type);
        if (typeObj != null && !(typeObj instanceof CosName)) {
            throw new PDFInvalidDocumentException("CosName excpected, found" + typeObj.getClass() + ", objetc number: " + typeObj.getObjNum());
        }
        CosName type = (CosName)cosItem.get(ASName.k_Type);
        if (type != null && type.nameValue() == ASName.k_Pages || cosItem.containsKey(ASName.k_Kids)) {
            return PDFPageTreeNode.getInstance(cosObject);
        }
        return PDFPage.getInstance(cosObject);
    }
}

