/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.page;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interchange.PDFApplicationData;

public class PDFPagePiece
extends PDFCosDictionary {
    private PDFPagePiece(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFPagePiece getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFPagePiece pdfObject = (PDFPagePiece)PDFCosObject.getCachedInstance(cosObject, PDFPagePiece.class);
        if (pdfObject == null) {
            pdfObject = new PDFPagePiece(cosObject);
        }
        return pdfObject;
    }

    public static PDFPagePiece newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        return new PDFPagePiece(cosObject);
    }

    public PDFApplicationData getApplicationData(ASName key) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject appData = this.getDictionaryCosObjectValue(key);
        if (appData == null) {
            return null;
        }
        return appData.getType() == 6 ? PDFApplicationData.getInstance(appData) : null;
    }

    public void setApplicationData(ASName key, PDFApplicationData data) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(key, data);
    }
}

