/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFStream;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DVDict;

public class PDFRichMediaView
extends PDF3DVDict {
    public static final ASName k_Snapshot = ASName.create("Snapshot");
    public static final ASName k_Params = ASName.create("Params");

    private PDFRichMediaView(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFRichMediaView newInstance(PDFDocument pdfDocument, ASString key_ExternalName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (key_ExternalName == null) {
            throw new PDFInvalidParameterException("ExternalName is required when creating newInstance of RichMedia View.");
        }
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFRichMediaView pdfObject = new PDFRichMediaView(cosObject);
        pdfObject.setExternalName(key_ExternalName);
        pdfObject.setType(ASName.k_3DView);
        return pdfObject;
    }

    public static PDFRichMediaView getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFRichMediaView pdfObject = (PDFRichMediaView)PDFCosObject.getCachedInstance(cosObject, PDFRichMediaView.class);
        if (pdfObject == null) {
            pdfObject = new PDFRichMediaView(cosObject);
        }
        return pdfObject;
    }

    public PDFStream getSnapshot() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFStream.getInstance(this.getDictionaryCosObjectValue(k_Snapshot));
    }

    public void setSnapshot(PDFStream value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(k_Snapshot, value);
    }

    public boolean hasSnapshot() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_Snapshot);
    }

    public CosArray getParams() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = this.getDictionaryArrayValue(k_Params);
        if (cosArray != null) {
            return cosArray;
        }
        return PDFCosObject.newCosArray(this.getPDFDocument());
    }

    public void setParams(CosArray value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryArrayValue(k_Params, value);
    }

    public boolean hasParams() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_Params);
    }
}

