/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNamedEmbeddedFiles;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFRichMediaConfigurationList;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFRichMediaViewList;

public class PDFRichMediaContent
extends PDFCosDictionary {
    public static final ASName k_Assets = ASName.create("Assets");
    public static final ASName k_Configurations = ASName.create("Configurations");
    public static final ASName k_Views = ASName.create("Views");
    public static final ASName k_RichMediaContent = ASName.create("RichMediaContent");

    private PDFRichMediaContent(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFRichMediaContent newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFRichMediaContent pdfObject = new PDFRichMediaContent(cosObject);
        return pdfObject;
    }

    public static PDFRichMediaContent getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFRichMediaContent pdfObject = (PDFRichMediaContent)PDFCosObject.getCachedInstance(cosObject, PDFRichMediaContent.class);
        if (pdfObject == null) {
            pdfObject = new PDFRichMediaContent(cosObject);
        }
        return pdfObject;
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    public void setType(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            this.removeValue(ASName.k_Type);
        } else if (value.equals(k_RichMediaContent)) {
            this.setDictionaryNameValue(ASName.k_Type, value);
        } else {
            throw new PDFInvalidParameterException("Type value is not valid. " + k_RichMediaContent + " is expected.");
        }
    }

    public boolean hasType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Type);
    }

    public PDFNamedEmbeddedFiles getAssets() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFNamedEmbeddedFiles.getInstance(this.getDictionaryCosObjectValue(k_Assets));
    }

    public void setAssets(PDFNamedEmbeddedFiles value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(k_Assets, value);
    }

    public boolean hasAssets() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_Assets);
    }

    public PDFRichMediaConfigurationList getConfigurations() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryValue(k_Configurations);
        return PDFRichMediaConfigurationList.getInstance(cosObject);
    }

    public void setConfigurations(PDFRichMediaConfigurationList value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(k_Configurations, value);
    }

    public boolean hasConfigurations() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_Configurations);
    }

    public PDFRichMediaViewList getViews() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryValue(k_Views);
        return PDFRichMediaViewList.getInstance(cosObject);
    }

    public void setViews(PDFRichMediaViewList value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(k_Views, value);
    }

    public boolean hasViews() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_Views);
    }
}

