/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosArrayList;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFRichMediaConfiguration;

public class PDFRichMediaConfigurationList
extends PDFCosArrayList<PDFRichMediaConfiguration> {
    private PDFRichMediaConfigurationList(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFRichMediaConfigurationList getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFRichMediaConfigurationList pdfObject = (PDFRichMediaConfigurationList)PDFCosObject.getCachedInstance(cosObject, PDFRichMediaConfigurationList.class);
        if (pdfObject == null) {
            pdfObject = new PDFRichMediaConfigurationList(cosObject);
        }
        return pdfObject;
    }

    @Override
    protected PDFRichMediaConfiguration itemInstantiator(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFRichMediaConfiguration.getInstance(cosObject);
    }

    public static PDFRichMediaConfigurationList newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = PDFCosObject.newCosArray(pdfDocument);
        PDFRichMediaConfigurationList pdfObject = new PDFRichMediaConfigurationList(cosObject);
        return pdfObject;
    }

    public static PDFRichMediaConfigurationList newInstance(PDFDocument pdfDocument, PDFRichMediaConfigurationList configs) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (configs.size() > 0) {
            CosArray cosObject = PDFCosObject.makeCosArray(pdfDocument, configs);
            return PDFRichMediaConfigurationList.getInstance(cosObject);
        }
        return PDFRichMediaConfigurationList.newInstance(pdfDocument);
    }
}

