/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFMediaOffset;

public class PDFMustHonorMCS
extends PDFCosDictionary {
    private PDFMustHonorMCS(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFMustHonorMCS newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFMustHonorMCS pdfObject = new PDFMustHonorMCS(cosObject);
        return pdfObject;
    }

    public static PDFMustHonorMCS getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFMustHonorMCS pdfObject = (PDFMustHonorMCS)PDFCosObject.getCachedInstance(cosObject, PDFMustHonorMCS.class);
        if (pdfObject == null) {
            pdfObject = new PDFMustHonorMCS(cosObject);
        }
        return pdfObject;
    }

    public PDFMediaOffset getB() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFMediaOffset.getInstance(this.getDictionaryCosObjectValue(ASName.k_B));
    }

    public void setB(PDFMediaOffset value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_B, value);
    }

    public boolean hasB() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_B);
    }

    public PDFMediaOffset getE() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFMediaOffset.getInstance(this.getDictionaryCosObjectValue(ASName.k_E));
    }

    public void setE(PDFMediaOffset value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_E, value);
    }

    public boolean hasE() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_E);
    }
}

