/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFMediaClipData;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFMediaClipSection;

public abstract class PDFMediaClip
extends PDFCosDictionary {
    private static final ASName k_MCS = ASName.create("MCS");

    protected PDFMediaClip(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFMediaClip getInstance(CosObject cosObject) throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        if (!(cosObject instanceof CosDictionary)) {
            throw new PDFInvalidDocumentException("CosDictionary expected");
        }
        ASName nameSubtype = ((CosDictionary)cosObject).getName(ASName.k_S);
        if (nameSubtype == null) {
            throw new PDFInvalidDocumentException("Unknown type.");
        }
        if (nameSubtype == ASName.k_MCD) {
            return PDFMediaClipData.getInstance(cosObject);
        }
        if (nameSubtype == k_MCS) {
            return PDFMediaClipSection.getInstance(cosObject);
        }
        return null;
    }
}

