/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interchange.webcapture;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASDate;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interchange.PDFAliasedURL;
import com.adobe.internal.pdftoolkit.pdf.interchange.webcapture.PDFWebCaptureCommand;

public class PDFSourceInfo
extends PDFCosDictionary {
    private PDFSourceInfo(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFSourceInfo newInstance(PDFDocument pdfDocument, PDFAliasedURL key_AU) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (key_AU == null) {
            throw new PDFInvalidParameterException("AU is required when creating newInstance of PDFSourceInfo.");
        }
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFSourceInfo pdfObject = new PDFSourceInfo(cosObject);
        pdfObject.setAU(key_AU);
        return pdfObject;
    }

    public static PDFSourceInfo getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFSourceInfo pdfObject = (PDFSourceInfo)PDFCosObject.getCachedInstance(cosObject, PDFSourceInfo.class);
        if (pdfObject == null) {
            pdfObject = new PDFSourceInfo(cosObject);
        }
        return pdfObject;
    }

    public PDFAliasedURL getAUAsDict() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFAliasedURL.getInstance(this.getDictionaryCosObjectValue(ASName.k_AU));
    }

    public void setAU(PDFAliasedURL value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("AU is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(ASName.k_AU, value);
    }

    public ASString getAUAsString() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryStringValue(ASName.k_AU);
    }

    public void setAU(ASString value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("AU is a required key therefore cannot be removed.");
        }
        this.setDictionaryASStringValue(ASName.k_AU, value);
    }

    public void setAU(byte[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("AU is a required key therefore cannot be removed.");
        }
        this.setDictionaryByteArrayValue(ASName.k_AU, value);
    }

    public boolean hasAU() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_AU);
    }

    public int getSubmission() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_S);
    }

    public void setSubmission(int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_S, value);
    }

    public boolean hasSubmission() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_S);
    }

    public ASDate getExpirationDate() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDateValue(ASName.k_E);
    }

    public void setExpirationDate(ASDate value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value == null) {
            this.removeValue(ASName.k_E);
        } else {
            this.setDictionaryDateValue(ASName.k_E, value);
        }
    }

    public boolean hasExpiration() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_E);
    }

    public PDFWebCaptureCommand getC() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFWebCaptureCommand.getInstance(this.getDictionaryCosObjectValue(ASName.k_C));
    }

    public void setC(PDFWebCaptureCommand value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            this.removeValue(ASName.k_C);
        } else {
            this.setDictionaryValue(ASName.k_C, value);
        }
    }

    public boolean hasC() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_C);
    }

    public ASDate getTS() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDateValue(ASName.k_TS);
    }

    public void setTS(ASDate value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            this.removeValue(ASName.k_TS);
        } else {
            this.setDictionaryDateValue(ASName.k_TS, value);
        }
    }

    public boolean hasTimeStamp() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_TS);
    }
}

